/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.viewer;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.plugin.AbstractPluginWithStepper;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.core.plugin.PluginMAction;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.other.FileFilterExtention;
import com.dassault.cecilia.lib.mbsa.Stepper;
import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.lib.util.io.IndentWriter;
import com.dassault.cecilia.plugin.mbsa.viewer.ResViewer;
import java.awt.Component;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class PluginCmdXMLStepper
extends AbstractPluginWithStepper
implements PluginMAction {
    public String getInfo(String key) {
        if (key.equals("plugin.name")) {
            return ResViewer.getString("PLUGIN_XML_STEPPER_NAME");
        }
        if (key.equals("plugin.description") || key.equals("plugin.tooltip")) {
            return ResViewer.getString("PLUGIN_XML_STEPPER_REMARK");
        }
        if (key.equals("type")) {
            return "PluginAction";
        }
        return super.getInfo(key);
    }

    public Icon getIcon(String key) {
        if (key.equals("plugin.default")) {
            return ResIcoAbstract.getIconRes((URL)((Object)((Object)this)).getClass().getResource("A4-07.svg"));
        }
        return super.getIcon(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSession(Plugable launcher, Object params) {
        File fileXML = null;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setCurrentDirectory(new File(PlugableUtility.getStrOpt((Plugable)launcher, (String)"plugable.option.path", (String)".")));
        FileFilterExtention xmlFilter = new FileFilterExtention(ResMsgCore.getString((String)"FILE_TYPE_XML"), ".xml").verifyWrite(true);
        fileChooser.addChoosableFileFilter((FileFilter)xmlFilter);
        fileChooser.setFileFilter((FileFilter)xmlFilter);
        if (fileChooser.showSaveDialog(launcher.getWindow()) != 0) {
            return;
        }
        if (fileChooser.getSelectedFile() == null) {
            return;
        }
        fileXML = FileFilterExtention.addDefaultExtention((JFileChooser)fileChooser);
        launcher.setOption("plugable.option.path", fileXML.getParent());
        Stepper stepper = this.createStepper(launcher, params);
        if (stepper == null) {
            return;
        }
        try {
            if (!stepper.goInitialState()) {
                return;
            }
        }
        catch (StepperException se) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launcher.getWindow()), se.getMessage(), this.getInfo("plugin.name"), 0);
            return;
        }
        Writer writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(fileXML));
            this.exportXMLStepper(stepper, writer);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launcher.getWindow()), "Display result file : " + e.getMessage(), this.getInfo("plugin.name"), 0);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException closeE) {
                    closeE.printStackTrace();
                }
            }
        }
    }

    private void exportXMLStepper(Stepper stepper, Writer outWriter) throws IOException, StepperException {
        int nbr;
        int i;
        IndentWriter writer = new IndentWriter(outWriter, "\t");
        writer.write("<?xml version='1.0'?>\n");
        writer.write("<stepper-xml>\n");
        writer.addIndent(1);
        int nbrTr = stepper.getNbrTransition();
        if (nbrTr > 0) {
            writer.write("<transitions>\n");
            writer.addIndent(1);
            for (i = 1; i <= nbrTr; ++i) {
                String desc;
                writer.write("<transition");
                writer.write(" id='");
                writer.write(Integer.toString(i));
                writer.write("'");
                writer.write(" name='");
                writer.writeEscapeXML(stepper.getNameOfTransition(i));
                writer.write("'");
                if (stepper.withSimul()) {
                    double delay = stepper.isValidTransition(i);
                    writer.write(" valid='");
                    writer.write(delay < 0.0 ? "false" : "true");
                    writer.write("'");
                    if (delay < 1.0E308) {
                        writer.write(" delay='");
                        writer.write(Double.toString(delay));
                        writer.write("'");
                    }
                }
                if ((desc = stepper.getDescOfTransition(i)) != null && desc.length() > 0) {
                    writer.write(">\n");
                    writer.addIndent(1);
                    writer.write("<desc>");
                    writer.writeEscapeXML(desc);
                    writer.write("</desc>\n");
                    writer.addIndent(-1);
                    writer.write("</transition>\n");
                    continue;
                }
                writer.write("/>\n");
            }
            writer.addIndent(-1);
            writer.write("</transitions>\n");
        }
        if (stepper.withDomain()) {
            TreeSet<Integer> _domainsIDs = new TreeSet<Integer>();
            for (i = stepper.getNbrState(); i > 0; --i) {
                _domainsIDs.add(stepper.getDomainOfState(i));
            }
            for (i = stepper.getNbrFlow(); i > 0; --i) {
                _domainsIDs.add(stepper.getDomainOfFlow(i));
            }
            if (_domainsIDs.size() > 0) {
                writer.write("<domains>\n");
                writer.addIndent(1);
                block8: for (Integer domID : _domainsIDs) {
                    writer.write("<domain");
                    writer.write(" id='");
                    writer.write(Integer.toString(domID));
                    writer.write("'");
                    switch (domID) {
                        case 0: {
                            writer.write(" name='bool'/>\n");
                            continue block8;
                        }
                        case 1: {
                            writer.write(" name='int'/>\n");
                            continue block8;
                        }
                        case 2: {
                            writer.write(" name='float'/>\n");
                            continue block8;
                        }
                    }
                    Iterator strValues = stepper.getValuesOfDomain(domID.intValue()).iterator();
                    Iterator dblValues = stepper.getDoubleValuesOfDomain(domID.intValue()).iterator();
                    writer.write(">\n");
                    writer.addIndent(1);
                    while (strValues.hasNext()) {
                        writer.write("<value");
                        writer.write(" string='");
                        writer.writeEscapeXML((String)strValues.next());
                        writer.write("'");
                        writer.write(" double='");
                        writer.write(Double.toString((Double)dblValues.next()));
                        writer.write("'");
                        writer.write("/>\n");
                    }
                    writer.addIndent(-1);
                    writer.write("</domain>\n");
                }
                writer.addIndent(-1);
                writer.write("</domains>\n");
            }
        }
        if ((nbr = stepper.getNbrState()) > 0) {
            writer.write("<states>\n");
            writer.addIndent(1);
            for (int i2 = 1; i2 <= nbr; ++i2) {
                writer.write("<state");
                writer.write(" id='");
                writer.write(Integer.toString(i2));
                writer.write("'");
                writer.write(" name='");
                writer.writeEscapeXML(stepper.getNameOfState(i2));
                writer.write("'");
                writer.write(" value='");
                String value = stepper.getValueStringOfState(i2);
                writer.writeEscapeXML(value);
                writer.write("'");
                if (stepper.withDomain()) {
                    int idDomain = stepper.getDomainOfState(i2);
                    writer.write(" domain='");
                    writer.write(Integer.toString(idDomain));
                    writer.write("'");
                }
                writer.write("/>\n");
            }
            writer.addIndent(-1);
            writer.write("</states>\n");
        }
        if ((nbr = stepper.getNbrFlow()) > 0) {
            writer.write("<flows>\n");
            writer.addIndent(1);
            for (int i3 = 1; i3 <= nbr; ++i3) {
                writer.write("<flow");
                writer.write(" id='");
                writer.write(Integer.toString(i3));
                writer.write("'");
                writer.write(" name='");
                writer.writeEscapeXML(stepper.getNameOfFlow(i3));
                writer.write("'");
                if (stepper.withSimul()) {
                    writer.write(" value='");
                    String value = stepper.getValueStringOfFlow(i3);
                    writer.writeEscapeXML(value);
                    writer.write("'");
                }
                if (stepper.withDomain()) {
                    int idDomain = stepper.getDomainOfFlow(i3);
                    writer.write(" domain='");
                    writer.write(Integer.toString(idDomain));
                    writer.write("'");
                }
                writer.write("/>\n");
            }
            writer.addIndent(-1);
            writer.write("</flows>\n");
        }
        writer.addIndent(-1);
        writer.write("</stepper-xml>\n");
    }
}

