/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.viewer;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.table.CeciliaTable;
import com.dassault.cecilia.core.swing.table.LeftDotTableCellRenderer;
import com.dassault.cecilia.core.swing.table.TableDecoredRenderer;
import com.dassault.cecilia.dbobj.project.CriticityCriterion;
import com.dassault.cecilia.lib.util.io.IndentWriter;
import com.dassault.cecilia.lib.util.logging.LogUtility;
import com.dassault.cecilia.plugin.mbsa.viewer.DefaultFileFilter;
import com.dassault.cecilia.plugin.mbsa.viewer.DlgTargetsSelection;
import com.dassault.cecilia.plugin.mbsa.viewer.ResViewer;
import com.dassault.cecilia.plugin.mbsa.viewer.TargetModel;
import com.dassault.cecilia.plugin.mbsa.viewer.TargetValue;
import com.dassault.cecilia.plugin.mbsa.viewer.TargetsTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TargetsPanel
extends JPanel {
    private TargetsTableModel _modelTable;
    private TargetModel _defTgt;
    private JTable _ctrlTable;
    private CeciliaAction _ctrlAdd;
    private CeciliaAction _ctrlDel;
    private CeciliaAction _ctrlUp;
    private CeciliaAction _ctrlDown;
    private CeciliaAction _ctrlDef;
    private CeciliaAction _ctrlLoad;
    private CeciliaAction _ctrlSave;
    private CeciliaAction _ctrlLst;
    private JPopupMenu _popupList;
    private JFileChooser _dlgFile;
    private JRadioButton _ctrlFile;
    private JRadioButton _ctrlDatabase;
    private JComboBox<FileEnum> _ctrlFileOpt;
    private JComboBox<DbEnum> _ctrlDbOpt;
    public static final int OUT_FILE = 0;
    public static final int OUT_DB = 1;
    private int _outputType = 0;
    private String _title;
    private static final String OPT_FILE = DlgTargetsSelection.class.getName() + "#File";
    private static final String OPT_DB = DlgTargetsSelection.class.getName() + "#DB";
    private static DocumentBuilderFactory _dbf = null;
    private static final String XML_ELEM_ROOT = "cecilia.mbsa.targets";
    private static final String XML_ATTR_VERSION = "version";
    private static final String XML_ELEM_OUTPUT = "output";
    private static final String XML_ATTR_TYPE = "type";
    private static final String XML_ATTR_ENUM = "conflictAction";
    private static final String XML_ATTR_TYPE_FILE = "file";
    private static final String XML_ATTR_TYPE_DATABASE = "database";

    public TargetsPanel(TargetModel def, String title) {
        super(new GridBagLayout());
        this._title = title;
        this._defTgt = def;
        this._modelTable = new TargetsTableModel(def);
        this.initialise();
    }

    protected JPanel createOtherInfoPanel() {
        return null;
    }

    public void copyToCtrl(Plugable launcher) {
        this._ctrlFileOpt.setSelectedIndex(PlugableUtility.getIntOpt((Plugable)launcher, (String)(OPT_FILE + this.getClass().getName()), (int)0));
        this._ctrlDbOpt.setSelectedIndex(PlugableUtility.getIntOpt((Plugable)launcher, (String)(OPT_DB + this.getClass().getName()), (int)0));
        this.refreshOutSelection();
    }

    public void copyFromCtrl(Plugable launcher) {
        launcher.setOption(OPT_FILE + this.getClass().getName(), Integer.toString(this._ctrlFileOpt.getSelectedIndex()));
        launcher.setOption(OPT_DB + this.getClass().getName(), Integer.toString(this._ctrlDbOpt.getSelectedIndex()));
    }

    public String getTitle() {
        return this._title;
    }

    private void createDlgFile() {
        if (this._dlgFile == null) {
            this._dlgFile = new JFileChooser();
            this._dlgFile.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    String fname = f.getName().toLowerCase();
                    return fname.endsWith(".xml") || f.isDirectory();
                }

                @Override
                public String getDescription() {
                    return ResMsgCore.getString((String)"FILE_TYPE_XML");
                }
            });
            this._dlgFile.setFileSelectionMode(0);
        }
    }

    private File displayDlgFile(boolean save) {
        int result;
        this.createDlgFile();
        this._dlgFile.setCurrentDirectory(new File(PlugableUtility.getStrOpt((Plugable)this._defTgt.getPlugable(), (String)"plugable.option.path", (String)".")));
        int n = result = save ? this._dlgFile.showSaveDialog(this) : this._dlgFile.showOpenDialog(this);
        if (result == 1) {
            return null;
        }
        File file = this._dlgFile.getSelectedFile();
        this._defTgt.getPlugable().setOption("plugable.option.path", file.getParent());
        if (save) {
            String name = file.getName();
            int pos = name.lastIndexOf(46);
            if (pos == -1) {
                file = new File(file.getAbsolutePath() + ".xml");
            }
            if (file.exists() && 0 != JOptionPane.showConfirmDialog(JOptionCecilia.getTopContainerOf((Component)this), ResMsgCore.msgFormat((String)"FILE_MSG_EXIST_FRM", (Object[])new Object[]{file}))) {
                return null;
            }
        }
        return file;
    }

    protected void initialise() {
        this._ctrlLoad = new CeciliaAction(ResIcoCore.getImageIcon((String)"BUT_LOAD"), ResViewer.getString("ACTION_LOAD_MENU"), ResViewer.getString("ACTION_LOAD_TTIP")){

            public void actionPerformed(ActionEvent e) {
                TargetsPanel.this.load();
            }
        };
        this._ctrlSave = new CeciliaAction(ResIcoCore.getImageIcon((String)"BUT_SAVE"), ResViewer.getString("ACTION_SAVE_MENU"), ResViewer.getString("ACTION_SAVE_TTIP")){

            public void actionPerformed(ActionEvent e) {
                TargetsPanel.this.save();
            }
        };
        this._ctrlDef = new CeciliaAction(ResIcoCore.getImageIcon((String)"BUT_VALIDATE"), ResViewer.getString("ACTION_DEFAULT_MENU"), ResViewer.getString("ACTION_DEFAULT_TTIP")){

            public void actionPerformed(ActionEvent e) {
                int idx = TargetsPanel.this._ctrlTable.getSelectedRow();
                if (idx != -1) {
                    TargetsPanel.this._modelTable.defineDefault((TargetModel)TargetsPanel.this._modelTable.getItemAt(idx));
                    TargetsPanel.this.refreshCtrl();
                } else {
                    LogUtility.logStackTrace((Logger)LogUtility.getLog(TargetsPanel.class), (Level)Level.FINER, (String)"idx no correct");
                }
            }
        };
        this._ctrlLst = new CeciliaAction(ResIcoCore.getImageIcon((String)"BUT_CHGLIST"), ResViewer.getString("ACTION_CHG_LIST_MENU"), ResViewer.getString("ACTION_CHG_LIST_TTIP")){

            public void actionPerformed(ActionEvent e) {
                TargetsPanel.this.computeFiles();
                TargetsPanel.this.refreshCtrl();
            }
        };
        this._ctrlAdd = new CeciliaAction(ResIcoCore.getImageIcon((String)"BUT_ADD"), ResViewer.getString("ACTION_ADD_MENU"), ResViewer.getString("ACTION_ADD_TTIP")){

            public void actionPerformed(ActionEvent e) {
                int idx = TargetsPanel.this._ctrlTable.getSelectedRow();
                if (idx == -1 || idx == TargetsPanel.this._modelTable.getRowCount() - 1) {
                    TargetsPanel.this._modelTable.addData(null);
                    idx = TargetsPanel.this._modelTable.getRowCount() - 1;
                } else {
                    TargetsPanel.this._modelTable.insertData(null, ++idx);
                }
                TargetsPanel.this._ctrlTable.setRowSelectionInterval(idx, idx);
                TargetsPanel.this._ctrlTable.editCellAt(idx, 0);
                TargetsPanel.this.refreshCtrl();
            }
        };
        this._ctrlAdd.setEnabled(this._defTgt.getStepper() != null);
        this._ctrlDel = new CeciliaAction(ResIcoCore.getImageIcon((String)"BUT_DEL"), ResViewer.getString("ACTION_DEL_MENU"), ResViewer.getString("ACTION_DEL_TTIP")){

            public void actionPerformed(ActionEvent e) {
                int i;
                int[] viewRows = TargetsPanel.this._ctrlTable.getSelectedRows();
                if (viewRows.length == 0) {
                    return;
                }
                ArrayList<TargetModel> dels = new ArrayList<TargetModel>(viewRows.length);
                for (i = 0; i < viewRows.length; ++i) {
                    int modelRow = TargetsPanel.this._ctrlTable.convertRowIndexToModel(viewRows[i]);
                    TargetModel item = (TargetModel)TargetsPanel.this._modelTable.getItemAt(modelRow);
                    dels.add(item);
                }
                for (i = dels.size() - 1; i >= 0; --i) {
                    TargetsPanel.this._modelTable.removeData((TargetModel)dels.get(i));
                }
                TargetsPanel.this.refreshCtrl();
            }
        };
        this._ctrlUp = new CeciliaAction(ResIcoCore.getImageIcon((String)"BUT_UP"), ResViewer.getString("ACTION_UP_MENU"), ResViewer.getString("ACTION_UP_TTIP")){

            public void actionPerformed(ActionEvent e) {
                int[] indices = TargetsPanel.this._ctrlTable.getSelectedRows();
                if (indices.length == 0) {
                    return;
                }
                TargetsPanel.this._modelTable.up(indices);
                TargetsPanel.this._ctrlTable.clearSelection();
                for (int i = 0; i < indices.length; ++i) {
                    TargetsPanel.this._ctrlTable.addRowSelectionInterval(indices[i], indices[i]);
                }
                TargetsPanel.this.refreshCtrl();
            }
        };
        this._ctrlDown = new CeciliaAction(ResIcoCore.getImageIcon((String)"BUT_DOWN"), ResViewer.getString("ACTION_DOWN_MENU"), ResViewer.getString("ACTION_DOWN_TTIP")){

            public void actionPerformed(ActionEvent e) {
                int[] indices = TargetsPanel.this._ctrlTable.getSelectedRows();
                if (indices.length == 0) {
                    return;
                }
                TargetsPanel.this._modelTable.down(indices);
                TargetsPanel.this._ctrlTable.clearSelection();
                for (int i = 0; i < indices.length; ++i) {
                    TargetsPanel.this._ctrlTable.addRowSelectionInterval(indices[i], indices[i]);
                }
                TargetsPanel.this.refreshCtrl();
            }
        };
        JPanel root = new JPanel(new BorderLayout());
        root.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JToolBar toolbar = new JToolBar();
        toolbar.setBorder(CeciliaAction.STANDARD_BORDER);
        toolbar.setFloatable(false);
        toolbar.add(this._ctrlLoad.createButton(CeciliaAction.BorderStyle.LIGHT));
        toolbar.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        toolbar.add(this._ctrlSave.createButton(CeciliaAction.BorderStyle.LIGHT));
        toolbar.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        toolbar.add(this._ctrlDef.createButton(CeciliaAction.BorderStyle.LIGHT));
        toolbar.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        toolbar.add(this._ctrlLst.createButton(CeciliaAction.BorderStyle.LIGHT));
        toolbar.add(Box.createGlue());
        toolbar.add(this._ctrlAdd.createButton(CeciliaAction.BorderStyle.LIGHT));
        toolbar.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        toolbar.add(this._ctrlDel.createButton(CeciliaAction.BorderStyle.LIGHT));
        toolbar.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        toolbar.add(this._ctrlUp.createButton(CeciliaAction.BorderStyle.LIGHT));
        toolbar.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        toolbar.add(this._ctrlDown.createButton(CeciliaAction.BorderStyle.LIGHT));
        root.add((Component)toolbar, "North");
        this._popupList = new JPopupMenu();
        this._popupList.add((Action)this._ctrlAdd);
        this._popupList.add((Action)this._ctrlDel);
        this._popupList.add((Action)this._ctrlUp);
        this._popupList.add((Action)this._ctrlDown);
        this._popupList.addSeparator();
        this._popupList.add((Action)this._ctrlLoad);
        this._popupList.add((Action)this._ctrlSave);
        this._popupList.addSeparator();
        this._popupList.add((Action)this._ctrlDef);
        this._popupList.add((Action)this._ctrlLst);
        this._ctrlTable = new CeciliaTable((TableModel)((Object)this._modelTable));
        this._ctrlTable.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        this._ctrlTable.setDefaultRenderer(String.class, (TableCellRenderer)new LeftDotTableCellRenderer());
        this._ctrlTable.setDefaultRenderer(TargetValue.class, (TableCellRenderer)new TableDecoredRenderer());
        this._ctrlTable.setDefaultRenderer(CriticityCriterion.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value instanceof CriticityCriterion) {
                    this.setText(((CriticityCriterion)value).getName());
                }
                return this;
            }
        });
        this._ctrlTable.setPreferredScrollableViewportSize(new Dimension(400, 100));
        JScrollPane scrollTable = new JScrollPane(this._ctrlTable);
        scrollTable.setComponentPopupMenu(this._popupList);
        ListSelectionModel selMod = this._ctrlTable.getSelectionModel();
        selMod.setSelectionMode(2);
        selMod.addListSelectionListener(e -> this.refreshCtrl());
        TableColumnModel colModel = this._ctrlTable.getColumnModel();
        for (int i = 0; i < this._modelTable.getColumnCount(); ++i) {
            int width;
            TableColumn column = colModel.getColumn(i);
            TableCellEditor edit = this._modelTable._defTgt.getEditor(i);
            if (edit != null) {
                column.setCellEditor(edit);
            }
            if ((width = this._modelTable._defTgt.getDefaultWidth(i)) <= 0) continue;
            column.setPreferredWidth(width);
        }
        this._modelTable.addTableModelListener(e -> this.refreshCtrl());
        root.add((Component)scrollTable, "Center");
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBorder(BorderFactory.createTitledBorder(ResViewer.getString("DLG_TGT_SEL_TARGETS")));
        mainPanel.add((Component)root, "Center");
        mainPanel.add((Component)this.createTgtsOptionsOutput(), "South");
        this.add((Component)mainPanel, new GridBagConstraints(0, 0, 1, 1, 100.0, 100.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        JPanel otherInfoPanel = this.createOtherInfoPanel();
        if (otherInfoPanel != null) {
            this.add((Component)otherInfoPanel, new GridBagConstraints(0, 1, 1, 1, 100.0, 100.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        }
        this.refreshCtrl();
    }

    private JPanel createTgtsOptionsOutput() {
        JPanel result = new JPanel(new GridBagLayout());
        result.setBorder(BorderFactory.createTitledBorder(ResViewer.getString("DLG_TGT_SEL_OUTPUT")));
        ButtonGroup grp = new ButtonGroup();
        this._ctrlFile = new JRadioButton(ResViewer.getString("DLG_TGT_SEL_FILE"));
        result.add((Component)this._ctrlFile, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this._ctrlDatabase = new JRadioButton(ResViewer.getString("DLG_TGT_SEL_DB"));
        result.add((Component)this._ctrlDatabase, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        grp.add(this._ctrlFile);
        grp.add(this._ctrlDatabase);
        this._ctrlFile.setSelected(true);
        this._ctrlFileOpt = new JComboBox();
        this._ctrlFileOpt.addItem(FileEnum.OVERWRITE);
        this._ctrlFileOpt.addItem(FileEnum.CONFIRM);
        this._ctrlFileOpt.setSelectedIndex(0);
        result.add(this._ctrlFileOpt, new GridBagConstraints(1, 0, 1, 1, 100.0, 0.0, 13, 2, new Insets(2, 2, 2, 2), 0, 0));
        this._ctrlDbOpt = new JComboBox();
        this._ctrlDbOpt.addItem(DbEnum.OVERWRITE);
        this._ctrlDbOpt.addItem(DbEnum.DONOTIMPORT);
        this._ctrlDbOpt.addItem(DbEnum.NEWVERSION);
        this._ctrlDbOpt.setSelectedIndex(0);
        result.add(this._ctrlDbOpt, new GridBagConstraints(1, 1, 1, 1, 100.0, 0.0, 13, 2, new Insets(2, 2, 2, 2), 0, 0));
        this._ctrlFile.addActionListener(e -> {
            if (this._outputType != 0) {
                this.refreshOutputType(0, true);
            }
            this.refreshCtrlSaving();
        });
        this._ctrlDatabase.addActionListener(e -> {
            if (this._outputType != 1) {
                this.refreshOutputType(1, true);
            }
            this.refreshCtrlSaving();
        });
        this.refreshCtrlSaving();
        return result;
    }

    protected void refreshOutputType(int type, boolean clearPath) {
        this._outputType = type;
        this._modelTable.refreshOutputType(type, clearPath);
        this.refreshDBTableEditor();
    }

    protected void refreshOutSelection() {
        if (this._outputType == 0) {
            this._ctrlFile.setSelected(true);
        } else if (this._ctrlDatabase.isEnabled()) {
            this._ctrlDatabase.setSelected(true);
        }
        this.refreshOutputType(this._outputType, false);
    }

    protected void refreshCtrl() {
        int[] indices = this._ctrlTable.getSelectedRows();
        int nbr = this._ctrlTable.getRowCount();
        boolean error = this._modelTable.withError();
        this._ctrlSave.setEnabled(nbr > 0 && !error);
        this._ctrlDel.setEnabled(indices.length > 0);
        this._ctrlDef.setEnabled(indices.length == 1);
        this._ctrlUp.setEnabled(indices.length > 0 && indices[0] > 0);
        this._ctrlDown.setEnabled(indices.length > 0 && indices[indices.length - 1] < nbr - 1);
        this._ctrlLst.setEnabled(this.computableFiles());
    }

    protected void refreshCtrlSaving() {
        this._ctrlFileOpt.setEnabled(this._ctrlFile.isSelected());
        this._ctrlDbOpt.setEnabled(this._ctrlDatabase.isSelected());
    }

    protected void refreshDBTableEditor() {
        TableColumnModel colModel = this._ctrlTable.getColumnModel();
        TableColumn column = colModel.getColumn(1);
        TableCellEditor edit = this._modelTable._defTgt.getEditor(1);
        if (edit != null) {
            column.setCellEditor(edit);
        }
    }

    protected boolean computableFiles() {
        int size = this._modelTable.getRowCount();
        if (size == 0) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            TargetModel tgt = (TargetModel)this._modelTable.getItemAt(i);
            for (int j = 0; j < tgt.getColumnCount(); ++j) {
                if (j == 1 || !tgt.withError(j)) continue;
                return false;
            }
        }
        return true;
    }

    protected void computeFiles() {
        if (!this.computableFiles()) {
            return;
        }
        this.createDlgFile();
        JFileChooser dlg = new JFileChooser();
        dlg.setCurrentDirectory(new File(PlugableUtility.getStrOpt((Plugable)this._defTgt.getPlugable(), (String)"plugable.option.path", (String)".")));
        dlg.setFileSelectionMode(0);
        dlg.setFileFilter(this._defTgt.getFilter());
        JComponent accessory = this._defTgt.getFilter().getDefaultAccessory();
        if (accessory != null) {
            dlg.setAccessory(accessory);
        }
        if (dlg.showSaveDialog(this) == 1) {
            return;
        }
        File select = dlg.getSelectedFile();
        this._defTgt.getPlugable().setOption("plugable.option.path", select.getParent());
        Object path = select.getAbsolutePath();
        if (!this._defTgt.getFilter().accept(select)) {
            path = (String)path + this._defTgt.getFilter().getDefaultExtension();
        }
        for (int i = 0; i < this._modelTable.getRowCount(); ++i) {
            String tgtPath = ((String)path).replace("%num%", Integer.toString(i));
            tgtPath = ((TargetModel)this._modelTable.getItemAt(i)).replaceTgt(tgtPath);
            this._modelTable.setValueAt(tgtPath, i, 1);
        }
    }

    public boolean overwriteFile() {
        return this._ctrlFileOpt.getSelectedItem().equals((Object)FileEnum.OVERWRITE);
    }

    public String getDbSelectedOpt() {
        return ((DbEnum)((Object)this._ctrlDbOpt.getSelectedItem())).getCode();
    }

    public void enableDbOutput(boolean set) {
        this._ctrlDatabase.setEnabled(set);
        if (!set) {
            this.refreshOutputType(0, true);
            this.refreshOutSelection();
        }
        this.refreshCtrlSaving();
    }

    public void refreshFileFilter(DefaultFileFilter newFilter) {
        this._modelTable.refreshFileFilter(newFilter);
    }

    public boolean verifyParameters() {
        if (this._modelTable.getRowCount() == 0) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)this), ResViewer.getString("DLG_TGT_SEL_NO_TARGET"));
            return false;
        }
        if (this._modelTable.withError()) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)this), ResViewer.getString("DLG_TGT_SEL_ERROR_TARGET"));
            return false;
        }
        return this.verifyPath();
    }

    public List<TargetModel> getTargets() {
        return new ArrayList<TargetModel>(this._modelTable.getData());
    }

    public void processEraseFile(List<File> eraseFile, File file) {
        eraseFile.add(file);
    }

    protected boolean verifyPath() {
        File file;
        ArrayList<File> eraseFile = new ArrayList<File>();
        Iterator<TargetModel> i = this.getTargets().iterator();
        LinkedHashMap pathToTrees = new LinkedHashMap();
        LinkedHashSet<File> files = new LinkedHashSet<File>();
        int cpt = 0;
        while (i.hasNext()) {
            Object stopMsg = null;
            TargetModel tgt = i.next();
            String path = (String)tgt.getValueAt(1);
            if (path == null || path.length() == 0) {
                stopMsg = ResViewer.getString("FILE_ERROR_EMPTY");
            } else {
                file = null;
                if (this._outputType == 1) {
                    tgt.setPathTreeName(path);
                    int pos = path.lastIndexOf("/");
                    if (pos == -1) {
                        stopMsg = "Internal error : the path is not 'dbfolder' path : " + path;
                    } else {
                        String pathName = path.substring(0, pos);
                        String treeName = path.substring(path.lastIndexOf("/") + 1);
                        LinkedHashSet<String> anotherTrees = (LinkedHashSet<String>)pathToTrees.get(pathName.toLowerCase());
                        if (anotherTrees == null) {
                            anotherTrees = new LinkedHashSet<String>();
                            pathToTrees.put(pathName.toLowerCase(), anotherTrees);
                        }
                        if (anotherTrees.contains(treeName.toLowerCase())) {
                            stopMsg = ResMsgCore.msgFormat((String)"MSG_ERR_DAOTOOL_FOL_CHILDREN", (Object[])new Object[]{pathName, treeName});
                        } else {
                            StringBuilder sb;
                            anotherTrees.add(treeName.toLowerCase());
                            try {
                                File tmpPath = File.createTempFile(treeName, this.getFileExt());
                                tgt._pathResult = tmpPath.getAbsolutePath();
                                tmpPath.delete();
                            }
                            catch (IOException e) {
                                sb = new StringBuilder();
                                sb.append(System.getProperty("java.io.tmpdir"));
                                sb.append('/');
                                sb.append(treeName);
                                sb.append(this.getFileExt());
                                tgt._pathResult = sb.toString();
                            }
                            catch (IllegalArgumentException e) {
                                sb = new StringBuilder();
                                sb.append(System.getProperty("java.io.tmpdir"));
                                sb.append('/');
                                sb.append(treeName);
                                sb.append(this.getFileExt());
                                tgt._pathResult = sb.toString();
                            }
                            path = tgt._pathResult;
                        }
                    }
                }
                if (stopMsg == null) {
                    file = new File(path);
                    if (file.isFile()) {
                        if (!file.canWrite()) {
                            stopMsg = ResViewer.getString("FILE_ERROR_WRITE");
                        } else if (file.exists()) {
                            this.processEraseFile(eraseFile, file);
                        }
                    } else if (!file.getParentFile().isDirectory()) {
                        stopMsg = ResViewer.getString("FILE_ERROR_NOFILE");
                    } else if (file.isDirectory()) {
                        stopMsg = ResViewer.getString("FILE_ERROR_ISDIRECTORY");
                    }
                    if (this._outputType == 0) {
                        if (files.contains(file)) {
                            stopMsg = ResViewer.getString("DLG_TGT_SEL_FILES");
                        }
                        files.add(file);
                    }
                }
            }
            if (stopMsg != null) {
                this._ctrlTable.setRowSelectionInterval(cpt, cpt);
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)this), stopMsg, this.getTitle(), 0);
                return false;
            }
            ++cpt;
        }
        if (!eraseFile.isEmpty()) {
            int result;
            int min = Math.min(eraseFile.size(), 10);
            StringBuilder sb = new StringBuilder(min * 32);
            for (int cpt2 = 0; cpt2 < min; ++cpt2) {
                sb.append(((File)eraseFile.get(cpt2)).getPath());
                sb.append("\n");
            }
            if (eraseFile.size() > min) {
                sb.append("...\n");
            }
            if ((result = JOptionPane.showConfirmDialog(JOptionCecilia.getTopContainerOf((Component)this), ResViewer.msgFormat("FILE_MSG_EXIST_FILES", sb.toString()), this.getTitle(), 0)) == 1) {
                return false;
            }
            for (int cpt3 = 0; cpt3 < eraseFile.size(); ++cpt3) {
                file = (File)eraseFile.get(cpt3);
                if (file.delete()) continue;
                ResViewer.LOG.warning("File '" + file.getPath() + "' not delete");
            }
        }
        return true;
    }

    public String getFileExt() {
        return ".ara";
    }

    public TargetsTableModel getModelTable() {
        return this._modelTable;
    }

    public int getOutputType() {
        return this._outputType;
    }

    private void load() {
        File input = this.displayDlgFile(false);
        if (input == null) {
            return;
        }
        try {
            DocumentBuilder db;
            Document doc;
            Element root;
            if (_dbf == null) {
                _dbf = DocumentBuilderFactory.newInstance();
                _dbf.setValidating(false);
                _dbf.setIgnoringComments(true);
                _dbf.setIgnoringElementContentWhitespace(true);
                _dbf.setCoalescing(false);
                _dbf.setExpandEntityReferences(true);
            }
            if ((root = (doc = (db = _dbf.newDocumentBuilder()).parse(new File(input.getPath()))).getDocumentElement()).getNodeName().equals("targets")) {
                String out = this.getAttrValue(root, "outputType");
                if (out != null && out.length() > 0 && out.equals(XML_ATTR_TYPE_DATABASE)) {
                    if (!this._ctrlDatabase.isEnabled()) {
                        throw new IOException(ResViewer.getString("FILE_ERROR_OPEN_XML_OUTPUTTYPE"));
                    }
                    this._outputType = 1;
                } else {
                    this._outputType = 0;
                }
                this.refreshOutSelection();
                this._modelTable.load(root);
            } else {
                this.doLoad(root);
            }
            this.refreshCtrl();
            this.refreshCtrlSaving();
        }
        catch (IOException | ParserConfigurationException | SAXException e1) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)this), ResMsgCore.getString((String)"FILE_ERROR_OPEN") + e1.getMessage());
        }
    }

    protected void doLoad(Element root) throws IOException {
        if (!root.getNodeName().equals(XML_ELEM_ROOT)) {
            throw new IOException(ResMsgCore.msgFormat((String)"FILE_ERROR_OPEN_XML_ROOT", (Object[])new Object[]{"<targets>"}));
        }
        Element outputNode = this.getElement(root, XML_ELEM_OUTPUT);
        if (outputNode != null) {
            String valueType = this.getAttrValue(outputNode, XML_ATTR_TYPE);
            String valueEnum = this.getAttrValue(outputNode, XML_ATTR_ENUM);
            if (valueType != null && valueType.length() > 0 && valueType.equals(XML_ATTR_TYPE_DATABASE)) {
                if (!this._ctrlDatabase.isEnabled()) {
                    throw new IOException(ResViewer.getString("FILE_ERROR_OPEN_XML_OUTPUTTYPE"));
                }
                this._outputType = 1;
                if (valueEnum != null && !valueEnum.isEmpty()) {
                    DbEnum dbEnum = null;
                    try {
                        dbEnum = DbEnum.valueOf(valueEnum.toUpperCase());
                    }
                    catch (IllegalArgumentException e) {
                        throw new IOException("Bad value attribute output@conflictAction: " + valueEnum);
                    }
                    this._ctrlDbOpt.setSelectedItem((Object)dbEnum);
                }
            } else {
                this._outputType = 0;
                if (valueEnum != null && !valueEnum.isEmpty()) {
                    FileEnum fileEnum = null;
                    try {
                        fileEnum = FileEnum.valueOf(valueEnum.toUpperCase());
                    }
                    catch (IllegalArgumentException e) {
                        throw new IOException("Bad value attribute output@conflictAction: " + valueEnum);
                    }
                    this._ctrlFileOpt.setSelectedItem((Object)fileEnum);
                }
            }
        }
        this.refreshOutSelection();
        this._modelTable.load(this.getElement(root, "targets"));
    }

    protected final Element getElement(Element root, String nameNode) throws IOException {
        if (root == null) {
            throw new NullPointerException("getNode() called with a null 'root'");
        }
        NodeList generalNodeList = root.getElementsByTagName(nameNode);
        if (generalNodeList == null) {
            return null;
        }
        if (generalNodeList.getLength() == 0) {
            return null;
        }
        Element result = null;
        for (int i = 0; i < generalNodeList.getLength(); ++i) {
            Node node = generalNodeList.item(i);
            if (!(node instanceof Element)) continue;
            if (result == null) {
                result = (Element)node;
                continue;
            }
            Logger.getLogger(TargetsPanel.class.getPackage().getName()).severe("Plus d'un element '" + nameNode + "' au sein de '" + root.getNodeName() + "' !!");
            return result;
        }
        return result;
    }

    protected final String getAttrValue(Node node, String attrName) throws IOException {
        if (node == null) {
            throw new NullPointerException("getAttrValue() called with a null node");
        }
        Node algoNode = node.getAttributes().getNamedItem(attrName);
        return algoNode == null ? null : algoNode.getFirstChild().getNodeValue();
    }

    private void save() {
        File output = this.displayDlgFile(true);
        if (output == null) {
            return;
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(output));){
            IndentWriter iWriter = new IndentWriter((Writer)writer, "\t");
            iWriter.write("<?xml version=\"1.0\" encoding=\"iso-8859-15\"?>\n");
            iWriter.write("<!-- Pas de DTD par defaut -->\n");
            iWriter.write("<");
            iWriter.write(XML_ELEM_ROOT);
            iWriter.write(" ");
            iWriter.write(XML_ATTR_VERSION);
            iWriter.write("='1'>\n");
            iWriter.addIndent(1);
            this.doSave(iWriter);
            iWriter.addIndent(-1);
            iWriter.write("</");
            iWriter.write(XML_ELEM_ROOT);
            iWriter.write(">");
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)this), ResMsgCore.getString((String)"FILE_ERROR_SAVE") + e1.getMessage());
        }
    }

    protected void doSave(IndentWriter writer) throws IOException {
        writer.write("<");
        writer.write(XML_ELEM_OUTPUT);
        writer.write(" ");
        writer.writeAttrWithValue(XML_ATTR_TYPE, this._outputType == 0 ? XML_ATTR_TYPE_FILE : XML_ATTR_TYPE_DATABASE);
        writer.writeAttrWithValue(XML_ATTR_ENUM, this._outputType == 0 ? ((FileEnum)((Object)this._ctrlFileOpt.getSelectedItem())).name().toLowerCase() : ((DbEnum)((Object)this._ctrlDbOpt.getSelectedItem())).name().toLowerCase());
        writer.write("/>\n");
        this._modelTable.save(writer);
    }

    static enum FileEnum {
        OVERWRITE("DLG_TGT_SEL_FILE1"),
        CONFIRM("DLG_TGT_SEL_FILE2");

        String _key;

        private FileEnum(String key) {
            this._key = key;
        }

        public String toString() {
            return ResViewer.getString(this._key);
        }

        public String getCode() {
            return super.toString();
        }
    }

    public static enum DbEnum {
        OVERWRITE("DLG_TGT_SEL_DB1"),
        DONOTIMPORT("DLG_TGT_SEL_DB2"),
        NEWVERSION("DLG_TGT_SEL_DB3");

        String _key;

        private DbEnum(String key) {
            this._key = key;
        }

        public String toString() {
            return ResViewer.getString(this._key);
        }

        public String getCode() {
            return super.toString();
        }
    }
}

