/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.viewer;

import com.dassault.cecilia.core.swing.table.ArrayTableModel;
import com.dassault.cecilia.core.swing.table.TableModelWithError;
import com.dassault.cecilia.lib.util.io.IndentWriter;
import com.dassault.cecilia.plugin.mbsa.viewer.DefaultFileFilter;
import com.dassault.cecilia.plugin.mbsa.viewer.ResViewer;
import com.dassault.cecilia.plugin.mbsa.viewer.TargetModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TargetsTableModel
extends ArrayTableModel<TargetModel>
implements TableModelWithError {
    protected TargetModel _defTgt;
    protected int _outputType;
    public static final String XML_ELEMENT_TARGETS = "targets";
    public static final String XML_ELEMENT_TARGET = "target";

    public TargetsTableModel(TargetModel defTgt) {
        this._defTgt = defTgt;
    }

    public int getColumnCount() {
        return this._defTgt.getColumnCount();
    }

    public Class<?> getColumnClass(int c) {
        return this._defTgt.getColumnClass(c);
    }

    public String getColumnName(int c) {
        return this._defTgt.getColumnName(c);
    }

    public Object getValueAt(int r, int c) {
        TargetModel tgt = (TargetModel)this.getItemAt(r);
        return tgt.getValueAt(c);
    }

    public void setValueAt(Object item, int r, int c) {
        TargetModel tgt = (TargetModel)this.getItemAt(r);
        if (tgt.setValueAt(item, c)) {
            this.fireTableRowsUpdated(r, r);
        }
    }

    public boolean isCellEditable(int r, int c) {
        if (!this._editable) {
            return false;
        }
        TargetModel tgt = (TargetModel)this.getItemAt(r);
        return tgt.isCellEditable(c);
    }

    public boolean withError() {
        Iterator i = this.getData().iterator();
        while (i.hasNext()) {
            if (!((TargetModel)i.next()).withError()) continue;
            return true;
        }
        return false;
    }

    public boolean withError(int row, int column) {
        TargetModel tgt = (TargetModel)this.getItemAt(row);
        if (column == -1) {
            return tgt.withError();
        }
        return tgt.withError(column);
    }

    protected TargetModel createTarget(TargetModel obj) {
        if (obj != null) {
            return obj;
        }
        return (TargetModel)this._defTgt.clone();
    }

    public void addData(TargetModel obj) {
        obj = this.createTarget(obj);
        super.addData((Object)obj);
    }

    public void insertData(TargetModel obj, int idx) {
        obj = this.createTarget(obj);
        super.insertData((Object)obj, idx);
    }

    public void changeData(TargetModel obj) {
        int idx = this.getData().indexOf(obj);
        if (idx >= 0) {
            this.fireTableRowsUpdated(idx, idx);
        }
    }

    public void save(IndentWriter out) throws IOException {
        out.write("<");
        out.write(XML_ELEMENT_TARGETS);
        out.write(">\n");
        Iterator i = this.getData().iterator();
        out.addIndent(1);
        while (i.hasNext()) {
            ((TargetModel)i.next()).save(out);
        }
        out.addIndent(-1);
        out.write("</");
        out.write(XML_ELEMENT_TARGETS);
        out.write(">\n");
    }

    public void load(Element elemTargets) throws IOException {
        ArrayList<TargetModel> list = new ArrayList<TargetModel>();
        NodeList childs = elemTargets.getElementsByTagName(XML_ELEMENT_TARGET);
        try {
            for (int i = 0; i < childs.getLength(); ++i) {
                Node n = childs.item(i);
                if (!(n instanceof Element)) continue;
                Element xmlTgt = (Element)n;
                TargetModel tgt = (TargetModel)this._defTgt.clone();
                tgt.load(xmlTgt, this._defTgt, this._outputType);
                list.add(tgt);
            }
            this.setData(list);
            this.fireTableDataChanged();
        }
        catch (Exception e) {
            ResViewer.LOG.log(Level.WARNING, "Exception during read file target", e);
            StringBuffer sb = new StringBuffer(32);
            sb.append(e.getClass().getName());
            sb.append(" : ");
            String mess = e.getMessage();
            if (mess == null) {
                sb.append("<null>");
            } else {
                sb.append(mess);
            }
            throw new IOException(sb.toString());
        }
    }

    public void defineDefault(TargetModel target) {
        this._defTgt.copy(target);
    }

    public void refreshFileFilter(DefaultFileFilter newFilter) {
        DefaultFileFilter oldFilter = this._defTgt.getFilter();
        for (int i = 0; i < this.getRowCount(); ++i) {
            TargetModel tgt = (TargetModel)this.getItemAt(i);
            if (!tgt.refreshFileFilter(oldFilter, newFilter)) continue;
            this.fireTableRowsUpdated(i, i);
        }
        this._defTgt.refreshFileFilter(oldFilter, newFilter);
    }

    public void refreshOutputType(int type, boolean clearPath) {
        this._outputType = type;
        for (int i = 0; i < this.getRowCount(); ++i) {
            TargetModel tgt = (TargetModel)this.getItemAt(i);
            tgt.setOutputType(type, clearPath);
            this.fireTableRowsUpdated(i, i);
        }
        this._defTgt.setOutputType(type, clearPath);
    }
}

