/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.viewer;

import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PluginMProcess;
import com.dassault.cecilia.core.plugin.UtilityPluginProcessDefine;
import com.dassault.cecilia.lib.ban.BanEntry;
import com.dassault.cecilia.lib.ban.BanLicenseException;
import com.dassault.cecilia.lib.util.io.XMLWriter;
import com.dassault.cecilia.plugin.mbsa.viewer.TargetModel;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class UtilityPluginTargetsDB
extends UtilityPluginProcessDefine {
    public static final String BAN_ID_PLUGABLE = "plugable";
    protected static final String CALL_POST_PROCESS = "<!-- CALL POST PROCESS -->";
    protected static final String DEFINE_TARGETS = "<!-- DEFINE TARGETS -->";
    protected static final String CALL_DATABASE_IMPORT = "<!-- CALL DATABASE IMPORT -->";
    public static final String PROP_TARGET_DB_WITH_INFO = "cecilia.mbsa.plugin.abc.DBImportWithInfo";
    protected List<TargetModel> _targets;

    protected UtilityPluginTargetsDB(List<TargetModel> tgts) {
        this.addKeyFragment(CALL_POST_PROCESS);
        this.addKeyFragment(DEFINE_TARGETS);
        this.addKeyFragment(CALL_DATABASE_IMPORT);
        this._targets = tgts;
    }

    protected String withDestination() {
        return null;
    }

    protected void writeFragment(Plugable launcher, Writer writer, String keyFragment, File logFile) throws IOException {
        if (CALL_POST_PROCESS.equals(keyFragment)) {
            PluginMProcess process = this.getPostProcess(launcher);
            if (process != null) {
                int nbr = this._targets.size();
                Iterator<TargetModel> i = this._targets.iterator();
                int cpt = 1;
                while (i.hasNext()) {
                    TargetModel tgt = i.next();
                    this.writeTargetFromPostProcess(writer, tgt, launcher, logFile, process, cpt, nbr);
                    ++cpt;
                }
            }
        } else if (DEFINE_TARGETS.equals(keyFragment)) {
            int nbr = this._targets.size();
            Iterator<TargetModel> i = this._targets.iterator();
            int cpt = 1;
            while (i.hasNext()) {
                TargetModel tgt = i.next();
                this.writeTargetToBanScript(launcher, writer, tgt, cpt, nbr);
                ++cpt;
            }
        } else if (CALL_DATABASE_IMPORT.equals(keyFragment)) {
            String dbOption = this.getDBConflictOption();
            if (dbOption != null) {
                writer.write("  <batchtreeimport conflictoption=\"" + dbOption + "\">\n");
                String destination = this.withDestination();
                if (destination != null && !destination.isEmpty()) {
                    writer.write(destination);
                }
                for (TargetModel tgt : this._targets) {
                    writer.write("    <import to=\"");
                    writer.write(XMLWriter.toXML((String)tgt.getPathTreeName()));
                    writer.write("\" srcfile=\"");
                    writer.write(XMLWriter.toXML((String)tgt.getFilePath()));
                    writer.write("\"/>\n");
                }
                writer.write("  </batchtreeimport>\n");
                for (TargetModel tgt : this._targets) {
                    writer.write("  <delete file=\"");
                    writer.write(XMLWriter.toXML((String)tgt.getFilePath()));
                    writer.write("\" deleteonexit=\"true\" failonerror=\"false\"/>\n");
                }
            }
        } else {
            super.writeFragment(launcher, writer, keyFragment, logFile);
        }
    }

    protected abstract String getDBConflictOption();

    protected void writeProgressToBanScript(Writer writer, TargetModel tgt, int cpt, int nbr) throws IOException {
        writer.write("<progress message=\"");
        if (nbr > 1) {
            writer.write(Integer.toString(cpt));
            writer.write(XMLWriter.toXML((String)"/"));
            writer.write(Integer.toString(nbr));
            writer.write(XMLWriter.toXML((String)" : "));
        }
        writer.write(XMLWriter.toXML((String)tgt.getVarTarget()));
        writer.write("=");
        writer.write(XMLWriter.toXML((String)tgt.getValTarget()));
        writer.write("\"/>\n");
    }

    protected abstract void writeTargetToBanScript(Plugable var1, Writer var2, TargetModel var3, int var4, int var5) throws IOException;

    protected void writeTargetFromPostProcess(Writer writer, TargetModel tgt, Plugable launcher, File logFile, PluginMProcess process, int cpt, int nbr) throws IOException {
        String append = process.writeCommand(launcher, tgt.getFilePath(), logFile.getAbsolutePath());
        if (append != null && append.length() > 0) {
            writer.write(append);
        }
    }

    public BanEntry createBanEntry(Plugable launcher, BanEntry previous) {
        BanEntry entry = null;
        try {
            entry = previous != null ? new BanEntry(previous) : new BanEntry();
        }
        catch (BanLicenseException e) {
            Logger.getLogger(UtilityPluginTargetsDB.class.getPackage().getName()).log(Level.WARNING, "No licence ban", e);
            return null;
        }
        entry.setIdObject(BAN_ID_PLUGABLE, (Object)launcher);
        this.defineUserProperties(launcher, entry);
        return entry;
    }

    protected abstract void defineUserProperties(Plugable var1, BanEntry var2);
}

