/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.viewer.ban;

import com.dassault.cecilia.core.cecilia.error.MsgType;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.faulttree.DAGImportChoice;
import com.dassault.cecilia.dbobj.general.conflict.DBConflict;
import com.dassault.cecilia.io.trees.UtilityImportTreeDag;
import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.ban.launcher.LogExecRecord;
import com.dassault.cecilia.lib.ban.unitdefs.DestinationUnit;
import com.dassault.cecilia.lib.ban.util.UtilFileSrc;
import com.dassault.cecilia.plugin.mbsa.viewer.TargetsPanel;
import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class BatchTreeImport
extends DestinationUnit {
    public static String CONFLICT_OPTION_REPLACE = TargetsPanel.DbEnum.OVERWRITE.getCode();
    public static String CONFLICT_OPTION_NOTIMPORT = TargetsPanel.DbEnum.DONOTIMPORT.getCode();
    public static String CONFLICT_OPTION_NEWVERSION = TargetsPanel.DbEnum.NEWVERSION.getCode();
    String _conflictOption = null;
    ArrayList<Import> _imports = new ArrayList();

    public void setConflictoption(String value) {
        this._conflictOption = value;
    }

    public Import createImport() {
        if (this._imports == null) {
            this._imports = new ArrayList();
        }
        Import create = new Import();
        this._imports.add(create);
        return create;
    }

    public void endValid() {
        if (this._imports == null || this._imports.size() == 0) {
            throw new BanProcessException("No element 'import'");
        }
        Object obj = this.getBanEntry().getIdObject("plugable");
        if (obj == null || !(obj instanceof Plugable) || ((Plugable)obj).getAppl() == null) {
            throw new BanProcessException("No conforme Object 'plugable'");
        }
        for (Import ti : this._imports) {
            ti.endValid();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        Plugable plugable = (Plugable)this.getBanEntry().getIdObject("plugable");
        DBConflict dbConflict = DBConflict.NOTIMPORT;
        String conflictOption = this.expanse(this._conflictOption);
        if (conflictOption.equalsIgnoreCase(CONFLICT_OPTION_REPLACE)) {
            dbConflict = DBConflict.UPDATE;
        } else if (conflictOption.equalsIgnoreCase(CONFLICT_OPTION_NOTIMPORT)) {
            dbConflict = DBConflict.NOTIMPORT;
        } else if (conflictOption.equalsIgnoreCase(CONFLICT_OPTION_NEWVERSION)) {
            dbConflict = DBConflict.NEWVERSION;
        }
        DAGImportChoice type = DAGImportChoice.BOOL_FORMULA;
        if (Boolean.getBoolean("cecilia.mbsa.viewer.DBEditorAcceptFaultTree")) {
            type = DAGImportChoice.FT_OR_BF;
        }
        UtilityImportTreeDag utility = new UtilityImportTreeDag(plugable, type){

            protected void addError(File folder, MsgType msgType, String msg) {
                LogExecRecord.LogType logType = LogExecRecord.LogType.ERR;
                switch (msgType) {
                    case FATAL: {
                        logType = LogExecRecord.LogType.EXC;
                        break;
                    }
                    case ERROR: {
                        logType = LogExecRecord.LogType.ERR;
                        break;
                    }
                    case WARNING: {
                        logType = LogExecRecord.LogType.OUT;
                        break;
                    }
                    default: {
                        logType = LogExecRecord.LogType.INFO;
                    }
                }
                StringBuilder sb = new StringBuilder(256).append("  [").append(folder.getName()).append("]: ").append(msg).append("\n");
                BatchTreeImport.this.addRecord(new LogExecRecord(logType, sb.toString()));
            }
        };
        this.openDestination();
        try {
            int nbrTree = 0;
            int nbrError = 0;
            for (Import banImport : this._imports) {
                ++nbrTree;
                String path = banImport.getTo();
                this.addRecord(new LogExecRecord(LogExecRecord.LogType.INFO, new StringBuilder(256).append("Import [").append(banImport.getFile().getAbsolutePath()).append("]\n  to ").append(path).append("\n").toString()));
                int pos = path.lastIndexOf("/");
                if (pos == -1) {
                    ++nbrError;
                    this.addRecord(new LogExecRecord(LogExecRecord.LogType.ERR, new StringBuilder(256).append("Path not conforme ").append(path).append("\n").toString()));
                    continue;
                }
                DBFolder result = utility.doImportFile(banImport.getFile(), path.substring(0, pos), path.substring(pos + 1), dbConflict);
                if (result != null) continue;
                ++nbrError;
            }
            this.addRecord(new LogExecRecord(LogExecRecord.LogType.OUT, new StringBuilder(256).append("NbrError = ").append(nbrError).append(" / NbrImport = ").append(nbrTree).append("\n").toString()));
        }
        finally {
            this.closeDestination();
        }
    }

    public class Import
    extends UtilFileSrc {
        String _to;

        public void setTo(String value) {
            this._to = value;
        }

        public void setSrcfile(String value) {
            this.setFile("srcfile", value);
        }

        public void setSrcref(String value) {
            this.setRef("srcref", value);
        }

        public void endValid() {
            super.endValid();
            if (this._to == null || this._to.length() == 0) {
                throw new BanProcessException("No attribute 'to' for 'import' element");
            }
        }

        String getTo() {
            String result = this.expanse(this._to);
            StringTokenizer st = new StringTokenizer(result, "/");
            if (st.hasMoreTokens()) {
                st.nextToken();
                if (st.hasMoreTokens()) {
                    st.nextToken();
                    if (st.hasMoreTokens()) {
                        st.nextToken();
                        if (!st.hasMoreTokens()) {
                            return result;
                        }
                    }
                }
            }
            throw new BanProcessException("Bad format [ " + result + " ] for attribute 'to'");
        }
    }
}

