/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.aralia;

import com.dassault.cecilia.core.plugin.IOParameters;
import com.dassault.cecilia.core.plugin.PluginManager;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.other.JCRLabel;
import com.dassault.cecilia.plugin.mbsa.aralia.AraliaOptions;
import com.dassault.cecilia.plugin.mbsa.aralia.AraliaParametersIO;
import com.dassault.cecilia.plugin.mbsa.aralia.EnumFormat;
import com.dassault.cecilia.plugin.mbsa.aralia.PanelAraliaOptions;
import com.dassault.cecilia.plugin.mbsa.aralia.ResAralia;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class AraliaParameters {
    String _inputKey;
    String _outputKey;
    AraliaOptions _araliaOptions;
    protected static IOParameters _instance = new AraliaParametersIO();

    public String getInput() {
        return this._inputKey;
    }

    public String getOutput() {
        return this._outputKey;
    }

    public AraliaOptions getAraliaOptions() {
        return this._araliaOptions;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        sb.append(ResAralia.getString("XSLT_INPUT"));
        sb.append(" : ").append(this._inputKey).append("\n");
        sb.append(ResAralia.getString("XSLT_OUTPUT"));
        sb.append(" : ").append(this._outputKey).append("\n");
        sb.append(this._araliaOptions.toString());
        return sb.toString();
    }

    public AraliaParameters() {
        this._inputKey = "%{file}";
        this._outputKey = "%{path}/%{name}.xml";
        this._araliaOptions = new AraliaOptions();
    }

    public AraliaParameters(AraliaParameters src) {
        this._inputKey = src._inputKey;
        this._outputKey = src._outputKey;
        this._araliaOptions = new AraliaOptions(src._araliaOptions);
    }

    public boolean change(PluginManager launcher) {
        Window win = SwingUtilities.getWindowAncestor(launcher.getWindow());
        if (win == null) {
            win = launcher.getWindow();
        }
        DlgChangeAraliaParameters dlg = new DlgChangeAraliaParameters(win);
        dlg._ctrlInput.setText(this._inputKey);
        dlg._ctrlOutput.setText(this._outputKey);
        dlg._ctrlOptions.copyToCtrl(this._araliaOptions);
        dlg.setVisible(true);
        if (dlg.getResult()) {
            this._inputKey = dlg._ctrlInput.getText().trim();
            this._outputKey = dlg._ctrlOutput.getText().trim();
            dlg._ctrlOptions.copyFromCtrl(this._araliaOptions);
            return true;
        }
        return false;
    }

    public static IOParameters getIOParameters() {
        return _instance;
    }

    class DlgChangeAraliaParameters
    extends JDialogCecilia {
        JTextField _ctrlInput;
        JTextField _ctrlOutput;
        PanelAraliaOptions _ctrlOptions;

        public DlgChangeAraliaParameters(Window win) {
            super(win, true);
            this.init();
        }

        protected JComponent createInOutPanel() {
            JPanel root = new JPanel(new GridBagLayout());
            int line = 0;
            root.add((Component)new JCRLabel(ResAralia.getString("XSLT_INPUT")), new GridBagConstraints(0, line, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this._ctrlInput = new JTextField(20);
            root.add((Component)this._ctrlInput, new GridBagConstraints(1, line++, 1, 1, 10.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
            root.add((Component)new JCRLabel(ResAralia.getString("XSLT_OUTPUT")), new GridBagConstraints(0, line, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this._ctrlOutput = new JTextField(20);
            root.add((Component)this._ctrlOutput, new GridBagConstraints(1, line++, 1, 1, 10.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
            return root;
        }

        protected JPanel createOptionsPanel() {
            this._ctrlOptions = new PanelAraliaOptions(){

                @Override
                protected void changeFormat(EnumFormat frm) {
                }
            };
            this._ctrlOptions.setBorder(BorderFactory.createTitledBorder(ResAralia.getString("DLG_ARALIA_OPTIONS")));
            return this._ctrlOptions;
        }

        protected void init() {
            super.init();
            JPanel rPanel = new JPanel(new GridBagLayout());
            rPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            rPanel.add((Component)this.createInOutPanel(), new GridBagConstraints(0, 0, 1, 1, 10.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            rPanel.add((Component)this.createOptionsPanel(), new GridBagConstraints(0, 1, 1, 1, 10.0, 10.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            rPanel.add((Component)this.createButPanel(), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)rPanel, "Center");
            this.pack();
            Dimension tSize = this.getSize();
            Dimension pSize = this.getOwner().getSize();
            Point pLoc = this.getOwner().getLocation();
            this.setLocation(pLoc.x + pSize.width / 2 - tSize.width / 2, pLoc.y + pSize.height / 2 - tSize.height / 2);
            this.setTitle(ResAralia.getString("XSLT_PARAMETERS_TITLE"));
        }

        protected boolean verifyParameters() {
            return this._ctrlOptions.verifyData();
        }
    }
}

