/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.aralia;

import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.other.ToggleBorderLayout;
import com.dassault.cecilia.plugin.mbsa.aralia.AraliaOptions;
import com.dassault.cecilia.plugin.mbsa.aralia.DialogException;
import com.dassault.cecilia.plugin.mbsa.aralia.EnumFormat;
import com.dassault.cecilia.plugin.mbsa.aralia.MCSAlgo;
import com.dassault.cecilia.plugin.mbsa.aralia.PanelTimeSelection;
import com.dassault.cecilia.plugin.mbsa.aralia.ResAralia;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PanelAraliaOptions
extends JPanel {
    JCheckBox _ctrlProba;
    JCheckBox _ctrlProbaLeaves;
    PanelTimeSelection _ctrlProbaTimes;
    JCheckBox _ctrlCuts = new JCheckBox(ResAralia.getString("DLG_CUTS"));
    JLabel _lblCutsAlgo;
    JComboBox _ctrlCutsAlgo;
    JCheckBox _ctrlCutsTrunc;
    JComboBox _ctrlCutsTruncOrders;
    JCheckBox _ctrlCutsOrders;
    JCheckBox _ctrlCutsProducts;
    JCheckBox _ctrlCutsProductsOrder;
    JCheckBox _ctrlCutsProductsProba;
    JLabel _lblCutsProductsTime;
    JTextField _ctrlCutsProductsTime;
    JLabel _lblFormat;
    JComboBox _ctrlFormat;

    public PanelAraliaOptions() throws HeadlessException {
        super(new GridBagLayout());
        JPanel cutsPanel = new JPanel(new GridBagLayout());
        this._lblCutsAlgo = new JLabel(ResAralia.getString("DLG_CUTS_ALGO"));
        this._ctrlCutsAlgo = new JComboBox();
        this._ctrlCutsAlgo.addItem(MCSAlgo.ZQC);
        this._ctrlCutsAlgo.addItem(MCSAlgo.ZPI);
        this._ctrlCutsAlgo.addItem(MCSAlgo.pBDD);
        this._ctrlCutsAlgo.setEditable(false);
        this._ctrlCutsAlgo.setSelectedIndex(0);
        this._ctrlCutsAlgo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelAraliaOptions.this.changeCutsOptions();
            }
        });
        cutsPanel.add((Component)this._lblCutsAlgo, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 5, 5), 0, 0));
        cutsPanel.add((Component)this._ctrlCutsAlgo, new GridBagConstraints(1, 0, 1, 1, 100.0, 0.0, 17, 2, new Insets(10, 5, 5, 5), 0, 0));
        this._ctrlCutsTrunc = new JCheckBox(ResAralia.getString("DLG_CUTS_TRUNCATED"));
        this._ctrlCutsTruncOrders = new JComboBox();
        for (int i = 1; i < 13; ++i) {
            this._ctrlCutsTruncOrders.addItem(i);
        }
        this._ctrlCutsTruncOrders.setEditable(true);
        this._ctrlCutsTrunc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelAraliaOptions.this.changeCutsOptions();
            }
        });
        cutsPanel.add((Component)this._ctrlCutsTrunc, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        cutsPanel.add((Component)this._ctrlCutsTruncOrders, new GridBagConstraints(1, 1, 1, 1, 100.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this._ctrlCutsOrders = new JCheckBox(ResAralia.getString("DLG_CUTS_ORDERS"));
        cutsPanel.add((Component)this._ctrlCutsOrders, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this._ctrlCutsProducts = new JCheckBox(ResAralia.getString("DLG_CUTS_PRODUCTS"));
        JPanel productsPanel = new JPanel(new GridBagLayout());
        this._ctrlCutsProductsOrder = new JCheckBox(ResAralia.getString("DLG_CUTS_PRODUCTS_ORDER"));
        productsPanel.add((Component)this._ctrlCutsProductsOrder, new GridBagConstraints(0, 0, 2, 1, 100.0, 100.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this._ctrlCutsProductsProba = new JCheckBox(ResAralia.getString("DLG_CUTS_PRODUCTS_PROBA"));
        productsPanel.add((Component)this._ctrlCutsProductsProba, new GridBagConstraints(0, 1, 2, 1, 100.0, 100.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this._lblCutsProductsTime = new JLabel(ResAralia.getString("DLG_CUTS_PRODUCTS_TIME"));
        productsPanel.add((Component)this._lblCutsProductsTime, new GridBagConstraints(0, 2, 1, 1, 100.0, 100.0, 17, 0, new Insets(0, 10, 0, 5), 0, 0));
        this._ctrlCutsProductsTime = new JTextField(5);
        productsPanel.add((Component)this._ctrlCutsProductsTime, new GridBagConstraints(1, 2, 2, 1, 100.0, 100.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this._ctrlCutsProductsProba.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PanelAraliaOptions.this.changeCutsProductsOptions();
            }
        });
        this._ctrlCutsProducts.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PanelAraliaOptions.this.changeCutsProductsOptions();
            }
        });
        JPanel panel = new JPanel((LayoutManager)new ToggleBorderLayout());
        ToggleBorderLayout.configure((Container)panel, (JToggleButton)this._ctrlCutsProducts, (JComponent)productsPanel);
        cutsPanel.add((Component)panel, new GridBagConstraints(2, 0, 1, 3, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this._ctrlCuts.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PanelAraliaOptions.this.changeCutsOptions();
            }
        });
        JPanel panel2 = new JPanel((LayoutManager)new ToggleBorderLayout());
        ToggleBorderLayout.configure((Container)panel2, (JToggleButton)this._ctrlCuts, (JComponent)cutsPanel);
        this.add((Component)panel2, new GridBagConstraints(0, 0, 2, 1, 100.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this._ctrlProba = new JCheckBox(ResAralia.getString("DLG_PROBABILITY"));
        JPanel probaPanel = new JPanel(new BorderLayout());
        this._ctrlProbaTimes = new PanelTimeSelection();
        this._ctrlProbaTimes.create(false);
        this._ctrlProbaTimes.setBorder(BorderFactory.createTitledBorder(ResAralia.getString("DLG_PROBABILITY_TIME")));
        probaPanel.add((Component)this._ctrlProbaTimes, "Center");
        this._ctrlProbaLeaves = new JCheckBox(ResAralia.getString("DLG_PROBABILITY_LEAVES"));
        probaPanel.add((Component)this._ctrlProbaLeaves, "South");
        this._ctrlProba.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PanelAraliaOptions.this.changeProbaOptions();
            }
        });
        panel2 = new JPanel((LayoutManager)new ToggleBorderLayout());
        ToggleBorderLayout.configure((Container)panel2, (JToggleButton)this._ctrlProba, (JComponent)probaPanel);
        this.add((Component)panel2, new GridBagConstraints(0, 1, 2, 1, 100.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this._lblFormat = new JLabel(ResAralia.getString("DLG_FORMAT_LBL"));
        this.add((Component)this._lblFormat, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._ctrlFormat = new JComboBox();
        this._ctrlFormat.addItem(EnumFormat.Aralia);
        this._ctrlFormat.addItem(EnumFormat.XML);
        this.add((Component)this._ctrlFormat, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._ctrlFormat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EnumFormat frm = (EnumFormat)((Object)PanelAraliaOptions.this._ctrlFormat.getSelectedItem());
                PanelAraliaOptions.this.changeFormat(frm);
            }
        });
    }

    protected void changeFormat(EnumFormat frm) {
    }

    protected void changeProbaOptions() {
        boolean selected = this._ctrlProba.isSelected();
        this._ctrlProbaTimes.setEnabled(selected);
        this._ctrlProbaTimes.setEnabled(selected);
        this._ctrlProbaLeaves.setEnabled(selected);
    }

    protected void changeCutsOptions() {
        MCSAlgo algo;
        boolean selected = this._ctrlCuts.isSelected();
        this._lblCutsAlgo.setEnabled(selected);
        this._ctrlCutsAlgo.setEnabled(selected);
        this._ctrlCutsTrunc.setEnabled(selected);
        if (selected && (algo = (MCSAlgo)((Object)this._ctrlCutsAlgo.getSelectedItem())) == MCSAlgo.pBDD) {
            this._ctrlCutsTrunc.setSelected(true);
            this._ctrlCutsTrunc.setEnabled(false);
        }
        boolean trunc = this._ctrlCutsTrunc.isSelected();
        this._ctrlCutsTruncOrders.setEnabled(selected && trunc);
        this._ctrlCutsOrders.setEnabled(selected);
        this._ctrlCutsProducts.setEnabled(selected);
        this.changeCutsProductsOptions();
    }

    protected void changeCutsProductsOptions() {
        boolean cuts = this._ctrlCuts.isSelected();
        boolean products = this._ctrlCutsProducts.isSelected();
        boolean proba = this._ctrlCutsProductsProba.isSelected();
        this._ctrlCutsProductsOrder.setEnabled(cuts && products);
        this._ctrlCutsProductsProba.setEnabled(cuts && products);
        this._lblCutsProductsTime.setEnabled(cuts && products && proba);
        this._ctrlCutsProductsTime.setEnabled(cuts && products && proba);
    }

    protected boolean verifyData() {
        if (!this._ctrlProba.isSelected() && !this._ctrlCuts.isSelected()) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)this), ResAralia.getString("DLG_ERR"));
            this._ctrlProba.requestFocus();
            return false;
        }
        if (this._ctrlProba.isSelected()) {
            try {
                this._ctrlProbaTimes.copyFromCtrl();
            }
            catch (DialogException e) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)this), e.getMessage());
                e._src.requestFocus();
                return false;
            }
        }
        if (this._ctrlCuts.isSelected()) {
            if (!this._ctrlCutsOrders.isSelected() && !this._ctrlCutsProducts.isSelected()) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)this), ResAralia.getString("DLG_CUTS_ERR"));
                this._ctrlCutsOrders.requestFocus();
                return false;
            }
            if (this._ctrlCutsTrunc.isSelected()) {
                try {
                    int order = Integer.parseInt(this._ctrlCutsTruncOrders.getSelectedItem().toString());
                    if (order <= 0) {
                        throw new NumberFormatException();
                    }
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)this), ResAralia.getString("DLG_CUTS_ERR_TRUNC"));
                    this._ctrlCutsTruncOrders.requestFocus();
                    return false;
                }
            }
            if (this._ctrlCutsProducts.isSelected() && this._ctrlCutsProductsProba.isSelected()) {
                try {
                    double time = Double.parseDouble(this._ctrlCutsProductsTime.getText().trim());
                    if (time < 0.0) {
                        throw new NumberFormatException();
                    }
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)this), ResAralia.getString("DLG_CUTS_ERR_TIME"));
                    this._ctrlCutsProductsTime.requestFocus();
                    return false;
                }
            }
        }
        return true;
    }

    public void copyToCtrl(AraliaOptions params) {
        this._ctrlProba.setSelected(params._proba);
        this._ctrlProbaTimes.setComputeTimeSt(params._probaTimes);
        this._ctrlProbaLeaves.setSelected(params._probaLeaves);
        this._ctrlCuts.setSelected(params._cuts);
        this._ctrlCutsTrunc.setSelected(params._cutsTrunc);
        this._ctrlCutsTruncOrders.setSelectedItem(params._cutsTruncOrder);
        this._ctrlCutsAlgo.setSelectedIndex(0);
        for (int i = this._ctrlCutsAlgo.getItemCount() - 1; i >= 0; --i) {
            if ((MCSAlgo)((Object)this._ctrlCutsAlgo.getItemAt(i)) != params._cutsAlgo) continue;
            this._ctrlCutsAlgo.setSelectedIndex(i);
            break;
        }
        this._ctrlCutsOrders.setSelected(params._cutsOrders);
        this._ctrlCutsProducts.setSelected(params._cutsProducts);
        this._ctrlCutsProductsOrder.setSelected(params._cutsProductsOrder);
        this._ctrlCutsProductsProba.setSelected(params._cutsProductsProba);
        this._ctrlCutsProductsTime.setText(Double.toString(params._cutsProductsTime));
        int idxSelect = 0;
        for (int i = this._ctrlFormat.getItemCount() - 1; i >= 0; --i) {
            if (params._format != (EnumFormat)((Object)this._ctrlFormat.getItemAt(i))) continue;
            idxSelect = i;
            break;
        }
        this._ctrlFormat.setSelectedIndex(idxSelect);
        this._ctrlProbaTimes.copyToCtrl();
        this.changeProbaOptions();
        this.changeCutsOptions();
    }

    public void copyFromCtrl(AraliaOptions params) {
        block7: {
            block6: {
                params._proba = this._ctrlProba.isSelected();
                params._probaTimes = this._ctrlProbaTimes.getComputeTimeSt();
                params._probaLeaves = this._ctrlProbaLeaves.isSelected();
                params._cuts = this._ctrlCuts.isSelected();
                params._cutsAlgo = (MCSAlgo)((Object)this._ctrlCutsAlgo.getSelectedItem());
                params._cutsTrunc = this._ctrlCutsTrunc.isSelected();
                try {
                    int order = Integer.parseInt(this._ctrlCutsTruncOrders.getSelectedItem().toString());
                    if (order <= 0) {
                        throw new NumberFormatException();
                    }
                    params._cutsTruncOrder = order;
                }
                catch (NumberFormatException e) {
                    if (!params._cuts || !params._cutsTrunc) break block6;
                    e.printStackTrace();
                }
            }
            params._cutsOrders = this._ctrlCutsOrders.isSelected();
            params._cutsProducts = this._ctrlCutsProducts.isSelected();
            params._cutsProductsOrder = this._ctrlCutsProductsOrder.isSelected();
            params._cutsProductsProba = this._ctrlCutsProductsProba.isSelected();
            try {
                double time = Double.parseDouble(this._ctrlCutsProductsTime.getText().trim());
                if (time < 0.0) {
                    throw new NumberFormatException();
                }
                params._cutsProductsTime = time;
            }
            catch (NumberFormatException e) {
                if (!params._cuts || !params._cutsProducts || !params._cutsProductsProba) break block7;
                e.printStackTrace();
            }
        }
        params._format = (EnumFormat)((Object)this._ctrlFormat.getSelectedItem());
    }
}

