/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.aralia;

import com.dassault.cecilia.plugin.mbsa.aralia.DialogException;
import com.dassault.cecilia.plugin.mbsa.aralia.ResAralia;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.StringTokenizer;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class PanelTimeSelection
extends JPanel {
    protected JRadioButton _iterationRB;
    JLabel _fromLbl;
    JLabel _toLbl;
    JLabel _stepLbl;
    protected JTextField _step;
    protected JTextField _from;
    protected JTextField _to;
    protected JRadioButton _listRB;
    protected JTextField _at;
    private String _computeTimeSt;
    private String _keyAtName = "GLOBAL_TIME_LIST";
    private boolean _atOnly;
    private boolean _startWith0 = false;

    public PanelTimeSelection() {
        super(new GridBagLayout());
    }

    public void setAtKeyName(String keyName) {
        this._keyAtName = keyName;
    }

    public void create(boolean atOnly) {
        this._atOnly = atOnly;
        ButtonGroup groupe = new ButtonGroup();
        this._iterationRB = new JRadioButton(ResAralia.getString("GLOBAL_ITERATION"));
        groupe.add(this._iterationRB);
        this._iterationRB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    PanelTimeSelection.this.selectFromToStep();
                } else {
                    PanelTimeSelection.this.selectAt();
                }
            }
        });
        this._fromLbl = new JLabel(ResAralia.getString("GLOBAL_FROM"), 0);
        this._fromLbl.setAlignmentX(0.5f);
        this._from = new JTextField(this._startWith0 ? 2 : 8);
        this._toLbl = new JLabel(ResAralia.getString("GLOBAL_TO"), 0);
        this._toLbl.setAlignmentX(0.5f);
        this._to = new JTextField(8);
        this._stepLbl = new JLabel(ResAralia.getString("GLOBAL_STEP"), 0);
        this._step = new JTextField(6);
        this._listRB = new JRadioButton(ResAralia.getString(this._keyAtName));
        this._listRB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    PanelTimeSelection.this.selectAt();
                } else {
                    PanelTimeSelection.this.selectFromToStep();
                }
            }
        });
        this._at = new JTextField(15);
        groupe.add(this._listRB);
        int y = 0;
        if (!atOnly) {
            this.add((Component)this._iterationRB, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this._fromLbl, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this._from, new GridBagConstraints(2, y, 1, 1, 100.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this._toLbl, new GridBagConstraints(3, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this._to, new GridBagConstraints(4, y, 1, 1, 100.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this._stepLbl, new GridBagConstraints(5, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this._step, new GridBagConstraints(6, y++, 1, 1, 100.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        }
        this.add((Component)this._listRB, new GridBagConstraints(0, y, 1, 1, 100.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this._at, new GridBagConstraints(2, y, 5, 0, 100.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        if (atOnly) {
            this.selectAt();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this._listRB.setEnabled(enabled);
        this._iterationRB.setEnabled(enabled);
        if (enabled) {
            if (this._listRB.isSelected()) {
                this.selectAt();
            } else {
                this.selectFromToStep();
            }
        } else {
            this._at.setEnabled(false);
            this._from.setEnabled(false);
            this._to.setEnabled(false);
            this._step.setEnabled(false);
            this._fromLbl.setEnabled(false);
            this._toLbl.setEnabled(false);
            this._stepLbl.setEnabled(false);
        }
    }

    private void selectAt() {
        this._listRB.setSelected(true);
        this._at.setEnabled(true);
        this._from.setEnabled(false);
        this._to.setEnabled(false);
        this._step.setEnabled(false);
        this._fromLbl.setEnabled(false);
        this._toLbl.setEnabled(false);
        this._stepLbl.setEnabled(false);
    }

    private void selectFromToStep() {
        this._iterationRB.setSelected(true);
        this._at.setEnabled(false);
        this._from.setEnabled(!this._startWith0);
        if (this._startWith0) {
            this._from.setText("0");
        }
        this._to.setEnabled(true);
        this._step.setEnabled(true);
        this._fromLbl.setEnabled(true);
        this._toLbl.setEnabled(true);
        this._stepLbl.setEnabled(true);
    }

    public void copyFromCtrl() throws DialogException {
        if (this._iterationRB.isSelected()) {
            double d;
            try {
                d = Double.parseDouble(this._from.getText());
                if (d < 0.0) {
                    throw new DialogException(ResAralia.getString("DLG_PROBABILITY_TIME_ERROR"), this._from);
                }
            }
            catch (Exception e) {
                throw new DialogException(ResAralia.getString("DLG_PROBABILITY_TIME_ERROR"), this._from);
            }
            try {
                d = Double.parseDouble(this._to.getText());
                if (d < 0.0) {
                    throw new DialogException(ResAralia.getString("DLG_PROBABILITY_TIME_ERROR"), this._to);
                }
            }
            catch (Exception e) {
                throw new DialogException(ResAralia.getString("DLG_PROBABILITY_TIME_ERROR"), this._to);
            }
            try {
                d = Double.parseDouble(this._step.getText());
                if (d <= 0.0) {
                    throw new DialogException(ResAralia.getString("DLG_PROBABILITY_TIME_ERROR"), this._step);
                }
            }
            catch (Exception e) {
                throw new DialogException(ResAralia.getString("DLG_PROBABILITY_TIME_ERROR"), this._step);
            }
            StringBuffer sbTime = new StringBuffer();
            sbTime.append("from ");
            sbTime.append(this._from.getText());
            sbTime.append(" to ");
            sbTime.append(this._to.getText());
            sbTime.append(" step ");
            sbTime.append(this._step.getText());
            this._computeTimeSt = sbTime.toString();
        } else if (this._listRB.isSelected()) {
            String at = this._at.getText().trim();
            if (at.length() == 0 || at.endsWith(",")) {
                throw new DialogException(ResAralia.getString("DLG_PROBABILITY_TIME_ERROR"), this._at);
            }
            StringTokenizer st = new StringTokenizer(at, " \t\n;:");
            while (st.hasMoreTokens()) {
                String timex = st.nextToken();
                try {
                    Double.parseDouble(timex.trim());
                    if (!(Double.parseDouble(timex.trim()) < 0.0)) continue;
                    throw new DialogException(ResAralia.getString("DLG_PROBABILITY_TIME_ERROR"), this._step);
                }
                catch (Exception e) {
                    throw new DialogException(ResAralia.getString("DLG_PROBABILITY_TIME_ERROR"), this._at);
                }
            }
            String times = this._at.getText();
            StringBuffer sb = new StringBuffer();
            sb.append("at ");
            if (this._startWith0 && !times.startsWith("0")) {
                sb.append("0,");
            }
            sb.append(times);
            this._computeTimeSt = sb.toString();
        }
    }

    public void copyToCtrl() {
        block7: {
            if (this._computeTimeSt != null && !this._computeTimeSt.equals("")) {
                try {
                    if (this._computeTimeSt.contains("at")) {
                        this.selectAt();
                        this._at.setText(this._computeTimeSt.replace("at", "").trim());
                        break block7;
                    }
                    this.selectFromToStep();
                    int iTo = this._computeTimeSt.indexOf("to");
                    this._from.setText(this._startWith0 ? "0" : this._computeTimeSt.substring(5, iTo).trim());
                    int iStep = this._computeTimeSt.indexOf("step");
                    this._to.setText(this._computeTimeSt.substring(iTo + 2, iStep).trim());
                    this._step.setText(this._computeTimeSt.substring(iStep + 5).trim());
                }
                catch (Exception e) {
                    this.selectAt();
                }
            } else if (this._atOnly) {
                this.selectAt();
            } else {
                this.selectFromToStep();
            }
        }
    }

    public String getComputeTimeSt() {
        return this._computeTimeSt;
    }

    public void setComputeTimeSt(String computeTimeSt) {
        this._computeTimeSt = computeTimeSt;
    }

    public void setStartWith0(boolean b) {
        this._startWith0 = b;
    }
}

