/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.crc.common.diag;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.sftp.RemoteResourceInfo;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;

public class CRCDiag {
    private static final Logger _LOG = Logger.getLogger(CRCDiag.class.getName());
    private static final String SFTP_HOST = "sftp.host";
    private static final String SFTP_PORT = "sftp.port";
    private static final String SFTP_USER = "sftp.user";
    private static final String SFTP_IDENTITY = "sftp.identity";
    private static final String SFTP_PASSWD = "sftp.passwd";

    public static void main(String[] args) {
        String host = System.getProperty(SFTP_HOST);
        if (host == null) {
            _LOG.severe("l'adresse du serveur sftp n'a pas ete precise (-Dsftp.host=...)");
            System.exit(1);
        }
        int port = Integer.getInteger(SFTP_PORT, 22);
        String user = System.getProperty(SFTP_USER, System.getProperty("user.name"));
        String passwd = System.getProperty(SFTP_PASSWD);
        String identity = System.getProperty(SFTP_IDENTITY, System.getProperty("user.dir") + "/id_rsa");
        File identityFile = new File(identity);
        SSHClient sshClient = null;
        if (passwd == null || passwd.trim().isEmpty()) {
            if (!identityFile.exists()) {
                _LOG.severe("Le fichier de cle prive n'existe pas : " + identity);
                System.exit(2);
            }
            _LOG.info("Connecting sftp with host=" + host + " port=" + port + " user=" + user + "\n    identityFile=" + identityFile.getAbsolutePath());
            _LOG.fine("Create SSHClient");
            sshClient = CRCDiag.setupSshj(host, port, user, identityFile);
            if (sshClient == null) {
                System.exit(3);
            }
        } else {
            _LOG.info("Connecting sftp with host=" + host + " port=" + port + " user=" + user + " passwd=" + passwd);
            sshClient = CRCDiag.setupSshj(host, port, user, passwd);
            if (sshClient == null) {
                System.exit(3);
            }
        }
        _LOG.fine("Create SFTPClient");
        SFTPClient sftpClient = null;
        try {
            sftpClient = sshClient.newSFTPClient();
        }
        catch (Exception e) {
            _LOG.log(Level.SEVERE, "Exception durant la creation du client sftp", e);
            System.exit(4);
        }
        try {
            List items = sftpClient.ls(".");
            System.out.println("Repertoire racine sftp:");
            for (RemoteResourceInfo item : items) {
                System.out.println((item.isDirectory() ? "\\" : "") + item.getName());
            }
        }
        catch (IOException e) {
            _LOG.log(Level.SEVERE, "Impossible de lire le repertoire sftp courant", e);
            System.exit(4);
        }
        try {
            _LOG.fine("close sftp client");
            sftpClient.close();
        }
        catch (IOException e) {
            _LOG.log(Level.SEVERE, "Can't close sftp connexion", e);
        }
        try {
            _LOG.fine("Disconnect ssh client");
            sshClient.disconnect();
        }
        catch (IOException e) {
            _LOG.log(Level.SEVERE, "During disconnect ssh client", e);
        }
        System.exit(0);
    }

    private static synchronized SSHClient setupSshj(String host, int port, String user, File identityFile) {
        SSHClient client = null;
        try {
            client = new SSHClient();
            client.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
            client.connect(host, port);
            KeyProvider privateKey = client.loadKeys(identityFile.getPath());
            client.authPublickey(user, new KeyProvider[]{privateKey});
        }
        catch (IOException e) {
            _LOG.log(Level.SEVERE, "Exception durant la creation du client SSH", e);
            client = null;
        }
        return client;
    }

    private static synchronized SSHClient setupSshj(String host, int port, String user, String passwd) {
        SSHClient client = null;
        try {
            client = new SSHClient();
            client.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
            client.connect(host, port);
            client.authPassword(user, passwd);
        }
        catch (IOException e) {
            _LOG.log(Level.SEVERE, "Exception durant la creation du client SSH", e);
            client = null;
        }
        return client;
    }
}

