/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.crc.common.diag;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.ConfigRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.OpenSSHConfig;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;

public class CRCDiagWithJsch {
    private static final java.util.logging.Logger _LOG = java.util.logging.Logger.getLogger(CRCDiagWithJsch.class.getName());
    private static final String SFTP_HOST = "sftp.host";
    private static final String SFTP_PORT = "sftp.port";
    private static final String SFTP_USER = "sftp.user";
    private static final String SFTP_IDENTITY = "sftp.identity";
    private static final String SFTP_PASSWD = "sftp.passwd";

    public static void main(String[] args) {
        String host = System.getProperty(SFTP_HOST);
        if (host == null) {
            _LOG.severe("l'adresse du serveur sftp n'a pas ete precise (-Dsftp.host=...)");
            System.exit(1);
        }
        int port = Integer.getInteger(SFTP_PORT, 22);
        String user = System.getProperty(SFTP_USER, System.getProperty("user.name"));
        String passwd = System.getProperty(SFTP_PASSWD);
        String identity = System.getProperty(SFTP_IDENTITY, System.getProperty("user.dir") + "/id_rsa");
        File identityFile = new File(identity);
        JSch.setLogger((Logger)new JSCHLogger());
        JSch jsch = new JSch();
        Session session = null;
        if (passwd == null || passwd.trim().isEmpty()) {
            if (!identityFile.exists()) {
                _LOG.severe("Le fichier de cle prive n'existe pas : " + identity);
                System.exit(2);
            }
            _LOG.info("Connecting sftp with host=" + host + " port=" + port + " user=" + user + "\n    identityFile=" + identityFile.getAbsolutePath());
            try {
                String config = "Port " + port + "\n\nHost cecilia\n  User " + user + "\n  Hostname " + host + "\nHost *\n  ConnectTime 3000\n  PreferredAuthentications publickey\n  #ForwardAgent yes\n  #StrictHostKeyChecking no\n  IdentityFile " + identityFile.getAbsolutePath().replaceAll("\\\\", "/") + "\n  #UserKnownHostsFile ~/.ssh/known_hosts";
                System.out.println("Generated configuration:");
                System.out.println(config);
                OpenSSHConfig configRepository = OpenSSHConfig.parse((String)config);
                jsch.setConfigRepository((ConfigRepository)configRepository);
                session = jsch.getSession("cecilia");
                session = jsch.getSession(user, host, port);
                session.setUserInfo((UserInfo)new CeciliaSSHUserInfo());
                session.connect();
            }
            catch (Exception e) {
                _LOG.log(Level.SEVERE, "Exception durant la creation de la session ssh", e);
                session = null;
            }
        } else {
            _LOG.info("Connecting sftp with host=" + host + " port=" + port + " user=" + user + " passwd=" + passwd);
            try {
                session = jsch.getSession(user, host, port);
                session.setPassword(passwd);
                session.setUserInfo((UserInfo)new CeciliaSSHUserInfo());
                session.connect();
            }
            catch (Exception e) {
                _LOG.log(Level.SEVERE, "Exception durant la creation de la session ssh", e);
                session = null;
            }
        }
        if (session == null) {
            System.exit(4);
        }
        _LOG.fine("Create SFTPChannel");
        ChannelSftp channelSftp = null;
        try {
            Channel channel = session.openChannel("sftp");
            channel.connect();
            channelSftp = (ChannelSftp)channel;
        }
        catch (Exception e) {
            _LOG.log(Level.SEVERE, "Exception durant la creation du channel sftp", e);
        }
        if (channelSftp == null) {
            System.exit(5);
        }
        try {
            Vector vv = channelSftp.ls(".");
            if (vv != null) {
                for (int ii = 0; ii < vv.size(); ++ii) {
                    Object obj = vv.elementAt(ii);
                    if (!(obj instanceof ChannelSftp.LsEntry)) continue;
                    System.out.println(((ChannelSftp.LsEntry)obj).getLongname());
                }
            }
        }
        catch (SftpException e) {
            _LOG.log(Level.SEVERE, "Impossible de lire le repertoire sftp courant", e);
        }
        try {
            _LOG.fine("close sftp channel");
            channelSftp.exit();
        }
        catch (Exception e) {
            _LOG.log(Level.SEVERE, "Can't close sftp channel", e);
        }
        try {
            _LOG.fine("Disconnect ssh session");
            session.disconnect();
        }
        catch (Exception e) {
            _LOG.log(Level.SEVERE, "During disconnect ssh session", e);
        }
        System.exit(0);
    }

    static class JSCHLogger
    implements Logger {
        private Map<Integer, Level> levels = new HashMap<Integer, Level>();
        private final java.util.logging.Logger LOGGER;

        public JSCHLogger() {
            this.levels.put(0, Level.FINE);
            this.levels.put(1, Level.INFO);
            this.levels.put(2, Level.WARNING);
            this.levels.put(3, Level.SEVERE);
            this.levels.put(4, Level.SEVERE);
            this.LOGGER = java.util.logging.Logger.getLogger("com.jcraft.jsch");
        }

        public boolean isEnabled(int pLevel) {
            Level level = this.levels.get(pLevel);
            if (level == null) {
                level = Level.SEVERE;
            }
            return this.LOGGER.isLoggable(level);
        }

        public void log(int pLevel, String pMessage) {
            Level level = this.levels.get(pLevel);
            if (level == null) {
                level = Level.SEVERE;
            }
            this.LOGGER.log(level, pMessage);
        }
    }

    static class CeciliaSSHUserInfo
    implements UserInfo {
        String _password = null;
        String _passphrase = null;

        CeciliaSSHUserInfo() {
        }

        public CeciliaSSHUserInfo setPassword(String value) {
            this._password = value;
            return this;
        }

        public CeciliaSSHUserInfo setPassphrase(String value) {
            this._passphrase = value;
            return this;
        }

        public String getPassphrase() {
            return this._passphrase;
        }

        public String getPassword() {
            return this._password;
        }

        public boolean promptPassphrase(String arg0) {
            System.err.println("promptPassphrase: " + arg0);
            return this._passphrase != null;
        }

        public boolean promptPassword(String arg0) {
            System.err.println("promptPassword: " + arg0);
            return this._password != null;
        }

        public boolean promptYesNo(String arg0) {
            System.err.println("promptYesNo: " + arg0);
            return true;
        }

        public void showMessage(String arg0) {
            System.out.println("showMessage: " + arg0);
        }
    }
}

