/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.crc.common.io;

import com.dassault.cecilia.crc.common.CRCException;
import com.dassault.cecilia.crc.common.io.IOFilesExchange;
import com.dassault.cecilia.crc.common.logging.CRCLogManager;
import com.dassault.cecilia.crc.common.logging.CRCLogger;
import com.dassault.cecilia.crc.common.template.RestTemplateUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.logging.Level;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class IOFilesExchangeHTTP
extends IOFilesExchange {
    private static final CRCLogger logger = CRCLogManager.getLogger(IOFilesExchangeHTTP.class);
    RestTemplate restTemplate;
    String urlBase;

    public IOFilesExchangeHTTP(RestTemplate restTemplate, String urlBase) {
        this.restTemplate = restTemplate;
        this.urlBase = urlBase;
    }

    @Override
    public void upload(long computeID, File srcFile) throws CRCException {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"file", (Object)new FileSystemResource(srcFile));
        HttpEntity requestEntity = new HttpEntity((Object)body, (MultiValueMap)headers);
        RestTemplateUtil.postForEntity(this.restTemplate, this.urlBase + "/upload-file/" + computeID, (Object)requestEntity, String.class);
    }

    @Override
    public void download(long computeID, Path localDir, boolean zipFile) throws CRCException {
        if (zipFile) {
            byte[] result = RestTemplateUtil.getForEntity(this.restTemplate, this.urlBase + "/download-filezip/" + computeID, byte[].class);
            Path resFile = localDir.resolve("result-" + computeID + ".zip");
            try {
                Files.write(resFile, result, new OpenOption[0]);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Erreur lors de l'ecriture du fichier: " + resFile, e);
                throw new CRCException(e);
            }
        } else {
            this.download(computeID, new File(localDir.toFile(), "result.res"), zipFile);
        }
    }

    @Override
    public void download(long computeID, File resFile, boolean zipFile) throws CRCException {
        if (zipFile) {
            byte[] result = RestTemplateUtil.getForEntity(this.restTemplate, this.urlBase + "/download-filezip/" + computeID, byte[].class);
            if (result == null) {
                throw new CRCException("Call '" + this.urlBase + "/download-filezip/" + computeID + "' sent null result");
            }
            this.dezipFile(new ByteArrayInputStream(result), resFile);
        } else {
            String result = RestTemplateUtil.getForEntity(this.restTemplate, this.urlBase + "/download-file/" + computeID, String.class);
            if (result == null) {
                throw new CRCException("Call '" + this.urlBase + "/download-file/" + computeID + "' sent null result");
            }
            try {
                Files.writeString(resFile.toPath(), (CharSequence)result, new OpenOption[0]);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Erreur lors de l'ecriture du fichier: " + resFile, e);
                throw new CRCException(e);
            }
        }
    }
}

