/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.crc.common.io;

import com.dassault.cecilia.crc.common.CRCException;
import com.dassault.cecilia.crc.common.io.IOFilesExchange;
import com.dassault.cecilia.crc.common.io.IOFilesExchangeSFTP;
import com.dassault.cecilia.crc.common.logging.CRCLogManager;
import com.dassault.cecilia.crc.common.logging.CRCLogger;
import com.dassault.cecilia.crc.common.pojo.SftpInfosResponse;
import com.dassault.cecilia.crc.common.pojo.SftpProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.logging.Level;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.sftp.RemoteResourceInfo;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;

public class IOFilesExchangeSFTPPrevious
extends IOFilesExchange {
    private static final CRCLogger logger = CRCLogManager.getLogger(IOFilesExchangeSFTP.class);
    private static final String SSH_USER_CECILIA = "cecilia";
    SftpProperties sftp;
    String sshFileKey = null;
    String sshUser = "cecilia";
    private SSHClient _sshClient;
    private Thread _sshDisconnectThread;

    public IOFilesExchangeSFTPPrevious(SftpInfosResponse sftpCredentials) {
        this.sftp = new SftpProperties(sftpCredentials);
    }

    public IOFilesExchangeSFTPPrevious(SftpProperties sftp) {
        this.sftp = sftp;
    }

    public IOFilesExchangeSFTPPrevious setSshFileKey(String sshFileKey) {
        this.sshFileKey = sshFileKey;
        return this;
    }

    public IOFilesExchangeSFTPPrevious setSshUser(String sshUser) {
        this.sshUser = sshUser;
        return this;
    }

    public synchronized void changeSftp(SftpProperties sftp) {
        if (this.sftp.equals(sftp)) {
            return;
        }
        this.sftp = sftp;
        if (this._sshClient != null) {
            try {
                this._sshClient.disconnect();
            }
            catch (IOException e) {
                logger.log(Level.INFO, "Exception during disconnect sshClient", e);
            }
            this._sshClient = null;
        }
    }

    @Override
    public void upload(long computeID, File srcFile) throws CRCException {
        SFTPClient sftpClient;
        try {
            sftpClient = this.setupSshj().newSFTPClient();
        }
        catch (CRCException se) {
            throw se;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Can't open sftp connexion with credentials", e);
            throw new CRCException("Can't open sftp connexion", e);
        }
        logger.log(Level.INFO, "sftp connexion initialized with success");
        String remoteDir = this.sftp.getComputationDirectory() + "/in/" + computeID;
        logger.log(Level.INFO, "Trying to transfer " + srcFile + " to remote directory " + remoteDir);
        try {
            this.createDirectoryIfNotExist(remoteDir, sftpClient);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Can't create remote directory " + remoteDir, e);
            throw new CRCException("Can't create remote directory " + remoteDir, e);
        }
        try {
            sftpClient.put(srcFile.getAbsolutePath(), remoteDir + "/eq.dag");
            logger.log(Level.FINE, "sftp transfer with success");
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Can't upload file " + srcFile.getAbsolutePath() + " to " + this.sftp.getComputationDirectory() + "/" + computeID, e);
            throw new CRCException("Can't upload file " + srcFile.getAbsolutePath(), e);
        }
        try {
            sftpClient.close();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Can't close sftp connexion", e);
            throw new CRCException("Can't close sftp connexion", e);
        }
    }

    @Override
    public void download(long computeID, File resFile, boolean zipMode) throws CRCException {
        this.download(computeID, resFile.getParentFile().toPath(), zipMode);
        if (zipMode) {
            File zipFile = new File(resFile.getParent(), "result-" + computeID + ".zip");
            try {
                this.dezipFile(new FileInputStream(zipFile), resFile);
            }
            catch (FileNotFoundException e) {
                logger.log(Level.SEVERE, "Can't access file " + zipFile, e);
                throw new CRCException("Can't access file " + zipFile, e);
            }
        }
    }

    @Override
    public void download(long computeID, Path localDir, boolean zipMode) throws CRCException {
        SFTPClient sftpClient;
        try {
            sftpClient = this.setupSshj().newSFTPClient();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "[sftp] Can't open sftp connexion with credentials", e);
            throw new CRCException("Can't open sftp connexion", e);
        }
        String remoteDir = this.sftp.getComputationDirectory() + "/out/" + computeID;
        try {
            Files.createDirectories(localDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "[sftp] Can't create local directory " + localDir, e);
            throw new CRCException("Can't create local directory " + localDir, e);
        }
        try {
            List entries = sftpClient.ls(remoteDir);
            boolean download = false;
            for (RemoteResourceInfo remoteFile : entries) {
                if (!remoteFile.isRegularFile()) continue;
                if (zipMode) {
                    if (!remoteFile.getPath().endsWith("result-" + computeID + ".zip")) continue;
                    if (download) {
                        logger.log(Level.WARNING, "[sftp] Already download file which name ends with 'result-" + computeID + ".zip'");
                        throw new CRCException("Already download file which name ends with 'result-" + computeID + ".zip'");
                    }
                    logger.log(Level.INFO, "Downloading " + remoteFile.getPath() + "...");
                    sftpClient.get(remoteFile.getPath(), localDir.toString());
                    download = true;
                    continue;
                }
                if (!remoteFile.getPath().endsWith(".res")) continue;
                if (download) {
                    logger.log(Level.WARNING, "[sftp] Already download file which name ends with '.res'");
                    throw new CRCException("Already download file which name ends with '.res'");
                }
                logger.log(Level.INFO, "Downloading " + remoteFile.getPath() + "...");
                sftpClient.get(remoteFile.getPath(), localDir.toString());
                download = true;
            }
            if (!download) {
                String msg = "Don't download result file '" + (String)(zipMode ? "result-" + computeID + ".zip" : "result.res") + "' from '" + remoteDir + "' path";
                logger.log(Level.WARNING, "[sftp] " + msg);
                throw new CRCException(msg);
            }
            sftpClient.close();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "[sftp] Can't download file from " + remoteDir + " to " + localDir, e);
            throw new CRCException("Can't download file from " + remoteDir, e);
        }
    }

    private void createDirectoryIfNotExist(String directory, SFTPClient sftpClient) throws IOException {
        FileAttributes fileAttributes = sftpClient.statExistence(directory);
        logger.log(Level.FINE, "Testing if directory " + directory + " exist.. " + fileAttributes);
        if (fileAttributes == null) {
            logger.log(Level.FINE, "Directory does not exist");
            logger.log(Level.INFO, "Trying to create remote directory " + directory);
            sftpClient.mkdirs(directory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String checkConnection() {
        SSHClient sshClient = null;
        SFTPClient sftpClient = null;
        try {
            sshClient = this.createSSHClient();
            sftpClient = sshClient.newSFTPClient();
            String remoteDir = this.sftp.getComputationDirectory() + "/out/";
            sftpClient.statExistence(remoteDir);
        }
        catch (CRCException e) {
            String string = e.getMessage();
            return string;
        }
        catch (IOException e) {
            String string = e.getMessage();
            return string;
        }
        catch (Exception e) {
            String string = e.getMessage();
            return string;
        }
        finally {
            if (sftpClient != null) {
                try {
                    sftpClient.close();
                }
                catch (Exception e) {
                    logger.log(Level.FINEST, "Closing sftp connection exception", e);
                }
            }
            if (sshClient != null) {
                try {
                    sshClient.disconnect();
                }
                catch (IOException e) {
                    logger.log(Level.FINEST, "Closing ssh connection exception", e);
                }
            }
        }
        return null;
    }

    private SSHClient createSSHClient() throws IOException, CRCException {
        SSHClient client = new SSHClient();
        client.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
        logger.log(Level.INFO, "connecting sftp with host=" + this.sftp.getHost() + " port=" + this.sftp.getPort());
        client.connect(this.sftp.getHost(), this.sftp.getPort().intValue());
        if (this.sshFileKey != null && !this.sshFileKey.isBlank()) {
            File keyFile = new File(this.sshFileKey);
            if (keyFile.exists()) {
                KeyProvider privateKey = client.loadKeys(keyFile.getPath());
                logger.log(Level.INFO, "user=" + this.sshUser + "\n privatekey=" + privateKey.toString());
                client.authPublickey(this.sshUser, new KeyProvider[]{privateKey});
            } else {
                logger.log(Level.WARNING, "There is no default identity file: " + this.sshFileKey);
            }
        } else if (this.sftp.getLogin() != null && this.sftp.getPassword() != null) {
            client.authPassword(this.sftp.getLogin(), this.sftp.getPassword());
        }
        if (this.sftp.getClientKeepAliveInterval() > 0) {
            logger.log(Level.FINEST, "Client keep alive interval: " + this.sftp.getClientKeepAliveInterval());
            client.getConnection().getKeepAlive().setKeepAliveInterval(this.sftp.getClientKeepAliveInterval().intValue());
        }
        return client;
    }

    private synchronized SSHClient setupSshj() throws IOException, CRCException {
        if (this._sshClient != null && !this._sshClient.isConnected()) {
            logger.log(Level.WARNING, "SSHClient disconnected => reconnection");
            this._sshClient = null;
        }
        if (this._sshClient == null) {
            this._sshClient = this.createSSHClient();
            if (this._sshDisconnectThread == null) {
                this._sshDisconnectThread = new Thread(){

                    @Override
                    public void run() {
                        if (IOFilesExchangeSFTPPrevious.this._sshClient != null) {
                            if (IOFilesExchangeSFTPPrevious.this._sshClient.isConnected()) {
                                try {
                                    logger.log(Level.FINE, "Disconnect sshClient for Cecilia Remote Compute");
                                    IOFilesExchangeSFTPPrevious.this._sshClient.disconnect();
                                }
                                catch (IOException e) {
                                    logger.log(Level.SEVERE, "During Shutdown application", e);
                                }
                            }
                            IOFilesExchangeSFTPPrevious.this._sshClient = null;
                        }
                    }
                };
                Runtime.getRuntime().addShutdownHook(this._sshDisconnectThread);
            }
        }
        return this._sshClient;
    }
}

