/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.crc.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SSLUtilCertificate2 {
    private static final Logger _LOG = Logger.getLogger(SSLUtilCertificate2.class.getName());

    private SSLUtilCertificate2() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void addKeyStoreAlternative(File keyStore, String passStore) {
        try {
            X509TrustManager defaultTrustManager = null;
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
                if (!(trustManager instanceof X509TrustManager)) continue;
                defaultTrustManager = (X509TrustManager)trustManager;
                break;
            }
            X509TrustManager alternateTrustManager = null;
            KeyStore myTrustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            try (FileInputStream inputStream = null;){
                inputStream = new FileInputStream(keyStore);
                myTrustStore.load(inputStream, passStore.toCharArray());
            }
            TrustManagerFactory trustManagerFactory2 = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory2.init(myTrustStore);
            for (TrustManager tm : trustManagerFactory2.getTrustManagers()) {
                if (!(tm instanceof X509TrustManager)) continue;
                alternateTrustManager = (X509TrustManager)tm;
                break;
            }
            WrapperX509TrustManager wrapper = new WrapperX509TrustManager(defaultTrustManager, alternateTrustManager);
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, new TrustManager[]{wrapper}, null);
            SSLContext.setDefault(context);
        }
        catch (Exception e) {
            _LOG.log(Level.SEVERE, "SSLUtil upgrade context exception", e);
            throw new RuntimeException(e);
        }
    }

    static class WrapperX509TrustManager
    implements X509TrustManager {
        X509TrustManager _defaultTM;
        X509TrustManager _alternateTM;

        public WrapperX509TrustManager(X509TrustManager defaultTM, X509TrustManager alternateTM) {
            this._defaultTM = defaultTM;
            this._alternateTM = alternateTM;
        }

        private X509Certificate[] mergeCertificates() {
            ArrayList<X509Certificate> resultingCerts = new ArrayList<X509Certificate>();
            resultingCerts.addAll(Arrays.asList(this._defaultTM.getAcceptedIssuers()));
            resultingCerts.addAll(Arrays.asList(this._alternateTM.getAcceptedIssuers()));
            return resultingCerts.toArray(new X509Certificate[resultingCerts.size()]);
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.mergeCertificates();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            try {
                this._alternateTM.checkServerTrusted(chain, authType);
            }
            catch (CertificateException e) {
                this._defaultTM.checkServerTrusted(chain, authType);
            }
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this._defaultTM.checkClientTrusted(this.mergeCertificates(), authType);
        }
    }
}

