/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.crc.common.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class SSLUtilCertificate3 {
    private static final Logger _LOG = Logger.getLogger(SSLUtilCertificate3.class.getName());
    private static KeyStore _keyStore;

    private SSLUtilCertificate3() {
    }

    public static synchronized void addCertificates(File directory) {
        SSLUtilCertificate3.addCertificates_rec(directory);
        SSLUtilCertificate3.upgradeContext(_keyStore);
    }

    private static void addCertificates_rec(File folder) {
        if (!folder.exists()) {
            _LOG.log(Level.WARNING, "SSLUtil don't exist certificate file: " + folder.getName());
            return;
        }
        if (!folder.canRead()) {
            _LOG.log(Level.WARNING, "SSLUtil can't read certificate file: " + folder.getName());
            return;
        }
        if (folder.isDirectory()) {
            _LOG.log(Level.INFO, "SSLUtil add certificate(s) from the directory: " + folder.getName());
            for (File fileEntry : folder.listFiles()) {
                if (fileEntry.getName().toLowerCase().endsWith(".txt")) continue;
                SSLUtilCertificate3.addCertificates_rec(fileEntry);
            }
        } else {
            _LOG.log(Level.INFO, "SSLUtil add certificate: " + folder.getName());
            _keyStore = SSLUtilCertificate3.addCertificate(_keyStore, folder.getName(), folder, "changeit");
        }
    }

    private static KeyStore addCertificate(KeyStore keyStore, String entry, File certificate, String pwd) {
        keyStore = SSLUtilCertificate3.createKeyStore(keyStore, pwd);
        try {
            BufferedInputStream caInput = new BufferedInputStream(new FileInputStream(certificate));
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Certificate crt = cf.generateCertificate(caInput);
            _LOG.log(Level.INFO, "SSLUtil add certificat for " + ((X509Certificate)crt).getSubjectX500Principal());
            keyStore.setCertificateEntry(entry, crt);
        }
        catch (Exception e) {
            _LOG.log(Level.SEVERE, "SSLUtil add certificat exception", e);
            throw new RuntimeException(e);
        }
        return keyStore;
    }

    private static KeyStore createKeyStore(KeyStore keyStore, String pwd) {
        if (keyStore == null) {
            FileInputStream fileStream = null;
            try {
                keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                StringBuilder path = new StringBuilder();
                path.append(System.getProperty("java.home")).append(File.separator).append("lib").append(File.separator).append("security").append(File.separator).append("cacerts");
                fileStream = new FileInputStream(new File(path.toString()));
                keyStore.load(fileStream, pwd.toCharArray());
            }
            catch (Exception e) {
                _LOG.log(Level.SEVERE, "SSLUtil create KeyStore exception", e);
                throw new RuntimeException(e);
            }
            finally {
                if (fileStream != null) {
                    try {
                        fileStream.close();
                    }
                    catch (IOException e) {
                        _LOG.log(Level.WARNING, e.getMessage(), e);
                    }
                }
            }
        }
        return keyStore;
    }

    private static void upgradeContext(KeyStore keyStore) {
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keyStore);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, tmf.getTrustManagers(), null);
            SSLContext.setDefault(sslContext);
        }
        catch (Exception e) {
            _LOG.log(Level.SEVERE, "SSLUtil upgrade context exception", e);
            throw new RuntimeException(e);
        }
    }
}

