/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.admin;

import com.dassault.cecilia.core.ConfigManager;
import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.LaunchIniReader;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.other.SplashScreenGui;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.db.dao.DAOUtility;
import com.dassault.cecilia.db.dao.sql.SQLTable;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.main.admin.CApplAdmin;
import com.dassault.cecilia.main.admin.FoldersPanel;
import com.dassault.cecilia.main.admin.ResMsgAdmin;
import com.dassault.cecilia.main.admin.others.OtherMainPanel;
import com.dassault.cecilia.main.admin.patchs.CorrectorDependFreeze;
import com.dassault.cecilia.main.admin.patchs.CorrectorGeneralMigration;
import com.dassault.cecilia.main.admin.patchs.CorrectorLocalFolder;
import com.dassault.cecilia.main.admin.patchs.CorrectorObjects;
import com.dassault.cecilia.main.admin.patchs.CorrectorSpecficLinkFRB;
import com.dassault.cecilia.main.admin.users.UserMainPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.TimerTask;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class CAdminGUI
extends JFrame {
    private static Logger _LOG = Logger.getLogger(CAdminGUI.class.getPackage().getName());
    public static final String DEF_PERIODICITY_CONNECT = "1000";
    public static final String PROP_PERIODICITY_CONNECT = "cecilia.admin.RefreshPeriodicityConnect";
    CeciliaAction _actionQuit;
    CeciliaAction _actionAbout;
    CeciliaAction _actionRefresh;
    CeciliaAction _actionCorrectionFreeze;
    CeciliaAction _actionCorrectionLocalFolder;
    CeciliaAction _actionCorrectionSpecficLinkFRB;
    CeciliaAction _actionCorrectionReplayMigration;
    CeciliaAction _actionCorrectionObject;
    CeciliaAction _actionCorrectionDeleteWorkingRelation;
    public JTabbedPane _tabPane = new JTabbedPane();
    OtherMainPanel _ctrlOthers;
    UserMainPanel _ctrlUsers;
    FoldersPanel _ctrlFolders;
    public static JPanel _panelInformations = new JPanel();
    private JTextField _timeField = new JTextField("               ");
    private JTextField _dateField = new JTextField("                     ");
    private JTextField _messageField = new JTextField("                     ");
    private JTextField _loginField = new JTextField("               ");
    private JTextField _connectField = new JTextField("   ");
    public boolean _dataBaseState = false;
    private CApplAdmin _application;

    public CAdminGUI(CApplAdmin appl) {
        this._application = appl;
        this._application.setTopWindow(this);
    }

    void init(StringBuffer logBuffer) {
        this._application.init(logBuffer);
        this.setTitle(this._application.getTitle());
        this.setIconImages(this._application.getIcons());
        this.setDefaultCloseOperation(0);
        this.setBounds(400, 150, 1000, 700);
        boolean launch = false;
        if (this._application.standardDatabaseConnection() && this._application.standardUserLogin(true, false) && this._application.openSession()) {
            this.makePanel();
            this.setLocationRelativeTo(null);
            this.setVisible(true);
            launch = true;
        }
        if (!launch) {
            this._application.exit(0);
        } else {
            this.setTitle(this._application.getTitle());
        }
    }

    private void makePanel() {
        this.makeActions();
        this.makeMenu();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                CAdminGUI.this.confirmQuitAndClose();
                super.windowClosing(e);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this._tabPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.makeFolderTab();
        this.makeUserTab();
        this.makeOtherTab();
        this.makeInformationBar();
        this.getContentPane().add((Component)_panelInformations, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
    }

    private void makeInformationBar() {
        _panelInformations.setLayout(new GridBagLayout());
        long periodicityConnect = Long.getLong(PROP_PERIODICITY_CONNECT, Long.parseLong(DEF_PERIODICITY_CONNECT));
        int x = 0;
        _panelInformations.add((Component)this._timeField, new GridBagConstraints(x++, 0, 1, 1, 0.0, 1.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
        _panelInformations.add((Component)this._dateField, new GridBagConstraints(x++, 0, 1, 1, 0.0, 1.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
        _panelInformations.add((Component)this._messageField, new GridBagConstraints(x++, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(1, 2, 1, 0), 0, 0));
        _panelInformations.add((Component)this._loginField, new GridBagConstraints(x++, 0, 1, 1, 0.0, 1.0, 17, 3, new Insets(1, 2, 1, 0), 0, 0));
        if (periodicityConnect > 0L) {
            _panelInformations.add((Component)this._connectField, new GridBagConstraints(x++, 0, 1, 1, 0.0, 1.0, 17, 3, new Insets(1, 2, 1, 0), 0, 0));
        }
        this._timeField.setEditable(false);
        this._timeField.setBorder(BorderFactory.createLoweredBevelBorder());
        this._dateField.setEditable(false);
        this._dateField.setBorder(BorderFactory.createLoweredBevelBorder());
        this._application.addShedulerTask(new TimerTask(){

            @Override
            public void run() {
                Date date = new Date();
                SimpleDateFormat df = new SimpleDateFormat();
                String timezone = System.getProperty("user.timezone");
                if (timezone != null) {
                    df.setTimeZone(TimeZone.getTimeZone(timezone));
                }
                String dateStr = df.format(date);
                int position = dateStr.indexOf(" ");
                CAdminGUI.this._dateField.setText(" " + dateStr.substring(0, position) + " ");
                CAdminGUI.this._timeField.setText(" " + dateStr.substring(position + 1) + " ");
            }
        }, 10L, 60000L);
        this._messageField.setEditable(false);
        this._messageField.setBorder(BorderFactory.createEmptyBorder());
        this._loginField.setEditable(false);
        DBUser user = this._application.getDBUser();
        this._loginField.setText(user.getLogin());
        StringBuffer tt = new StringBuffer().append(user.getName());
        String descr = user.getDescription();
        if (descr != null) {
            tt.append(" - ").append(descr);
        }
        this._loginField.setToolTipText(tt.toString());
        this._loginField.setBorder(BorderFactory.createLoweredBevelBorder());
        if (periodicityConnect > 0L) {
            this._connectField.setEditable(false);
            this._connectField.setBorder(BorderFactory.createLoweredBevelBorder());
            this._application.addShedulerTask(new TimerTask(){

                @Override
                public void run() {
                    int countConnection = CAdminGUI.this._application.getDAOFactory().createLicenseDAO().getCountConnection();
                    CAdminGUI.this._connectField.setText(" " + countConnection);
                }
            }, Math.min(100L, periodicityConnect), periodicityConnect);
        }
    }

    private void makeFolderTab() {
        DAOFolder daoFolder = this._application.getDAOFactory().createFolderDAO();
        DBFolder root = daoFolder.getRootID("ROOT");
        this._ctrlFolders = new FoldersPanel(this._application, root);
        StringBuffer titleTab = new StringBuffer();
        titleTab.append(ResMsgVoc.getString("VOC_FOLDERS"));
        this._tabPane.addTab(titleTab.toString(), this._ctrlFolders);
    }

    private void makeUserTab() {
        this._ctrlUsers = new UserMainPanel(this._application);
        StringBuffer titleTab = new StringBuffer();
        titleTab.append(ResMsgAdmin.getString("LBL_GROUPS_AND_USERS"));
        this._tabPane.addTab(titleTab.toString(), this._ctrlUsers);
        this._ctrlUsers.refresh();
    }

    private void makeOtherTab() {
        this._ctrlOthers = new OtherMainPanel(this._application.getDAOFactory(), this._application);
        StringBuffer titleTab = new StringBuffer();
        titleTab.append(ResMsgAdmin.getString("LBL_OTHER_INFORMATIONS"));
        this._tabPane.addTab(titleTab.toString(), this._ctrlOthers);
        this._ctrlOthers.refresh();
    }

    private void makeActions() {
        this._actionQuit = new CeciliaAction(ResIcoCore.getImageIcon("BUT_QUIT"), ResMsgVoc.getString("VOC_QUIT")){

            @Override
            public void actionPerformed(ActionEvent e) {
                CAdminGUI.this.confirmQuitAndClose();
            }
        };
        this._actionAbout = new CeciliaAction(ResMsgAdmin.getString("ACTION_ABOUT_MENU")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SplashScreenGui gui = new SplashScreenGui(CAdminGUI.this, 3000L){

                    @Override
                    protected ImageIcon getImageIcon() {
                        return CAdminGUI.this._application.getSplashIcon();
                    }

                    @Override
                    protected String getCopyright() {
                        GregorianCalendar calendar = new GregorianCalendar();
                        calendar.setTime(new Date());
                        return "Copyright \u00a9 1984-" + calendar.get(1) + " DASSAULT AVIATION. All Rights Reserved.";
                    }

                    @Override
                    protected String getVersion() {
                        return ConfigManager.getVersionLabel();
                    }
                };
                gui.setVisible(true);
            }
        };
        this._actionRefresh = new CeciliaAction(ResIcoCore.getImageIcon("BUT_REFRESH"), ResMsgVoc.getString("VOC_REFRESH"), ResMsgObj.getString("ACTION_REFRESH_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                CAdminGUI.this.refresh();
            }
        };
        this._actionCorrectionFreeze = new CeciliaAction(ResMsgAdmin.getString("PATCH_FREEZE_DEPENDS_TITLE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                CorrectorDependFreeze cmd = new CorrectorDependFreeze(CAdminGUI.this._application, CAdminGUI.this);
                cmd.realiseDo();
            }
        };
        this._actionCorrectionLocalFolder = new CeciliaAction(ResMsgAdmin.getString("PATCH_LOCAL_FOLDER_TITLE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                CorrectorLocalFolder cmd = new CorrectorLocalFolder(CAdminGUI.this._application, CAdminGUI.this);
                cmd.realiseDo();
            }
        };
        this._actionCorrectionObject = new CeciliaAction(ResMsgAdmin.getString("PATCH_VERIFYOBJECT_TITLE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                CorrectorObjects cmd = new CorrectorObjects(CAdminGUI.this._application, CAdminGUI.this);
                cmd.realiseDo();
            }
        };
        this._actionCorrectionSpecficLinkFRB = new CeciliaAction(ResMsgAdmin.getString("PATCH_LINK_OLD_FRB_TITLE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                CorrectorSpecficLinkFRB cmd = new CorrectorSpecficLinkFRB(CAdminGUI.this._application, CAdminGUI.this);
                cmd.realiseDo();
            }
        };
        this._actionCorrectionReplayMigration = new CeciliaAction(ResMsgAdmin.getString("PATCH_MIGRATION_TITLE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                CorrectorGeneralMigration cmd = new CorrectorGeneralMigration(CAdminGUI.this._application, CAdminGUI.this);
                cmd.realiseDo();
            }
        };
        this._actionCorrectionDeleteWorkingRelation = new CeciliaAction(ResMsgAdmin.getString("PATCH_DELETE_WORKING_RELATION")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DAOUtility daoUtility = CAdminGUI.this._application.getDAOFactory().createUtilityDAO();
                int nbrUpdate = daoUtility.updateOrDeleteDirectDB("DELETE FROM " + SQLTable.RELATIONS + " WHERE rel_src_type = 'WORKING' AND rel_src_id IN (SELECT fol_id FROM " + SQLTable.OBJECTS + ", " + SQLTable.FOLDERS + " WHERE fol_obj_id = obj_id AND (obj_ses_id IS NULL OR obj_flags= 2))");
                if (nbrUpdate == -1) {
                    JOptionPane.showMessageDialog(CAdminGUI.this, ResMsgAdmin.getString("PATCH_DELETE_WORKING_RELATION"), ResMsgAdmin.getString("PATCH_DELETE_WORKING_RELATION"), 0);
                } else {
                    _LOG.info("Number of Working relation deleted : " + nbrUpdate);
                    JOptionPane.showMessageDialog(CAdminGUI.this, ResMsgAdmin.msgFormat("PATCH_DELETE_WORKING_RELATION_INFORMATION", nbrUpdate), ResMsgAdmin.getString("PATCH_DELETE_WORKING_RELATION"), 1);
                }
            }
        };
    }

    private void makeMenu() {
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu menuFile = new JMenu(ResMsgVoc.getString("VOC_FILE"));
        menuBar.add(menuFile);
        menuFile.add(this._actionQuit);
        JMenu menuAbout = new JMenu(ResMsgAdmin.getString("MENU_ANSWER"));
        menuBar.add(menuAbout);
        menuAbout.add(this._actionRefresh);
        menuAbout.addSeparator();
        menuAbout.add(this._actionAbout);
        menuAbout.addSeparator();
        menuAbout.add(this._actionCorrectionFreeze);
        menuAbout.add(this._actionCorrectionLocalFolder);
        menuAbout.add(this._actionCorrectionObject);
        menuAbout.add(this._actionCorrectionSpecficLinkFRB);
        menuAbout.add(this._actionCorrectionReplayMigration);
        menuAbout.add(this._actionCorrectionDeleteWorkingRelation);
        if (this._application.isDebugMode()) {
            // empty if block
        }
    }

    public void confirmQuitAndClose() {
        if (JOptionPane.showConfirmDialog(JOptionCecilia.getTopContainerOf(this), ResMsgAdmin.getString("MSG_APP_CONFIRM_QUIT"), this.getTitle(), 2, -1) == 0) {
            this._application.close();
        }
    }

    public void refreshDatabase() {
        this._application.refreshDAOFolder(false);
    }

    public void refresh() {
        switch (this._tabPane.getSelectedIndex()) {
            case 0: {
                this._ctrlFolders.doRefresh();
                break;
            }
            case 1: {
                this._ctrlUsers.refresh();
                break;
            }
            case 2: {
                this._ctrlOthers.refresh();
            }
        }
    }

    public static void main(String[] args) {
        StringBuffer logBuffer = new StringBuffer();
        LaunchIniReader.initLaunchIni("Admin", logBuffer);
        CApplAdmin application = new CApplAdmin();
        CAdminGUI adminGUI = new CAdminGUI(application);
        adminGUI.init(logBuffer);
    }
}

