/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.admin;

import com.dassault.cecilia.core.cecilia.access.AccessRightEditDlg;
import com.dassault.cecilia.db.DBAccess;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBGroup;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.IUser;
import com.dassault.cecilia.db.dao.DAOFolder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class DBFolderRunChangeAccess
implements Runnable {
    DAOFolder _daoFolder;
    IUser _userLogin;
    List<DBFolder> _folders;
    boolean _withSubFolders;
    boolean _withSubElements;
    DBUser _userOwner;
    DBGroup _grpOwner;
    DBAccess.Right _groupRight;
    DBAccess.Right _otherRight;
    List<DBAccess> _otherAccess;
    Set<Long> _idTreated;
    Set<DBFolder> _foldersWithError;

    public DBFolderRunChangeAccess(DAOFolder daoFolder, IUser userLogin) {
        this._daoFolder = daoFolder;
        this._userLogin = userLogin;
    }

    public void prepareThread(List<DBFolder> folders, AccessRightEditDlg dlg) {
        this._folders = folders;
        this._withSubFolders = dlg.isApplicableAtSubFolders();
        this._withSubElements = dlg.isApplicableAtSubElements();
        this._userOwner = dlg.getSelectedOwnerUser();
        this._grpOwner = dlg.getSelectedOwnerGroup();
        this._groupRight = dlg.getRightForOwnerGroup();
        this._otherRight = dlg.getRightForOtherUser();
        this._otherAccess = dlg.getAccessesRight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this._idTreated = new HashSet<Long>();
        this._foldersWithError = new LinkedHashSet<DBFolder>();
        boolean oldAutoUpdateObject = this._daoFolder.isAutoUpdateObject();
        boolean oldAutoUpdateDepenties = this._daoFolder.isAutoUpdateDepenties();
        try {
            this._daoFolder.setAutoUpdateObject(false).setAutoUpdateDepenties(false);
            do {
                ArrayList<DBFolder> foldersStack = new ArrayList<DBFolder>();
                for (DBFolder dbFolder : this._folders) {
                    long id = dbFolder.getID();
                    if (this._idTreated.contains(id)) continue;
                    this._idTreated.add(id);
                    if (!dbFolder.isSystem()) {
                        boolean change = false;
                        if (this._userOwner != null && !dbFolder.getUserOwner().equals(this._userOwner)) {
                            change = true;
                            dbFolder.setUserOwner(this._userOwner);
                        }
                        if (this._grpOwner != null && !dbFolder.getGroupOwner().equals(this._grpOwner)) {
                            change = true;
                            dbFolder.setGroupOwner(this._grpOwner);
                        }
                        if (change) {
                            dbFolder.setDateModify(new Date());
                            dbFolder.setUserModify(this._userLogin);
                        }
                        if (this._groupRight != null) {
                            dbFolder.setRightGroup(this._groupRight);
                        }
                        if (this._otherRight != null) {
                            dbFolder.setRightOther(this._otherRight);
                        }
                        if (this._otherAccess != null) {
                            dbFolder.setAccesses(this._otherAccess);
                        }
                        if (!this._daoFolder.update(dbFolder)) {
                            this._foldersWithError.add(dbFolder);
                            this._daoFolder.refresh(dbFolder);
                        }
                    }
                    if ((!this._withSubFolders || !dbFolder.isFolder()) && (!this._withSubElements || !dbFolder.isModel())) continue;
                    List<DBFolder> children = dbFolder.getChildren();
                    if (children == null) {
                        children = this._daoFolder.findChildren(dbFolder);
                    }
                    if (children != null) {
                        foldersStack.addAll(children);
                        continue;
                    }
                    this._foldersWithError.add(dbFolder);
                }
                this._folders = foldersStack;
            } while (this._folders.size() > 0);
        }
        finally {
            this._daoFolder.setAutoUpdateObject(oldAutoUpdateObject);
            this._daoFolder.setAutoUpdateDepenties(oldAutoUpdateDepenties);
        }
    }

    public boolean hasChangedFolder() {
        if (this._idTreated == null) {
            return false;
        }
        return this._idTreated.size() > 0;
    }

    public Set<DBFolder> getFoldersWithError() {
        return this._foldersWithError;
    }
}

