/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.admin;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.access.AccessRightEditDlg;
import com.dassault.cecilia.core.cecilia.dependencies.Generate;
import com.dassault.cecilia.core.cecilia.dependencies.GenerateDepFolders;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeNode;
import com.dassault.cecilia.core.cecilia.folder.FolderTreeTable;
import com.dassault.cecilia.core.cecilia.folder.FolderTreeTableModel;
import com.dassault.cecilia.core.cecilia.folder.gui.DBFolderDlgDepend;
import com.dassault.cecilia.core.cecilia.folder.gui.DBObjectDlgDebug;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.IUser;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.folder.DBFolderCmdFreeze;
import com.dassault.cecilia.main.admin.DBFolderRunChangeAccess;
import com.dassault.cecilia.main.admin.ResIcoAdmin;
import com.dassault.cecilia.main.admin.ResMsgAdmin;
import com.dassault.cecilia.main.admin.view.DBFolderDebugWindows;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FoldersPanel
extends JPanel {
    CAppl _application;
    DAOFactory _daoFactory;
    DAOFolder _daoFolder;
    IUser _userLogin;
    DBFolder _rootItem;
    FolderTreeTableModel _treeFolderModel;
    FolderTreeTable _ctrlTreeFolder;
    CeciliaAction _ctrlEdit;
    CeciliaAction _ctrlView;
    CeciliaAction _ctrlRefresh;
    CeciliaAction _ctrlUnfreeze;
    CeciliaAction _ctrlUnfreezeSelection;
    CeciliaAction _ctrlDebug;
    CeciliaAction _ctrlDependDown;
    CeciliaAction _ctrlDependUp;
    JPopupMenu _popupList;

    public FoldersPanel(CAppl application, DBFolder rootItem) {
        super(new BorderLayout());
        this._application = application;
        this._daoFactory = this._application.getDAOFactory();
        this._daoFolder = this._daoFactory.createFolderDAO();
        this._rootItem = rootItem;
        this._userLogin = this._application.getDBUser();
        this.create();
    }

    protected void createActions() {
        this._ctrlEdit = new CeciliaAction(ResIcoCore.getImageIcon("BUT_EDIT"), ResMsgVoc.getString("VOC_EDIT"), ResMsgCore.getString("ACTION_EDIT_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                FoldersPanel.this.actionEditFolders();
            }
        };
        this._ctrlView = new CeciliaAction(ResIcoAdmin.getImageIcon("BUT_TREE"), ResMsgAdmin.getString("ACTION_TREE_VIEW_MENU"), ResMsgAdmin.getString("ACTION_TREE_VIEW_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBFolderDebugWindows.createAndDisplay(FoldersPanel.this._application.getTopWindow(), FoldersPanel.this._application);
            }
        };
        this._ctrlRefresh = new CeciliaAction(ResIcoCore.getImageIcon("BUT_REFRESH"), ResMsgVoc.getString("VOC_REFRESH"), ResMsgObj.getString("ACTION_REFRESH_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                FoldersPanel.this.doRefresh();
            }
        };
        this._ctrlUnfreeze = new CeciliaAction(null, ResMsgVoc.getString("VOC_UNFREEZE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                FoldersPanel.this.doUnfreezeAction(false);
            }
        };
        this._ctrlUnfreeze.setEnabled(false);
        this._ctrlUnfreezeSelection = new CeciliaAction(null, ResMsgVoc.getString("VOC_UNFREEZE_SELECTION")){

            @Override
            public void actionPerformed(ActionEvent e) {
                FoldersPanel.this.doUnfreezeAction(true);
            }
        };
        this._ctrlUnfreezeSelection.setEnabled(false);
        this._ctrlDebug = new CeciliaAction("Debug"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBFolderTreeNode selectFolder = FoldersPanel.this.getSelectedFolderTreeNode();
                if (selectFolder == null) {
                    return;
                }
                DBFolder folder = selectFolder.getSource();
                FoldersPanel.this.doDebug(folder);
            }
        }.setDesc("Affiche une fen\u00eatre d'affichage d'information sur l'\u00e9l\u00e9ment courant");
        this._ctrlDebug.setEnabled(false);
        this._ctrlDependDown = new CeciliaAction("Depend (Descendants)"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBFolderTreeNode selectFolder = FoldersPanel.this.getSelectedFolderTreeNode();
                if (selectFolder == null) {
                    return;
                }
                DBFolder folder = selectFolder.getSource();
                FoldersPanel.this.doDependDescendants(folder);
            }
        }.setDesc("Affiche la liste tous les dossiers dependants (Descendants)");
        this._ctrlDependDown.setEnabled(false);
        this._ctrlDependUp = new CeciliaAction("Depend (Ancestors)"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBFolderTreeNode selectFolder = FoldersPanel.this.getSelectedFolderTreeNode();
                if (selectFolder == null) {
                    return;
                }
                DBFolder folder = selectFolder.getSource();
                FoldersPanel.this.doDependAncestors(folder);
            }
        }.setDesc("Affiche la liste tous les dossiers qui d\u00e9pendent de la s\u00e9lection (Anc\u00eatres)");
        this._ctrlDependUp.setEnabled(false);
    }

    private void doUnfreezeAction(boolean onSelection) {
        List<DBFolderTreeNode> listNodes = this.getListSelectedFolderTreeNode();
        if (listNodes.isEmpty()) {
            return;
        }
        List<DBFolder> list = listNodes.stream().map(DBFolderTreeNode::getDBFolder).collect(Collectors.toList());
        DBFolderCmdFreeze cmd = new DBFolderCmdFreeze(this._application, this, list, this._application.getDBUser(), false);
        cmd.setOnSelection(onSelection);
        cmd.realiseDo();
    }

    protected JPopupMenu createMenuActions(JPopupMenu popupList) {
        popupList.add(this._ctrlEdit);
        popupList.addSeparator();
        popupList.add(this._ctrlRefresh);
        popupList.addSeparator();
        popupList.add(this._ctrlView);
        if (this._application.getDBUser().isMasterAdmin()) {
            popupList.add(this._ctrlUnfreeze);
            popupList.add(this._ctrlUnfreezeSelection);
            popupList.addSeparator();
            popupList.add(this._ctrlDebug);
            popupList.add(this._ctrlDependDown);
            popupList.add(this._ctrlDependUp);
        }
        return popupList;
    }

    protected void createBoxActions(Container toolbar) {
        toolbar.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        toolbar.add(this._ctrlView.createButton(CeciliaAction.BorderStyle.LIGHT));
        toolbar.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        toolbar.add(this._ctrlRefresh.createButton(CeciliaAction.BorderStyle.LIGHT));
        toolbar.add(Box.createGlue());
        toolbar.add(this._ctrlEdit.createButton(CeciliaAction.BorderStyle.LIGHT));
        toolbar.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
    }

    private void createTreeFolder() {
        this._treeFolderModel = new FolderTreeTableModel(this._daoFolder, this._rootItem);
        this._treeFolderModel.setDebugMode(this._application.isDebugMode());
        this._application.addFolderUpdateListener(this._treeFolderModel);
        this._ctrlTreeFolder = new FolderTreeTable(this._treeFolderModel);
        this._ctrlTreeFolder.setPreferredScrollableViewportSize(new Dimension(300, 400));
        this._ctrlTreeFolder.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FoldersPanel.this.refreshCtrl();
                    }
                });
            }
        });
    }

    private void create() {
        this.createActions();
        JToolBar toolbar = new JToolBar();
        toolbar.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.createBoxActions(toolbar);
        toolbar.setFloatable(false);
        this.add((Component)toolbar, "North");
        this._popupList = new JPopupMenu();
        this._popupList = this.createMenuActions(this._popupList);
        this.createTreeFolder();
        this._ctrlTreeFolder.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!SwingUtilities.isMiddleMouseButton(e)) {
                    return;
                }
                FoldersPanel.this.actionEditFolders();
                e.consume();
            }
        });
        this._ctrlTreeFolder.setInheritsPopupMenu(true);
        JScrollPane scrollTable = new JScrollPane(this._ctrlTreeFolder);
        scrollTable.setComponentPopupMenu(this._popupList);
        scrollTable.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)scrollTable, "Center");
        if (this._ctrlTreeFolder.getModel().getRowCount() > 0) {
            this._ctrlTreeFolder.setRowSelectionInterval(0, 0);
        }
        this.refreshCtrl();
    }

    protected void refreshCtrl() {
        DBFolder dbFolder;
        DBFolderTreeNode selectFolder;
        boolean isEnabled = this.isEnabled();
        int selRowCount = this._ctrlTreeFolder.getSelectedRowCount();
        if (isEnabled && selRowCount > 0) {
            boolean editEnabled = true;
            int[] rows = this._ctrlTreeFolder.getSelectedRows();
            for (int i = 0; editEnabled && i < rows.length; ++i) {
                DBFolderTreeNode nodeFolder = (DBFolderTreeNode)this._ctrlTreeFolder.getObjectAtRow(rows[i]);
                if (!nodeFolder.isSystem()) continue;
                editEnabled = false;
            }
            this._ctrlEdit.setEnabled(editEnabled);
        } else {
            this._ctrlEdit.setEnabled(false);
        }
        boolean enabledDebug = false;
        boolean enabledUnfreeze = isEnabled;
        if (isEnabled && selRowCount == 1 && (selectFolder = this.getSelectedFolderTreeNode()) != null && (dbFolder = selectFolder.getSource()).getObject() != null) {
            enabledDebug = true;
            enabledUnfreeze = dbFolder.isFreeze();
        }
        this._ctrlDebug.setEnabled(enabledDebug);
        this._ctrlDependDown.setEnabled(enabledDebug);
        this._ctrlDependUp.setEnabled(enabledDebug);
        this._ctrlUnfreeze.setEnabled(enabledUnfreeze);
        this._ctrlUnfreezeSelection.setEnabled(enabledUnfreeze);
        this._ctrlView.setEnabled(isEnabled);
        this._ctrlRefresh.setEnabled(isEnabled);
    }

    private void actionEditFolders() {
        if (this._ctrlTreeFolder.getSelectedRowCount() <= 0) {
            return;
        }
        ArrayList<DBFolder> selectFolders = new ArrayList<DBFolder>();
        int[] rows = this._ctrlTreeFolder.getSelectedRows();
        for (int i = 0; i < rows.length; ++i) {
            DBFolderTreeNode nodeFolder = (DBFolderTreeNode)this._ctrlTreeFolder.getObjectAtRow(rows[i]);
            if (nodeFolder.isSystem()) continue;
            selectFolders.add(nodeFolder.getDBFolder());
        }
        if (selectFolders.size() > 0) {
            this.editAccessFolders(selectFolders);
        }
    }

    protected void editAccessFolders(List<DBFolder> folders) {
        if (folders.size() == 0) {
            return;
        }
        for (DBFolder dbFolder : folders) {
            if (dbFolder.getAccesses() != null) continue;
            this._daoFolder.findAccesses(dbFolder);
        }
        AccessRightEditDlg dlg = new AccessRightEditDlg(SwingUtilities.getWindowAncestor(this));
        dlg.setUsersAndGroups(this._daoFactory.createUserDAO().findAll(), this._daoFactory.createGroupDAO().findAll());
        dlg.setFolders(folders);
        dlg.makeAndDisplay();
        if (dlg.getResult()) {
            DBFolderRunChangeAccess thread = new DBFolderRunChangeAccess(this._daoFolder, this._userLogin);
            thread.prepareThread(folders, dlg);
            thread.run();
            Set<DBFolder> foldersWithError = thread.getFoldersWithError();
            if (foldersWithError.size() > 0) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlTreeFolder), ResMsgAdmin.msgFormat("MSG_FOL_BAD_UPDATE_ACCESS_RIGHTS", foldersWithError.toString()), this._application.getTitle(), 0);
            }
            if (thread.hasChangedFolder()) {
                this._application.refreshDAOFolder(true);
            }
        }
    }

    private List<DBFolderTreeNode> getListSelectedFolderTreeNode() {
        ArrayList<DBFolderTreeNode> nodes = new ArrayList<DBFolderTreeNode>();
        if (this._ctrlTreeFolder.getSelectedRow() == -1) {
            return nodes;
        }
        for (int row : this._ctrlTreeFolder.getSelectedRows()) {
            DBFolderTreeNode selectFolder = (DBFolderTreeNode)this._ctrlTreeFolder.getObjectAtRow(row);
            if (selectFolder.isSystem()) continue;
            nodes.add(selectFolder);
        }
        return nodes;
    }

    private DBFolderTreeNode getSelectedFolderTreeNode() {
        if (this._ctrlTreeFolder.getSelectedRowCount() != 1) {
            return null;
        }
        int row = this._ctrlTreeFolder.getSelectedRow();
        if (row == -1) {
            return null;
        }
        DBFolderTreeNode selectFolder = (DBFolderTreeNode)this._ctrlTreeFolder.getObjectAtRow(row);
        if (selectFolder.isSystem()) {
            return null;
        }
        return selectFolder;
    }

    public void doRefresh() {
        this._application.refreshDAOFolder(false);
        this._treeFolderModel.refreshAll();
    }

    public void doDebug(DBFolder folder) {
        if (folder.getObject() == null) {
            return;
        }
        DBObjectDlgDebug dlg = new DBObjectDlgDebug(SwingUtilities.getWindowAncestor(this));
        dlg.setTitle("Debug - " + this._application.getTitle());
        dlg.setDAOFactory(this._application.getDAOFactory());
        dlg.setSelect(folder);
        dlg.setModal(true);
        dlg.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(this));
        dlg.setVisible(true);
    }

    public void doDependDescendants(DBFolder folder) {
        if (folder.getObject() == null) {
            return;
        }
        GenerateDepFolders generate = new GenerateDepFolders(this._application.getDAOFactory());
        if (!generate.prepare(folder, folder, null)) {
            return;
        }
        DBFolderDlgDepend dlg = new DBFolderDlgDepend(SwingUtilities.getWindowAncestor(this), this._application.getDAOFactory());
        dlg.setTitle("Descendants - " + this._application.getTitle());
        dlg.setSelect(folder, generate.getDepends(true), this._application.getDBUser());
        dlg.setModal(true);
        dlg.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(this));
        dlg.setVisible(true);
    }

    public void doDependAncestors(DBFolder folder) {
        if (folder.getObject() == null) {
            return;
        }
        GenerateDepFolders generate = new GenerateDepFolders(this._application.getDAOFactory());
        generate.setDirection(Generate.Direction.UP);
        if (!generate.prepare(folder, folder, null)) {
            return;
        }
        DBFolderDlgDepend dlg = new DBFolderDlgDepend(SwingUtilities.getWindowAncestor(this), this._application.getDAOFactory());
        if (this._application.isDebugMode()) {
            dlg.setDebugMode(true);
        }
        dlg.setTitle("Ancestors - " + this._application.getTitle());
        dlg.setSelect(folder, generate.getDepends(true), this._application.getDBUser());
        dlg.setModal(true);
        dlg.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(this));
        dlg.setVisible(true);
    }
}

