/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.admin.others;

import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.table.ItemsTablePanel;
import com.dassault.cecilia.db.DBSession;
import com.dassault.cecilia.db.dao.DAOSession;
import com.dassault.cecilia.main.admin.ResMsgAdmin;
import com.dassault.cecilia.main.admin.others.SessionTableModel;
import java.awt.Component;
import java.awt.Container;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.TimerTask;
import javax.swing.Box;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class SessionsPanel
extends ItemsTablePanel<DBSession> {
    DateFormat _expireDataFormat = SimpleDateFormat.getDateTimeInstance();
    CAppl _application;
    DAOSession _daoSession;

    public SessionsPanel(CAppl appl, SessionTableModel model) {
        super(appl.getTopWindow(), model, false);
        this._application = appl;
        model.setDebugMode(this._application.isDebugMode());
        this._daoSession = appl.getDAOFactory().createSessionDAO();
        this.initialise();
    }

    @Override
    protected Collection<DBSession> findAll() {
        return this._daoSession.findAll();
    }

    @Override
    protected void initialise() {
        super.initialise();
        TableColumn column = null;
        block6: for (int i = 0; i < this._tableModel.getColumnCount(); ++i) {
            column = this._ctrlTable.getColumnModel().getColumn(i);
            switch (i) {
                case 0: {
                    column.setPreferredWidth(200);
                    continue block6;
                }
                case 1: {
                    column.setPreferredWidth(100);
                    continue block6;
                }
                case 2: {
                    column.setPreferredWidth(100);
                    continue block6;
                }
                case 3: {
                    column.setPreferredWidth(20);
                }
            }
        }
        this._ctrlTable.getSelectionModel().setSelectionMode(2);
        this._ctrlTable.setDefaultRenderer(Date.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.setText(SessionsPanel.this._expireDataFormat.format((Date)value));
                this.setHorizontalAlignment(0);
                return this;
            }
        });
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this._ctrlTable.getModel());
        this._ctrlTable.setRowSorter(sorter);
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
        sortKeys.add(new RowSorter.SortKey(2, SortOrder.ASCENDING));
        sorter.setSortKeys(sortKeys);
        this._application.addShedulerTask(new TimerTask(){

            @Override
            public void run() {
                SessionsPanel.this.refresh();
            }
        }, 5000L, 30000L);
    }

    @Override
    protected void createToolBarActions(Container toolbar) {
        toolbar.add(this._ctrlRefresh.createButton(CeciliaAction.BorderStyle.LIGHT));
        toolbar.add(Box.createGlue());
        toolbar.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        toolbar.add(this._ctrlDel.createButton(CeciliaAction.BorderStyle.LIGHT));
    }

    @Override
    protected JPopupMenu createMenuActions(JPopupMenu popupList) {
        popupList.add(this._ctrlRefresh);
        popupList.addSeparator();
        popupList.add(this._ctrlDel);
        return popupList;
    }

    @Override
    protected void refreshCtrl() {
        super.refreshCtrl();
        boolean isEnabled = this.isEnabled();
        if (isEnabled) {
            int nbr = this._ctrlTable.getSelectedRowCount();
            if (nbr <= 0) {
                isEnabled = false;
            } else {
                int[] viewRows = this._ctrlTable.getSelectedRows();
                for (int i = 0; isEnabled && i < viewRows.length; ++i) {
                    int modelRow = this._ctrlTable.convertRowIndexToModel(viewRows[i]);
                    if (!((DBSession)this._tableModel.getItem(modelRow)).isActive()) continue;
                    isEnabled = false;
                }
            }
        }
        this._ctrlDel.setEnabled(isEnabled);
    }

    @Override
    protected void addData(int viewRow) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void delData(int[] viewRows) {
        int nbrDel = 0;
        for (int i = 0; i < viewRows.length; ++i) {
            int modelRow = this._ctrlTable.convertRowIndexToModel(viewRows[i]);
            if (!this._daoSession.delete((DBSession)this._tableModel.getItem(modelRow))) continue;
            ++nbrDel;
        }
        if (nbrDel != viewRows.length) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlTable), ResMsgAdmin.getString("MSG_SES_ERR_DELETE"), this._application.getTitle(), 0);
        }
        this.refresh();
        this._ctrlTable.setRowSelectionInterval(0, 0);
    }
}

