/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.admin.patchs;

import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.action.CThread;
import com.dassault.cecilia.core.cecilia.error.GeneralError;
import com.dassault.cecilia.core.cecilia.folder.gui.DBFolderDlgDisplayError;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.main.admin.ResMsgAdmin;
import com.dassault.cecilia.main.admin.patchs.CorrectorLocalFolder;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;

class CorrectionLocalFolder
extends CThread {
    CAppl _appl;
    List<DBFolder> _selFolders;

    public CorrectionLocalFolder(CAppl appl, Component c, List<DBFolder> selFolders) {
        super(c);
        this._appl = appl;
        this._selFolders = selFolders;
    }

    @Override
    protected void firstDo() {
        DAOFolder daoFolder = this._appl.getDAOFactory().createFolderDAO();
        ArrayList msgs = new ArrayList();
        for (DBFolder dbFolder : this._selFolders) {
            short correctFF = CorrectorLocalFolder.verifyFlagFamily(dbFolder, dbFolder.getParent());
            if (correctFF == -2) {
                msgs.add(new GeneralError<DBFolder>(dbFolder, "Impossible de d\u00e9finir une valeur corrective pour le FlagFamily"));
                continue;
            }
            if (correctFF == -1) continue;
            dbFolder.setFamilyFlag(correctFF);
            if (daoFolder.update(dbFolder)) continue;
            msgs.add(new GeneralError<DBFolder>(dbFolder, "La mise \u00e0 jour n'a pas pu se faire au sein de la base de donn\u00e9es"));
        }
        if (!msgs.isEmpty()) {
            Window win = JOptionCecilia.getWindowOf(this.getSource());
            DBFolderDlgDisplayError dlg = new DBFolderDlgDisplayError(win);
            dlg.setTitle(ResMsgAdmin.getString("PATCH_LOCAL_FOLDER_TITLE"));
            dlg.setErrors(msgs);
            dlg.setLocationRelativeTo(win);
            dlg.setVisible(true);
        }
    }
}

