/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.admin.patchs;

import com.dassault.cecilia.core.cecilia.action.CThread;
import com.dassault.cecilia.core.cecilia.error.GeneralError;
import com.dassault.cecilia.core.cecilia.folder.gui.DBFolderDlgDisplayError;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.main.admin.CApplAdmin;
import com.dassault.cecilia.main.admin.ResMsgAdmin;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

class CorrectionObjects
extends CThread {
    private static Logger _LOG = Logger.getLogger(CorrectionObjects.class.getPackage().getName());
    CApplAdmin _appl;
    List<DBFolder> _selFolders;
    Set<DBFolder> _rewriteFolders;

    public CorrectionObjects(CApplAdmin appl, Component c, List<DBFolder> selFolders, Set<DBFolder> rewriteFolders) {
        super(c);
        this._appl = appl;
        this._selFolders = selFolders;
        this._rewriteFolders = rewriteFolders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToDAO(DBWrap dbWrap, CECFactory cecFactory, List<GeneralError<DBFolder>> msgs) {
        DBFolder dbFolder = dbWrap.getDBFolder();
        boolean freeze = dbFolder.isFreeze();
        if (freeze) {
            cecFactory.createObjectDAO().setFreeze(dbFolder.getObject(), false);
        }
        try {
            if (!dbWrap.writeToDAO(cecFactory, null)) {
                msgs.add(new GeneralError<DBFolder>(dbFolder, "Erreur lors de l'ecriture dans la base de donnee"));
                _LOG.severe("Erreur lors de l'ecriture dans la base de donnee: " + dbFolder.getRefPath());
            }
        }
        catch (Exception e) {
            msgs.add(new GeneralError<DBFolder>(dbFolder, "Exception lors de l'ecriture dans la base de donnee"));
            _LOG.log(Level.WARNING, "Exception lors de l'ecriture dans la base de donnee: " + dbFolder.getRefPath(), e);
        }
        finally {
            if (freeze) {
                cecFactory.createObjectDAO().setFreeze(dbFolder.getObject(), true);
            }
        }
    }

    @Override
    protected void firstDo() {
        CECFactory cecFactory = this._appl.getDAOFactory();
        DAOFolder daoFolder = cecFactory.createFolderDAO();
        ArrayList<GeneralError<DBFolder>> msgs = new ArrayList<GeneralError<DBFolder>>();
        for (DBFolder dbFolder : this._selFolders) {
            DBWrap dbWrap = cecFactory.findOrCreateWrap(dbFolder);
            if (dbWrap == null) {
                msgs.add(new GeneralError<DBFolder>(dbFolder, "Unreadeable object"));
                _LOG.severe("Unreadeable object: " + dbFolder.getRefPath());
                continue;
            }
            if (this._rewriteFolders.contains(dbFolder)) {
                this.writeToDAO(dbWrap, cecFactory, msgs);
                continue;
            }
            Collection<DBRelation> dbRelations = dbWrap.getUseRelations();
            dbFolder.setRelations(dbRelations);
            if (daoFolder.update(dbFolder)) continue;
            msgs.add(new GeneralError<DBFolder>(dbFolder, "La mise \u00e0 jour n'a pas pu se faire au sein de la base de donn\u00e9es"));
            _LOG.severe("La mise \u00e0 jour n'a pas pu se faire au sein de la base de donn\u00e9es: " + dbFolder.getRefPath());
        }
        if (!msgs.isEmpty()) {
            Window win = JOptionCecilia.getWindowOf(this.getSource());
            DBFolderDlgDisplayError dlg = new DBFolderDlgDisplayError(win);
            dlg.setTitle(ResMsgAdmin.getString("PATCH_VERIFYOBJECT_TITLE"));
            dlg.setErrors(msgs);
            dlg.setLocationRelativeTo(win);
            dlg.setVisible(true);
        }
    }
}

