/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.admin.patchs;

import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.action.CThread;
import com.dassault.cecilia.core.cecilia.error.GeneralError;
import com.dassault.cecilia.core.cecilia.folder.gui.DBFolderDlgDisplayError;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.general.log.DBLogsWrap;
import com.dassault.cecilia.main.admin.ResMsgAdmin;
import com.dassault.cecilia.main.admin.patchs.ReplayLimitedMigrationThread;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class CorrectorSpecficLinkFRB
extends CThread {
    private static Logger _LOG = Logger.getLogger(CorrectorSpecficLinkFRB.class.getPackage().getName());
    private static final String KEY_TREE_LINK = "<EVENTMODELID>";
    private static final int KEY_TREE_LINK_LENGTH = "<EVENTMODELID>".length();
    private static final String KEY_MBSA_LAW = "<law ";
    private static final String KEY_MBSA_SYNC = "<synchro ";
    private static final Pattern PATTERN_FRB = Pattern.compile("[;\\\\]");
    private static final Pattern PATTERN_VALUE = Pattern.compile("value=\"([^\"]+)\"");
    private static final Pattern PATTERN_LAW = Pattern.compile("law=\"([^\"]+)\"");
    CAppl _appl;

    public CorrectorSpecficLinkFRB(CAppl appl, Component c) {
        super(c);
        this._appl = appl;
    }

    @Override
    protected void firstDo() {
        DAOFactory daoFactory = this._appl.getDAOFactory();
        if (!CorrectorSpecficLinkFRB.existBadFRBName_rec(daoFactory.createFolderDAO().getRootID("LAW_MODELS"), daoFactory)) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this.getSource()), ResMsgAdmin.getString("PATCH_NO_PROBLEM"), ResMsgAdmin.getString("PATCH_LINK_OLD_FRB_TITLE"), 1);
            return;
        }
        LinkedHashMap<DBFolder, List<String>> errorFolders = new LinkedHashMap<DBFolder, List<String>>();
        this.findBadPaths_rec(daoFactory.createFolderDAO().getRootID("PROJECTS"), daoFactory, errorFolders);
        this.findBadPaths_rec(daoFactory.createFolderDAO().getRootID("EQUIPMENT_FAMILIES"), daoFactory, errorFolders);
        this.findBadPaths_rec(daoFactory.createFolderDAO().getRootID("COMPONENT_FAMILIES"), daoFactory, errorFolders);
        if (errorFolders.isEmpty()) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this.getSource()), ResMsgAdmin.getString("PATCH_NO_PROBLEM"), ResMsgAdmin.getString("PATCH_LINK_OLD_FRB_TITLE"), 1);
            return;
        }
        Window win = JOptionCecilia.getWindowOf(this.getSource());
        final DlgCorrectorSpecficLinkFRB dlg = new DlgCorrectorSpecficLinkFRB(win, errorFolders);
        dlg.setLocationRelativeTo(win);
        dlg.setModal(true);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                dlg.setVisible(true);
                if (dlg.getResult()) {
                    ReplayLimitedMigrationThread cmd = new ReplayLimitedMigrationThread(CorrectorSpecficLinkFRB.this._appl, CorrectorSpecficLinkFRB.this.getSource(), dlg.getFoldersToBeCorrected());
                    cmd.setTitle(ResMsgAdmin.getString("PATCH_LINK_OLD_FRB_TITLE"));
                    cmd.realiseDo();
                }
            }
        });
    }

    private static boolean existBadFRBName_rec(DBFolder dbFolder, DAOFactory daoFactory) {
        String strName = dbFolder.getName();
        if (PATTERN_FRB.matcher(strName).find()) {
            return true;
        }
        if (dbFolder.isVersion()) {
            return false;
        }
        List<DBFolder> dbChildren = dbFolder.getChildren();
        if (dbChildren == null) {
            dbChildren = daoFactory.createFolderDAO().findChildren(dbFolder);
        }
        if (dbChildren == null) {
            return false;
        }
        for (DBFolder dbChild : dbChildren) {
            if (!CorrectorSpecficLinkFRB.existBadFRBName_rec(dbChild, daoFactory)) continue;
            return true;
        }
        return false;
    }

    private static boolean findBadPaths_withLogError(DBFolder dbFolder, DAOFactory daoFactory) {
        if (dbFolder.getObject() == null) {
            return false;
        }
        DBLogsWrap dbWrap = new DBLogsWrap(dbFolder){

            @Override
            public Collection<DBRelation> getUseRelations() {
                return Collections.EMPTY_LIST;
            }
        };
        if (!dbWrap.readLogs(daoFactory)) {
            return true;
        }
        return dbWrap.getLogs().withLogs(DBLogs.DBLevel.WARNING);
    }

    private static void findBadPaths_generic(DBFolder dbFolder, DAOFactory daoFactory, Map<DBFolder, List<String>> errorFolders, String oldNature, Function<String, String> fctFind) {
        DBObjModel dbModel = dbFolder.getObject().getModel(oldNature);
        if (dbModel == null) {
            return;
        }
        InputStream istream = daoFactory.createObjModelDAO().getBinaryStream(dbModel);
        if (istream == null) {
            _LOG.severe("Pas de stream accessible pour '" + dbFolder.getRefPath() + "'");
            return;
        }
        InflaterInputStream def = new InflaterInputStream(istream, new Inflater());
        BufferedReader reader = new BufferedReader(new InputStreamReader(def));
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                String link = fctFind.apply(line);
                if (link == null || !PATTERN_FRB.matcher(link).find()) continue;
                List<String> links = errorFolders.get(dbFolder);
                if (links == null) {
                    links = new ArrayList<String>();
                    errorFolders.put(dbFolder, links);
                }
                if (links.contains(link)) continue;
                links.add(link);
            }
        }
        catch (IOException ioe) {
            _LOG.severe("IOException durant la lecture du stream  de '" + dbFolder.getRefPath() + "'");
            return;
        }
    }

    private void findBadPaths_rec(DBFolder dbFolder, DAOFactory daoFactory, Map<DBFolder, List<String>> errorFolders) {
        if (dbFolder.getObject() != null && dbFolder.isVersion() && CorrectorSpecficLinkFRB.findBadPaths_withLogError(dbFolder, daoFactory)) {
            switch (dbFolder.getFamily()) {
                case PROJECT: {
                    if (dbFolder.getFamilyFlag() == 2) {
                        CorrectorSpecficLinkFRB.findBadPaths_generic(dbFolder, daoFactory, errorFolders, "tree.def.51", line -> {
                            if (!line.startsWith(KEY_TREE_LINK)) {
                                return null;
                            }
                            return line.substring(KEY_TREE_LINK_LENGTH);
                        });
                        break;
                    }
                    if (dbFolder.getFamilyFlag() != 1) break;
                    CorrectorSpecficLinkFRB.findBadPaths_generic(dbFolder, daoFactory, errorFolders, "system.local.51", line -> {
                        if (!line.startsWith(KEY_MBSA_SYNC)) {
                            return null;
                        }
                        Matcher match = PATTERN_LAW.matcher((CharSequence)line);
                        if (!match.find()) {
                            return null;
                        }
                        return match.group(1);
                    });
                    CorrectorSpecficLinkFRB.findBadPaths_generic(dbFolder, daoFactory, errorFolders, "system.law", line -> {
                        if (!line.startsWith(KEY_MBSA_LAW)) {
                            return null;
                        }
                        Matcher match = PATTERN_VALUE.matcher((CharSequence)line);
                        if (!match.find()) {
                            return null;
                        }
                        return match.group(1);
                    });
                    break;
                }
                case EQUIPMENT: {
                    CorrectorSpecficLinkFRB.findBadPaths_generic(dbFolder, daoFactory, errorFolders, "equipment.51", line -> {
                        if (!line.startsWith(KEY_MBSA_SYNC)) {
                            return null;
                        }
                        Matcher match = PATTERN_LAW.matcher((CharSequence)line);
                        if (!match.find()) {
                            return null;
                        }
                        return match.group(1);
                    });
                    break;
                }
                case COMPONENT: {
                    CorrectorSpecficLinkFRB.findBadPaths_generic(dbFolder, daoFactory, errorFolders, "component.51", line -> {
                        if (!line.startsWith(KEY_MBSA_LAW)) {
                            return null;
                        }
                        Matcher match = PATTERN_VALUE.matcher((CharSequence)line);
                        if (!match.find()) {
                            return null;
                        }
                        return match.group(1);
                    });
                }
            }
        }
        if (dbFolder.isVersion()) {
            return;
        }
        List<DBFolder> dbChildren = dbFolder.getChildren();
        if (dbChildren == null) {
            dbChildren = daoFactory.createFolderDAO().findChildren(dbFolder);
        }
        if (dbChildren == null) {
            return;
        }
        for (DBFolder dbChild : dbChildren) {
            this.findBadPaths_rec(dbChild, daoFactory, errorFolders);
        }
    }

    static class DlgCorrectorSpecficLinkFRB
    extends DBFolderDlgDisplayError {
        boolean _bSelectedOnly = true;
        ArrayList<DBFolder> _errorFolders;

        public DlgCorrectorSpecficLinkFRB(Window owner, Map<DBFolder, List<String>> errorFolders) {
            super(owner);
            this._errorFolders = new ArrayList<DBFolder>(errorFolders.keySet());
            Collections.sort(this._errorFolders, DBFolder.getComparatorWithFamily());
            int size = this._errorFolders.size();
            ArrayList msgs = new ArrayList(size + 1);
            for (int i = 0; i < size; ++i) {
                DBFolder errFolder = this._errorFolders.get(i);
                StringBuilder sb = new StringBuilder();
                List<String> srcPaths = errorFolders.get(errFolder);
                for (int j = 0; j < srcPaths.size(); ++j) {
                    if (j > 0) {
                        sb.append("\n");
                    }
                    sb.append("- ").append(srcPaths.get(j));
                }
                msgs.add(new GeneralError<DBFolder>(errFolder, sb.toString()));
            }
            this.setErrors(msgs);
            this.setTitle(ResMsgAdmin.getString("PATCH_LINK_OLD_FRB_TITLE"));
        }

        @Override
        protected Component createNorthComponent() {
            JLabel explain = new JLabel(ResMsgAdmin.getString("PATCH_LINK_OLD_FRB_LABEL"));
            explain.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
            return explain;
        }

        @Override
        protected Component createSouthComponent() {
            JComponent result = this.createButPanel();
            this._ctrlOK.setText(ResMsgAdmin.getString("PATCH_BUTTON"));
            return result;
        }

        @Override
        protected boolean verifyParameters() {
            int selectedSize = this.getSelectedItems().size();
            if (selectedSize == 0) {
                this._bSelectedOnly = false;
                return true;
            }
            if (selectedSize < this._errorFolders.size()) {
                int result = JOptionPane.showConfirmDialog(this, ResMsgAdmin.getString("PATCH_CONFIRM"), this.getTitle(), 1);
                if (result == 2) {
                    return false;
                }
                this._bSelectedOnly = result == 0;
            }
            return true;
        }

        public List<DBFolder> getFoldersToBeCorrected() {
            if (this._bSelectedOnly) {
                return this.getSelectedItems();
            }
            return this._errorFolders;
        }
    }
}

