/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.admin.patchs;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.folder.FolderRenderer;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.table.JTableTransfertHandler;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.main.admin.ResMsgAdmin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class DBFoldersDisplayDlg
extends JDialogCecilia {
    static DateFormat _frmDate = SimpleDateFormat.getDateTimeInstance(3, 3);
    List<DBFolder> _dbFolders;
    JTable _ctrlTable;
    boolean _bSelectedOnly = true;

    public DBFoldersDisplayDlg(Window owner) {
        super(owner);
        this.create();
    }

    private void create() {
        this.init();
        DBFoldersTableModel model = new DBFoldersTableModel();
        this._ctrlTable = new JTable(model);
        this._ctrlTable.setSelectionMode(2);
        TableColumn column = null;
        block6: for (int i = 0; i < model.getColumnCount(); ++i) {
            column = this._ctrlTable.getColumnModel().getColumn(i);
            switch (i) {
                case 0: {
                    column.setPreferredWidth(300);
                    continue block6;
                }
                case 1: {
                    column.setPreferredWidth(30);
                    continue block6;
                }
                case 2: {
                    column.setPreferredWidth(100);
                    continue block6;
                }
                case 3: {
                    column.setPreferredWidth(100);
                }
            }
        }
        this._ctrlTable.setPreferredScrollableViewportSize(new Dimension(700, 200));
        this._ctrlTable.setTransferHandler(new JTableTransfertHandler());
        this._ctrlTable.setRowHeight(20);
        this._ctrlTable.setDefaultRenderer(DBFolder.class, new FolderRenderer().setDisplayPath(true));
        this._ctrlTable.setDefaultRenderer(Date.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                Date val = (Date)value;
                this.setText(_frmDate.format(val));
                return this;
            }
        });
        JScrollPane scroll = new JScrollPane(this._ctrlTable);
        scroll.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().setLayout(new BorderLayout());
        Component north = this.createNorthComponent();
        if (north != null) {
            this.getContentPane().add(north, "North");
        }
        this.getContentPane().add((Component)scroll, "Center");
        Component south = this.createSouthComponent();
        if (south != null) {
            this.getContentPane().add(south, "South");
        }
        this.pack();
    }

    protected Component createNorthComponent() {
        return null;
    }

    protected Component createSouthComponent() {
        JComponent result = this.createButPanel();
        this._ctrlOK.setText(ResMsgAdmin.getString("PATCH_BUTTON"));
        return result;
    }

    public DBFoldersDisplayDlg setFolders(List<DBFolder> dbFolders) {
        this._dbFolders = dbFolders;
        return this;
    }

    public List<DBFolder> getSelectedItems() {
        int[] idxs = this._ctrlTable.getSelectedRows();
        if (idxs == null || idxs.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<DBFolder> result = new ArrayList<DBFolder>(idxs.length);
        for (int i = 0; i < idxs.length; ++i) {
            int idxDoc = this._ctrlTable.convertRowIndexToModel(idxs[i]);
            result.add(this._dbFolders.get(idxDoc));
        }
        return result;
    }

    @Override
    protected boolean verifyParameters() {
        int selectedSize = this.getSelectedItems().size();
        if (selectedSize == 0) {
            this._bSelectedOnly = false;
            return true;
        }
        if (selectedSize < this._dbFolders.size()) {
            int result = JOptionPane.showConfirmDialog(this, ResMsgAdmin.getString("PATCH_CONFIRM"), this.getTitle(), 1);
            if (result == 2) {
                return false;
            }
            this._bSelectedOnly = result == 0;
        }
        return true;
    }

    public List<DBFolder> getFoldersToBeCorrected() {
        if (this._bSelectedOnly) {
            return this.getSelectedItems();
        }
        return this._dbFolders;
    }

    class DBFoldersTableModel
    implements TableModel {
        ArrayList<TableModelListener> _listener = new ArrayList();

        DBFoldersTableModel() {
        }

        @Override
        public int getRowCount() {
            if (DBFoldersDisplayDlg.this._dbFolders == null) {
                return 0;
            }
            return DBFoldersDisplayDlg.this._dbFolders.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ResMsgVoc.getString("VOC_PATH");
                }
                case 1: {
                    return ResMsgVoc.getString("VOC_FREEZE");
                }
                case 2: {
                    return ResMsgVoc.getString("VOC_DATE_CREATE");
                }
                case 3: {
                    return ResMsgVoc.getString("VOC_DATE_MODIF");
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return DBFolder.class;
                }
                case 1: {
                    return Boolean.class;
                }
                case 2: {
                    return Date.class;
                }
                case 3: {
                    return Date.class;
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return DBFoldersDisplayDlg.this._dbFolders.get(rowIndex);
                }
                case 1: {
                    return DBFoldersDisplayDlg.this._dbFolders.get(rowIndex).getObject().isFreeze();
                }
                case 2: {
                    return DBFoldersDisplayDlg.this._dbFolders.get(rowIndex).getDateCreate();
                }
                case 3: {
                    return DBFoldersDisplayDlg.this._dbFolders.get(rowIndex).getDateModify();
                }
            }
            return null;
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            if (!this._listener.contains(l)) {
                this._listener.add(l);
            }
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this._listener.remove(l);
        }
    }
}

