/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.admin.users;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.user.UserRenderer;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.other.ValueTextField;
import com.dassault.cecilia.db.DBGroup;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.IUser;
import com.dassault.cecilia.main.admin.ResMsgAdmin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class GroupsEditDlg
extends JDialogCecilia {
    private JLabel jLabelNom = new JLabel(ResMsgVoc.getString("VOC_NAME"));
    private JLabel jLabelDescription = new JLabel(ResMsgVoc.getString("VOC_DESCRIPTION"));
    private ValueTextField jTextFieldNom = new ValueTextField("");
    private ValueTextField jTextFieldDescription = new ValueTextField("");
    private JPanel jPanelIn = new JPanel();
    private JPanel jPanelUsersOfGroup = new JPanel();
    private JList jListUsersInGroup = new JList();
    private JList jListUsersNotInGroup = new JList();
    private JButton jButtonSetUserIntoGroup = new JButton(ResMsgAdmin.getString("LBL_ARROW_LEFT"));
    private JButton jButtonSetUserOutOfGroup = new JButton(ResMsgAdmin.getString("LBL_ARROW_RIGHT"));
    private JLabel jLabelMembresOfGroup = new JLabel(ResMsgAdmin.getString("LBL_GRP_USERS_IN"));
    private JLabel jLabelNotMembresOfGroup = new JLabel(ResMsgAdmin.getString("LBL_GRP_USERS_OUT"));
    ArrayList<DBGroup> _groups;
    ArrayList<DBUser> _users;
    Vector<DBUser> _usersIn = null;
    Vector<DBUser> _usersOut = null;
    Vector<DBUser> _groupThrewUsers = null;
    ArrayList<DBGroup> _groupsSelected;
    Collection<DBGroup> _groupsResult;

    public GroupsEditDlg(Window owner) {
        super(owner, true);
        this.setTitle("Edition d'un groupe d'utilisateurs");
        this.init();
        this.makePanel();
        this.groupsActionListeners();
        this.setLayout(new BorderLayout());
        this.add((Component)this.jPanelIn, "Center");
        this.add((Component)this.createButPanel(), "South");
        this.pack();
        this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(owner));
    }

    public void setUsersAndGroups(Collection<DBUser> users, Collection<DBGroup> groups) {
        this._groups = new ArrayList<DBGroup>(groups);
        Collections.sort(this._groups, DBGroup.getComparatorName());
        this._users = new ArrayList<DBUser>(users);
        Collections.sort(this._users, DBUser.getComparatorLogin());
    }

    public void setSelected(Collection<DBGroup> groups) {
        this._groupsSelected = new ArrayList<DBGroup>(groups);
        switch (this._groupsSelected.size()) {
            case 0: {
                this.setTitle("Cr\u00e9ation d'un groupe d'utilisateurs");
                this._usersIn = new Vector();
                this._usersOut = new Vector<DBUser>(this._users);
                this.jListUsersInGroup.setListData(this._usersIn);
                this.jListUsersNotInGroup.setListData(this._usersOut);
                break;
            }
            case 1: {
                this.setTitle("Modification d'un groupe d'utilisateurs");
                DBGroup grp = this._groupsSelected.get(0);
                this.jTextFieldNom.setText(grp.getName());
                if (grp.isAdmin()) {
                    this.jTextFieldNom.setEditable(false);
                    this.jTextFieldNom.setEnabled(false);
                }
                this.jTextFieldDescription.setText(grp.getDescription());
                this._usersIn = new Vector();
                this._usersOut = new Vector<DBUser>(this._users);
                for (IUser guser : grp.getUsers()) {
                    Iterator<DBUser> iUser = this._usersOut.iterator();
                    while (iUser.hasNext()) {
                        DBUser user = iUser.next();
                        if (!user.equals(guser)) continue;
                        this.addInAlphabeticOrder(this._usersIn, user);
                        iUser.remove();
                    }
                }
                this.jListUsersInGroup.setListData(this._usersIn);
                this.jListUsersNotInGroup.setListData(this._usersOut);
                break;
            }
            default: {
                this.setTitle("Modification des utilisateurs d'un ensemble de groupe");
            }
        }
    }

    public Collection<DBGroup> getSelected() {
        return this._groupsResult;
    }

    @Override
    protected boolean verifyParameters() {
        ArrayList<DBGroup> groups = new ArrayList<DBGroup>();
        switch (this._groupsSelected.size()) {
            case 0: {
                String name = this.jTextFieldNom.getText().trim();
                if (name.length() == 0) {
                    return false;
                }
                for (DBGroup dbGroup : this._groups) {
                    if (!name.equals(dbGroup.getName())) continue;
                    return false;
                }
                DBGroup grp = new DBGroup();
                grp.setName(name);
                grp.setDescription(this.jTextFieldDescription.getText());
                LinkedHashSet<IUser> users = new LinkedHashSet<IUser>(this._usersIn);
                grp.setUsers(users);
                groups.add(grp);
                break;
            }
            case 1: {
                DBGroup grp = this._groupsSelected.get(0);
                if (!grp.isAdmin()) {
                    String name = this.jTextFieldNom.getText().trim();
                    if (name.length() == 0) {
                        return false;
                    }
                    for (DBGroup dbGroup : this._groups) {
                        if (dbGroup.equals(grp) || !name.equals(dbGroup.getName())) continue;
                        return false;
                    }
                    grp.setName(name);
                }
                grp.setDescription(this.jTextFieldDescription.getText());
                LinkedHashSet<IUser> users = new LinkedHashSet<IUser>(this._usersIn);
                grp.setUsers(users);
                groups.add(grp);
                break;
            }
            default: {
                return false;
            }
        }
        this._groupsResult = groups;
        return true;
    }

    private boolean isUserEnable(DBUser usr) {
        return this._groupsSelected.size() != 1 || usr.getDefaultGroup().getID() != this._groupsSelected.get(0).getID();
    }

    void makePanel() {
        this.jTextFieldNom.setDisabledTextColor(Color.BLACK);
        this.jTextFieldDescription.setDisabledTextColor(Color.BLACK);
        this.jListUsersInGroup.setOpaque(false);
        this.jPanelIn.setLayout(new GridBagLayout());
        this.jPanelIn.add((Component)this.jLabelNom, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanelIn.add((Component)this.jLabelDescription, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanelIn.add((Component)this.jTextFieldNom, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 12, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanelIn.add((Component)this.jTextFieldDescription, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 12, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.jTextFieldNom.setStringFormat(248);
        this.jTextFieldDescription.setStringFormat(1023);
        this.jTextFieldNom.setEnabled(true);
        this.jTextFieldNom.setEditable(true);
        this.jTextFieldDescription.setEnabled(true);
        this.jTextFieldDescription.setEditable(true);
        this.jPanelUsersOfGroup.setLayout(new GridBagLayout());
        this.jListUsersInGroup.setFixedCellWidth(100);
        this.jListUsersNotInGroup.setFixedCellWidth(100);
        this.jListUsersInGroup.setFixedCellHeight(15);
        this.jListUsersNotInGroup.setFixedCellHeight(15);
        this.jListUsersInGroup.setCellRenderer(new UserRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                boolean enabled = GroupsEditDlg.this.isUserEnable((DBUser)value);
                super.getListCellRendererComponent(list, value, index, enabled && isSelected, cellHasFocus);
                this.setEnabled(enabled);
                return this;
            }
        }.setWithIcon(false));
        this.jListUsersNotInGroup.setCellRenderer(new UserRenderer().setWithIcon(false));
        this.jPanelUsersOfGroup.add((Component)this.jLabelMembresOfGroup, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanelUsersOfGroup.add((Component)new JScrollPane(this.jListUsersInGroup), new GridBagConstraints(1, 3, 4, 4, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanelUsersOfGroup.add((Component)this.jButtonSetUserIntoGroup, new GridBagConstraints(5, 3, 1, 1, 0.0, 1.0, 15, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanelUsersOfGroup.add((Component)this.jButtonSetUserOutOfGroup, new GridBagConstraints(5, 4, 1, 1, 0.0, 1.0, 11, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanelUsersOfGroup.add((Component)this.jLabelNotMembresOfGroup, new GridBagConstraints(6, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanelUsersOfGroup.add((Component)new JScrollPane(this.jListUsersNotInGroup), new GridBagConstraints(6, 3, 4, 4, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanelIn.add((Component)new JScrollPane(this.jPanelUsersOfGroup), new GridBagConstraints(1, 6, 11, 7, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanelIn.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jButtonSetUserIntoGroup.setEnabled(false);
        this.jButtonSetUserOutOfGroup.setEnabled(false);
        this.jListUsersInGroup.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                GroupsEditDlg.this.setUserOutOfGroup();
            }
        });
        this.jListUsersNotInGroup.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                GroupsEditDlg.this.setUserIntoGroup();
            }
        });
    }

    protected void setEnabledAction(String keyMap, boolean enabled) {
        this.getRootPane().getActionMap().get(keyMap).setEnabled(enabled);
    }

    private int addInAlphabeticOrder(Vector<DBUser> list, DBUser user) {
        if (list.size() != 0) {
            for (int i = 0; i < list.size(); ++i) {
                if (user.getLogin().compareTo(list.elementAt(i).getLogin()) >= 0) continue;
                list.insertElementAt(user, i);
                return i;
            }
            list.addElement(user);
            return -1;
        }
        list.addElement(user);
        return 0;
    }

    private void setUserIntoGroup() {
        int j;
        int[] i = this.jListUsersNotInGroup.getSelectedIndices();
        for (j = 0; j < i.length; ++j) {
            this.addInAlphabeticOrder(this._usersIn, this._usersOut.elementAt(i[j]));
        }
        for (j = 0; j < this._usersIn.size(); ++j) {
            for (int k = 0; k < this._usersOut.size(); ++k) {
                if (this._usersIn.elementAt(j) != this._usersOut.elementAt(k)) continue;
                this._usersOut.removeElementAt(k);
            }
        }
        this.jListUsersInGroup.removeAll();
        this.jListUsersNotInGroup.removeAll();
        this.jListUsersInGroup.setListData(this._usersIn);
        this.jListUsersNotInGroup.setListData(this._usersOut);
    }

    private void setUserOutOfGroup() {
        int j;
        int[] sels = this.jListUsersInGroup.getSelectedIndices();
        for (j = 0; j < sels.length; ++j) {
            DBUser usr = this._usersIn.elementAt(sels[j]);
            if (!this.isUserEnable(usr)) continue;
            this.addInAlphabeticOrder(this._usersOut, usr);
        }
        this._groupThrewUsers = new Vector();
        for (j = 0; j < this._usersOut.size(); ++j) {
            for (int k = 0; k < this._usersIn.size(); ++k) {
                if (this._usersOut.elementAt(j) != this._usersIn.elementAt(k)) continue;
                this._groupThrewUsers.addElement(this._usersIn.elementAt(k));
                this._usersIn.removeElementAt(k);
            }
        }
        this.jListUsersInGroup.removeAll();
        this.jListUsersNotInGroup.removeAll();
        this.jListUsersInGroup.setListData(this._usersIn);
        this.jListUsersNotInGroup.setListData(this._usersOut);
    }

    private void groupsActionListeners() {
        this.jButtonSetUserIntoGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GroupsEditDlg.this.setUserIntoGroup();
            }
        });
        this.jButtonSetUserOutOfGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GroupsEditDlg.this.setUserOutOfGroup();
            }
        });
        this.jListUsersInGroup.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                boolean enabled = false;
                int[] sels = GroupsEditDlg.this.jListUsersInGroup.getSelectedIndices();
                for (int i = 0; i < sels.length && !enabled; ++i) {
                    if (GroupsEditDlg.this.isUserEnable(GroupsEditDlg.this._usersIn.elementAt(sels[i]))) {
                        enabled = true;
                        continue;
                    }
                    final int removeSel = sels[i];
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GroupsEditDlg.this.jListUsersInGroup.removeSelectionInterval(removeSel, removeSel);
                        }
                    });
                }
                GroupsEditDlg.this.jButtonSetUserOutOfGroup.setEnabled(enabled);
            }
        });
        this.jListUsersNotInGroup.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                GroupsEditDlg.this.jButtonSetUserIntoGroup.setEnabled(GroupsEditDlg.this.jListUsersNotInGroup.getSelectedIndex() != -1);
            }
        });
    }
}

