/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.admin.users;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.table.ItemsTablePanel;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.IGroup;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.main.admin.ResMsgAdmin;
import com.dassault.cecilia.main.admin.users.UsersEditDlg;
import com.dassault.cecilia.main.admin.users.UsersTableModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TimerTask;
import javax.swing.Box;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class UsersPanel
extends ItemsTablePanel<DBUser> {
    CeciliaAction _ctrlEdit;
    CeciliaAction _ctrlMasterAdmin;
    CAppl _application;
    DAOFactory _daoFactory;

    public UsersPanel(CAppl application, UsersTableModel model) {
        super(application.getTopWindow(), model, false);
        this._application = application;
        this._daoFactory = this._application.getDAOFactory();
        this._tableModel.setDebugMode(application.isDebugMode());
        this.initialise();
    }

    @Override
    protected Collection<DBUser> findAll() {
        return this._daoFactory.createUserDAO().findAll();
    }

    @Override
    protected void initialise() {
        this._ctrlEdit = new CeciliaAction(ResIcoCore.getImageIcon("BUT_EDIT"), ResMsgVoc.getString("VOC_EDIT"), ResMsgCore.getString("ACTION_EDIT_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (UsersPanel.this._ctrlTable.getSelectedRowCount() > 0) {
                    UsersPanel.this.refresh();
                    UsersPanel.this.editData(UsersPanel.this._ctrlTable.getSelectedRows());
                }
            }
        };
        this._ctrlMasterAdmin = new CeciliaAction(ResMsgAdmin.getString("LBL_MASTER_ADMIN")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (UsersPanel.this._ctrlTable.getSelectedRowCount() < 1) {
                    return;
                }
                int viewRow = UsersPanel.this._ctrlTable.getSelectedRow();
                int modelRow = UsersPanel.this._ctrlTable.convertRowIndexToModel(viewRow);
                DBUser dbUser = (DBUser)UsersPanel.this._tableModel.getItem(modelRow);
                if (!dbUser.isAdmin()) {
                    return;
                }
                if (dbUser.equals(UsersPanel.this._application.getDBUser())) {
                    return;
                }
                if (dbUser.isMasterAdmin()) {
                    dbUser.setFlags(dbUser.getFlags() & 0xFF7FFFFF);
                } else {
                    dbUser.setFlags(dbUser.getFlags() | 0x800000);
                }
                UsersPanel.this._application.getDAOFactory().createUserDAO().update(dbUser);
                UsersPanel.this.refresh();
            }
        }.setDesc(ResMsgAdmin.getString("LBL_MASTER_ADMIN_TTIP"));
        super.initialise();
        TableColumn column = null;
        block8: for (int i = 0; i < this._tableModel.getColumnCount(); ++i) {
            column = this._ctrlTable.getColumnModel().getColumn(i);
            switch (i) {
                case 0: {
                    column.setPreferredWidth(50);
                    continue block8;
                }
                case 1: {
                    column.setPreferredWidth(50);
                    continue block8;
                }
                case 2: {
                    column.setPreferredWidth(200);
                    continue block8;
                }
                case 3: {
                    column.setPreferredWidth(100);
                    continue block8;
                }
                case 4: {
                    column.setPreferredWidth(40);
                    continue block8;
                }
                case 5: {
                    column.setPreferredWidth(20);
                }
            }
        }
        if (this._application.isDebugMode()) {
            this._ctrlTable.setDefaultRenderer(Integer.class, new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    Integer val = (Integer)value;
                    this.setText(String.format("0x%1$08X", val));
                    this.setHorizontalAlignment(4);
                    return this;
                }
            });
        }
        this._ctrlTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                if (UsersPanel.this._ctrlTable.getSelectedRowCount() > 0) {
                    UsersPanel.this.refresh();
                    UsersPanel.this.editData(UsersPanel.this._ctrlTable.getSelectedRows());
                }
            }
        });
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this._ctrlTable.getModel());
        this._ctrlTable.setRowSorter(sorter);
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
        sortKeys.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
        sorter.setSortKeys(sortKeys);
        this._ctrlTable.setSelectionMode(2);
        this._application.addShedulerTask(new TimerTask(){

            @Override
            public void run() {
                UsersPanel.this.refresh();
            }
        }, 5000L, 60000L);
    }

    @Override
    protected void createToolBarActions(Container toolbar) {
        toolbar.add(this._ctrlRefresh.createButton(CeciliaAction.BorderStyle.LIGHT));
        toolbar.add(Box.createGlue());
        toolbar.add(this._ctrlAdd.createButton(CeciliaAction.BorderStyle.LIGHT));
        toolbar.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        toolbar.add(this._ctrlEdit.createButton(CeciliaAction.BorderStyle.LIGHT));
        toolbar.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        toolbar.add(this._ctrlDel.createButton(CeciliaAction.BorderStyle.LIGHT));
    }

    @Override
    protected JPopupMenu createMenuActions(JPopupMenu popupList) {
        popupList.add(this._ctrlRefresh);
        popupList.addSeparator();
        popupList.add(this._ctrlAdd);
        popupList.add(this._ctrlEdit);
        popupList.add(this._ctrlDel);
        if (this._application.getDBUser().isMasterAdmin()) {
            popupList.addSeparator();
            popupList.add(this._ctrlMasterAdmin);
        }
        return popupList;
    }

    @Override
    protected void addData(int viewRow) {
        Window win = SwingUtilities.getWindowAncestor(this._ctrlTable);
        UsersEditDlg dlg = new UsersEditDlg(win);
        dlg.setUsersAndGroups(this._daoFactory.createUserDAO().findAll(), this._daoFactory.createGroupDAO().findAll());
        dlg.setSelected(new ArrayList<DBUser>());
        dlg.setVisible(true);
        Collection<DBUser> results = dlg.getSelected();
        if (results != null) {
            int nbrCreate = 0;
            for (DBUser dbUser : results) {
                if (this._daoFactory.createUserDAO().create(dbUser) == null) continue;
                ++nbrCreate;
            }
            if (nbrCreate != results.size()) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlTable), ResMsgAdmin.getString("MSG_USR_ERR_INSERT"), this._application.getTitle(), 0);
            }
            this.refresh();
            this.fireChangeState();
        }
    }

    protected void editData(int[] viewRows) {
        if (viewRows.length == 0) {
            return;
        }
        ArrayList<DBUser> selecteds = new ArrayList<DBUser>(viewRows.length);
        HashMap<DBUser, LinkedHashSet<IGroup>> mapToOldGroups = new HashMap<DBUser, LinkedHashSet<IGroup>>();
        for (int i = 0; i < viewRows.length; ++i) {
            int modelRow = this._ctrlTable.convertRowIndexToModel(viewRows[i]);
            DBUser dbUser = (DBUser)this._tableModel.getItem(modelRow);
            selecteds.add(dbUser);
            mapToOldGroups.put(dbUser, new LinkedHashSet<IGroup>(dbUser.getGroups()));
        }
        Window win = SwingUtilities.getWindowAncestor(this._ctrlTable);
        UsersEditDlg dlg = new UsersEditDlg(win);
        dlg.setUsersAndGroups(this._daoFactory.createUserDAO().findAll(), this._daoFactory.createGroupDAO().findAll());
        dlg.setSelected(selecteds);
        dlg.setVisible(true);
        Collection<DBUser> results = dlg.getSelected();
        if (results != null) {
            int nbrUpdate = 0;
            for (DBUser dbUser : results) {
                if (this._daoFactory.createUserDAO().update(dbUser, (Set)mapToOldGroups.get(dbUser))) {
                    // empty if block
                }
                ++nbrUpdate;
            }
            if (nbrUpdate != results.size()) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlTable), ResMsgAdmin.getString("MSG_USR_ERR_UPDATE"), this._application.getTitle(), 0);
            }
            if (nbrUpdate > 0) {
                this._application.refreshDAOFolder(false);
            }
            this.refresh();
            this.fireChangeState();
        }
    }

    @Override
    protected void delData(int[] viewRows) {
        int nbrDel = 0;
        for (int i = 0; i < viewRows.length; ++i) {
            int modelRow = this._ctrlTable.convertRowIndexToModel(viewRows[i]);
            if (!this._daoFactory.createUserDAO().delete((DBUser)this._tableModel.getItem(modelRow))) continue;
            ++nbrDel;
        }
        if (nbrDel != viewRows.length) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlTable), ResMsgAdmin.getString("MSG_USR_ERR_DELETE"), this._application.getTitle(), 0);
        }
        this.refresh();
        this.fireChangeState();
    }

    @Override
    protected void refreshCtrl() {
        boolean isEnabled = this.isEnabled();
        int nbrSel = this._ctrlTable.getSelectedRowCount();
        boolean isMasterAdminSelect = false;
        boolean isAdminSelect = false;
        if (nbrSel > 0) {
            int[] viewRows = this._ctrlTable.getSelectedRows();
            for (int i = 0; i < viewRows.length && !isMasterAdminSelect; ++i) {
                int modelRow = this._ctrlTable.convertRowIndexToModel(viewRows[i]);
                DBUser dbUser = (DBUser)this._tableModel.getItem(modelRow);
                if (dbUser.isMasterAdmin()) {
                    isMasterAdminSelect = true;
                }
                if (!dbUser.isAdmin() || dbUser.equals(this._application.getDBUser())) continue;
                isAdminSelect = true;
            }
        }
        this._ctrlAdd.setEnabled(isEnabled);
        this._ctrlEdit.setEnabled(isEnabled && nbrSel > 0);
        this._ctrlDel.setEnabled(isEnabled && nbrSel > 0 && !isMasterAdminSelect);
        this._ctrlMasterAdmin.setEnabled(nbrSel == 1 && isAdminSelect);
    }
}

