/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.admin.view;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTree;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeModel;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeNode;
import com.dassault.cecilia.core.cecilia.folder.DBFolderVirtualTreeModel;
import com.dassault.cecilia.core.cecilia.folder.DBFolderVirtualTreeRenderer;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.db.dao.DAOUser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class DBFolderDebugPanel
extends JPanel {
    CAppl _application;
    DBUser _dbUser;
    List<DBFolder> _roots;
    List<DBFolderTreeModel> _models;

    public DBFolderDebugPanel(CAppl application, DBUser dbUser, List<DBFolder> roots) {
        super(new BorderLayout());
        this._application = application;
        this._dbUser = dbUser;
        this._roots = roots;
        this._models = new ArrayList<DBFolderTreeModel>(this._roots.size() + 1);
        this.make();
    }

    public void make() {
        JTabbedPane tabPane = new JTabbedPane();
        DAOFolder daoFolder = this._application.getDAOFactory().createFolderDAO();
        DAOUser daoUser = this._application.getDAOFactory().createUserDAO();
        for (int i = 0; i < this._roots.size(); ++i) {
            DBFolder root = this._roots.get(i);
            DBFolderTreeModel model = null;
            DBFolderTreeAdmin tree = null;
            String title = null;
            switch (root.getFamily()) {
                case APPLICATION: {
                    model = new DBFolderTreeModel(daoFolder, daoUser, this._dbUser, null, "View-Others"){

                        @Override
                        protected boolean filterFolder(DBFolder dbFolder) {
                            switch (dbFolder.getFamily()) {
                                case PROJECT: 
                                case IMAG: 
                                case EQUIPMENT: 
                                case COMPONENT: 
                                case OPERATOR: 
                                case TYPE: {
                                    return false;
                                }
                            }
                            return true;
                        }
                    };
                    tree = new DBFolderTreeAdmin(this._application, model);
                    title = ResMsgCore.getString("MSG_FOL_SYST_OTHER");
                    break;
                }
                case COMPONENT: {
                    model = new DBFolderTreeModel(daoFolder, daoUser, this._dbUser, DBFolder.Family.COMPONENT, "View-Component");
                    tree = new DBFolderTreeAdmin(this._application, model);
                    title = ResMsgVoc.getString("VOC_COMPONENTS");
                    break;
                }
                case EQUIPMENT: {
                    model = new DBFolderTreeModel(daoFolder, daoUser, this._dbUser, DBFolder.Family.EQUIPMENT, "View-Equipment");
                    tree = new DBFolderTreeAdmin(this._application, model);
                    title = ResMsgVoc.getString("VOC_EQUIPMENTS");
                    break;
                }
                case OPERATOR: {
                    model = new DBFolderTreeModel(daoFolder, daoUser, this._dbUser, DBFolder.Family.OPERATOR, "View-Operator");
                    tree = new DBFolderTreeAdmin(this._application, model);
                    title = ResMsgVoc.getString("VOC_OPERATORS");
                    break;
                }
                case TYPE: {
                    model = new DBFolderTreeModel(daoFolder, daoUser, this._dbUser, DBFolder.Family.TYPE, "View-Type");
                    tree = new DBFolderTreeAdmin(this._application, model);
                    title = ResMsgVoc.getString("VOC_TYPES");
                    break;
                }
                case PROJECT: {
                    model = new DBFolderVirtualTreeModel(daoFolder, daoUser, this._dbUser, DBFolder.Family.PROJECT, "View-Project");
                    tree = new DBFolderTreeAdmin(this._application, model);
                    tree.setCellRenderer(new DBFolderVirtualTreeRenderer());
                    title = ResMsgVoc.getString("VOC_PROJECTS");
                    break;
                }
                case IMAG: {
                    model = new DBFolderTreeModel(daoFolder, daoUser, this._dbUser, DBFolder.Family.IMAG, "View-Imag");
                    tree = new DBFolderTreeAdmin(this._application, model);
                    title = ResMsgVoc.getString("VOC_IMAGES");
                }
            }
            if (tree == null) continue;
            JScrollPane scroll = new JScrollPane(tree);
            scroll.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            tabPane.addTab(title, scroll);
            model.setFolderRoot(root);
            this._application.addFolderUpdateListener(model);
            this._models.add(model);
        }
        this.add((Component)tabPane, "Center");
    }

    public synchronized void parentWindowClosing() {
        for (int i = this._models.size() - 1; i >= 0; --i) {
            DBFolderTreeModel model = this._models.get(i);
            this._application.removeFolderUpdateListener(model);
        }
        this._models.clear();
    }

    static class DBFolderTreeAdmin
    extends DBFolderTree {
        public DBFolderTreeAdmin(CAppl application, DBFolderTreeModel model) {
            super(application, model, true);
            this.addDBTreeActionListener(new DBFolderTree.DBTreeActionListener(){

                @Override
                public void actionPerformed(DBFolderTreeNode selectNode, MouseEvent e) {
                    if (!this.getAppl().isDebugMode()) {
                        return;
                    }
                    DBFolder dbFolder = selectNode.getDBFolder();
                    if (dbFolder.isVersion() || e.isAltDown()) {
                        this.doDebug(dbFolder);
                    }
                }
            });
        }
    }
}

