/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.translator;

import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.lib.ban.BanConnected;
import com.dassault.cecilia.lib.ban.BanEntry;
import com.dassault.cecilia.plugin.mbsa.translator.PanelDisplayMessage;
import com.dassault.cecilia.plugin.mbsa.translator.ResTrans;
import java.awt.Component;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;

public class BanTranslateHelper
implements BanConnected {
    protected Plugable _launcher;
    BanEntry _ban;
    IModel _model;

    public BanTranslateHelper(Plugable launcher) {
        this._launcher = launcher;
    }

    public BanTranslateHelper setModel(IModel model) {
        this._model = model;
        return this;
    }

    protected void showParseError(List<String> msgs, String title) {
        BanTranslateHelper.showParseError(this._launcher, this._model, msgs, title);
    }

    public static void showParseError(Plugable launcher, IModel model, List<String> msgs, final String title) {
        PanelDisplayMessage panel = new PanelDisplayMessage(){

            @Override
            public String getInfo(String key) {
                if (title != null && key.equals("ppanel.title")) {
                    return title;
                }
                return super.getInfo(key);
            }
        };
        panel.initializeData(model.getFile());
        launcher.addPanel((PlugPanel)panel, model.getUID());
        panel.updateData(msgs);
    }

    protected void showErrorMessage(String key, Throwable e, Object ... objects) {
        BanTranslateHelper.showErrorMessage(this._launcher, key, e, objects);
    }

    public static void showErrorMessage(Plugable launcher, String key, Throwable e, Object ... objects) {
        StringBuffer sb = new StringBuffer(128);
        sb.append("<html>");
        sb.append("<b>").append(ResTrans.getString(key)).append("</b><br>");
        if (e != null) {
            sb.append("<i>");
            sb.append(e.getClass().getName());
            sb.append("</i><ul style=\"list-style-type: none;\">");
            String excMsg = e.getMessage();
            if (excMsg == null) {
                excMsg = "null";
            }
            StringTokenizer st = new StringTokenizer(excMsg, "\n");
            while (st.hasMoreTokens()) {
                sb.append("<li>");
                String msg = st.nextToken();
                boolean first = true;
                while (msg.length() > 80) {
                    if (!first) {
                        sb.append("<li>");
                    }
                    sb.append(msg.substring(0, 80));
                    msg = msg.substring(80);
                    if (first) {
                        first = false;
                        sb.append(" ...<ul style=\"list-style-type: none;\">");
                        continue;
                    }
                    sb.append("    ...");
                }
                if (!first) {
                    sb.append("    ...<li>");
                }
                sb.append(msg);
                if (first) continue;
                sb.append("</ul>");
            }
            sb.append("</ul>");
        }
        for (int i = 0; i < objects.length; ++i) {
            sb.append("<br>").append(objects[i].toString());
        }
        sb.append("</html>");
        JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launcher.getWindow()), sb.toString(), ResTrans.getString("DEF_TITLE"), 0);
    }

    public BanEntry getBanEntry() {
        return this._ban;
    }
}

