/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.translator;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.swing.list.ArrayListModel;
import com.dassault.cecilia.dbobj.mbsa.node.gui.OcasStyledDocument;
import com.dassault.cecilia.lib.mbsa.translator.parser.OcasLexer;
import com.dassault.cecilia.plugin.mbsa.translator.ResTrans;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Element;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class PanelDisplayMessage
extends JPanel
implements PlugPanel {
    private static final String DEFAULT = "Line-Default";
    private static final String HERROR = "Line-HError";
    private static final String LERROR = "Line-LError";
    private static final String LCURRENT = "Line-LCurrent";
    JSplitPane _splitError;
    JSplitPane _splitLine;
    JScrollPane _scrLine;
    JScrollPane _scrFile;
    JTextPaneNoWrap _txtLine;
    JTextPaneNoWrap _txtFile;
    JList _tabError;
    ArrayListModel<String> _docError;
    OcasStyledDocument _docFile;
    StyledDocument _docLine;
    int _docNbrLine;
    NumberFormat _nbrFrm;
    ArrayList<Fragment> _lstFragment;
    TreeSet<Integer> _lstLineError;
    TreeSet<Integer> _lstCurrError;
    Pattern _pattern = null;

    public PanelDisplayMessage() {
        super(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this._nbrFrm = NumberFormat.getIntegerInstance();
        this._nbrFrm.setGroupingUsed(false);
        this._txtLine = new JTextPaneNoWrap();
        this._txtLine.setFocusable(false);
        this._txtLine.setEditable(false);
        this._txtLine.setFont(new Font("courier", 0, 12));
        this._docLine = this._txtLine.getStyledDocument();
        Style parent = this._docLine.getStyle("default");
        parent = this._docLine.addStyle(DEFAULT, parent);
        StyleConstants.setFontFamily(parent, "Courier");
        StyleConstants.setFontSize(parent, 12);
        StyleConstants.setForeground(parent, Color.black);
        Style cur = this._docLine.addStyle(HERROR, parent);
        StyleConstants.setBold(cur, true);
        StyleConstants.setForeground(cur, Color.red);
        cur = this._docLine.addStyle(LERROR, parent);
        StyleConstants.setForeground(cur, Color.red);
        cur = this._docLine.addStyle(LCURRENT, parent);
        StyleConstants.setBold(cur, true);
        StyleConstants.setForeground(cur, Color.magenta);
        this._txtLine.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                int pos = PanelDisplayMessage.this._txtLine.getSelectionEnd();
                if (pos == -1) {
                    return;
                }
                PanelDisplayMessage.this.changeCollapse(pos);
            }
        });
        this._docFile = new OcasStyledDocument(new StyleContext());
        this._txtFile = new JTextPaneNoWrap((StyledDocument)this._docFile){};
        this._txtFile.setEditable(false);
        this._txtFile.setFont(new Font("courier", 0, 12));
        this._scrLine = new JScrollPane(this._txtLine);
        this._scrFile = new JScrollPane(this._txtFile);
        this._scrLine.setHorizontalScrollBarPolicy(32);
        this._scrLine.setVerticalScrollBarPolicy(21);
        this._scrFile.setHorizontalScrollBarPolicy(32);
        this._scrFile.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                PanelDisplayMessage.this._scrLine.getVerticalScrollBar().setValue(PanelDisplayMessage.this._scrFile.getVerticalScrollBar().getValue());
            }
        });
        JPanel splitLine = new JPanel(new BorderLayout());
        splitLine.add((Component)this._scrLine, "West");
        splitLine.add((Component)this._scrFile, "Center");
        this._docError = new ArrayListModel();
        this._tabError = new JList<String>((ListModel<String>)this._docError);
        this._tabError.setFont(new Font("courier", 0, 12));
        this._tabError.setSelectionMode(1);
        ListSelectionModel rowSM = this._tabError.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (!lsm.isSelectionEmpty()) {
                    int selectedRow = lsm.getMinSelectionIndex();
                    String val = (String)PanelDisplayMessage.this._docError.get(selectedRow);
                    PanelDisplayMessage.this.updateLines(PanelDisplayMessage.this._lstCurrError, ChgLine.INIT);
                    PanelDisplayMessage.this._lstCurrError = new TreeSet();
                    int line = PanelDisplayMessage.this.collapseError(val, true, PanelDisplayMessage.this._lstCurrError);
                    PanelDisplayMessage.this.updateLines(PanelDisplayMessage.this._lstCurrError, ChgLine.SET);
                    PanelDisplayMessage.this.selectLine(line);
                }
            }
        });
        this._splitError = new JSplitPane(0, true, splitLine, new JScrollPane(this._tabError));
        this._splitError.setResizeWeight(0.8);
        this.add((Component)this._splitError, "Center");
        this._tabError.getActionMap().put("CopyErrorToXML", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringBuffer xmlString = new StringBuffer("");
                for (int idx = 0; idx < PanelDisplayMessage.this._docError.getSize(); ++idx) {
                    String txt = (String)PanelDisplayMessage.this._docError.get(idx);
                    char curCar = ' ';
                    block8: for (int i = 0; i < txt.length(); ++i) {
                        curCar = txt.charAt(i);
                        switch (curCar) {
                            case '&': {
                                xmlString.append("&amp;");
                                continue block8;
                            }
                            case '<': {
                                xmlString.append("&lt;");
                                continue block8;
                            }
                            case '>': {
                                xmlString.append("&gt;");
                                continue block8;
                            }
                            case '\'': {
                                xmlString.append("&apos;");
                                continue block8;
                            }
                            case '\"': {
                                xmlString.append("&quot;");
                                continue block8;
                            }
                            default: {
                                xmlString.append(curCar);
                            }
                        }
                    }
                    xmlString.append("\n");
                }
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(xmlString.toString()), null);
            }
        });
        this._tabError.getInputMap(2).put(KeyStroke.getKeyStroke("ctrl shift P"), "CopyErrorToXML");
    }

    public void initializeData(File file) {
        this._txtFile.setText("");
        this._txtLine.setText("");
        this._lstFragment = new ArrayList();
        this._lstLineError = new TreeSet();
        this._lstCurrError = new TreeSet();
        try {
            this.createFragments(file);
            this.transformFragments(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            for (int i = 0; i < this._lstFragment.size(); ++i) {
                Fragment cur = this._lstFragment.get(i);
                this._docFile.insertString(this._docFile.getLength(), cur.getTxtFile(), null);
                this._docLine.insertString(this._docLine.getLength(), cur.getTxtLine(), null);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void updateData(List<String> msgMng) {
        this.updateError(msgMng);
        this.updateLines(this._lstLineError, ChgLine.INIT);
    }

    private void updateLines(TreeSet<Integer> lineError, ChgLine opt) {
        if (this._lstFragment.size() == 0) {
            return;
        }
        int pos = 0;
        int idx = 0;
        for (int i = 0; i < this._lstFragment.size(); ++i) {
            Fragment cur = this._lstFragment.get(i);
            cur.setError(false);
        }
        Iterator<Integer> i = lineError.iterator();
        block1: while (i.hasNext()) {
            int line = i.next() - 1;
            while (idx < this._lstFragment.size()) {
                Fragment cur = this._lstFragment.get(idx);
                if (line >= cur._begin && line <= cur._end) {
                    if (!cur.isError()) {
                        cur.setError(true);
                        this.changeLine(pos, 0, opt, true);
                    }
                    if (cur.isCollapse()) continue block1;
                    this.changeLine(pos, line - cur._begin, opt, false);
                    continue block1;
                }
                pos += cur.getTxtLine().length();
                ++idx;
            }
        }
    }

    private void changeLine(int pos, int addLine, ChgLine opt, boolean header) {
        Element eltR = this._docLine.getDefaultRootElement();
        int numLine = eltR.getElementIndex(pos);
        Element elt = eltR.getElement(numLine += addLine);
        int start = elt.getStartOffset();
        this._docLine.setCharacterAttributes(start, elt.getEndOffset() - start, this._docLine.getStyle(header ? HERROR : (opt == ChgLine.INIT ? LERROR : LCURRENT)), true);
    }

    private void updateError(List<String> msgMng) {
        int size = msgMng.size();
        ArrayList<Object> data = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            String msg = msgMng.get(i);
            boolean first = true;
            StringTokenizer st = new StringTokenizer(msg, "\n");
            while (st.hasMoreTokens()) {
                String line = st.nextToken();
                if (first) {
                    data.add(line);
                    first = false;
                } else {
                    data.add("    " + line);
                }
                this.collapseError(line, false, this._lstLineError);
            }
        }
        this._docError.setList(data);
        if (data.size() > 0) {
            this._tabError.setSelectedIndex(0);
        }
    }

    protected Pattern getLinePattern() {
        if (this._pattern == null) {
            this._pattern = Pattern.compile("^[^:]+: ([0-9]+) : ");
        }
        return this._pattern;
    }

    protected int parseMessag(String msg) {
        Pattern pattern = this.getLinePattern();
        if (pattern == null) {
            return -1;
        }
        Matcher match = pattern.matcher(msg);
        if (!match.find()) {
            return -1;
        }
        String str = match.group(1);
        int line = Integer.parseInt(str);
        return line;
    }

    protected int collapseError(String error, boolean collapse, TreeSet<Integer> linesSet) {
        int result = -1;
        try {
            boolean change = false;
            StringTokenizer st = new StringTokenizer(error, "\n");
            while (st.hasMoreTokens()) {
                Fragment sel;
                int line = this.parseMessag(st.nextToken());
                if (line <= 0 || line > this._docNbrLine || (sel = this.getFragment(line - 1)) == null) continue;
                if (result == -1) {
                    result = line;
                }
                linesSet.add(line);
                if (!collapse || !sel.isCollapse()) continue;
                change = true;
                this.setCollapse(sel, false);
            }
            if (change) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BoundedRangeModel model = PanelDisplayMessage.this._scrFile.getVerticalScrollBar().getModel();
                        model.setValue(model.getValue() + 1);
                        model = PanelDisplayMessage.this._scrFile.getHorizontalScrollBar().getModel();
                        model.setValue(model.getValue() + 1);
                    }
                });
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return result;
    }

    protected void selectLine(int line) {
        if (line <= 0 || line > this._docNbrLine) {
            return;
        }
        int pos = 0;
        for (int i = 0; i < this._lstFragment.size(); ++i) {
            Fragment cur = this._lstFragment.get(i);
            if (line - 1 >= cur._begin && line - 1 <= cur._end) {
                Element eltR = this._docFile.getDefaultRootElement();
                int numLine = eltR.getElementIndex(pos);
                Element elt = eltR.getElement((numLine += line - cur._begin) - 1);
                this._txtFile.requestFocus();
                Caret caret = this._txtFile.getCaret();
                caret.setSelectionVisible(true);
                caret.setDot(elt.getEndOffset() - 1);
                caret.moveDot(elt.getStartOffset());
                return;
            }
            pos += cur.getTxtFileLength();
        }
    }

    protected Fragment getFragment(int line) {
        Fragment sel = null;
        for (int i = this._lstFragment.size() - 1; i >= 0 && sel == null; --i) {
            Fragment cur = this._lstFragment.get(i);
            if (line < cur._begin || line > cur._end) continue;
            sel = cur;
        }
        return sel;
    }

    protected void changeCollapse(int offset) {
        try {
            int line = this.getNumLine(offset);
            if (line < 0) {
                return;
            }
            Fragment sel = this.getFragment(line);
            if (sel == null || sel._type.length() == 0) {
                return;
            }
            this.setCollapse(sel, !sel.isCollapse());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    protected void setCollapse(Fragment frg, boolean collapse) throws BadLocationException {
        Fragment cur;
        if (collapse == frg.isCollapse()) {
            return;
        }
        int startLine = 0;
        for (int i = 0; i < this._lstFragment.size() && (cur = this._lstFragment.get(i)) != frg; ++i) {
            if (cur.isCollapse() && cur._type.length() != 0) {
                if (cur._len == 1) {
                    ++startLine;
                    continue;
                }
                startLine += 2;
                continue;
            }
            startLine += cur._len;
        }
        int posFile = this._docFile.getDefaultRootElement().getElement(startLine).getStartOffset();
        int posLine = this._docLine.getDefaultRootElement().getElement(startLine).getStartOffset();
        this._docFile.remove(posFile, frg.getTxtFileLength());
        this._docLine.remove(posLine, frg.getTxtLine().length());
        frg.setCollapse(collapse);
        this._docFile.insertString(posFile, frg.getTxtFile(), null);
        int cptLine = frg._begin;
        StringTokenizer st = new StringTokenizer(frg.getTxtLine(), "\n", true);
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (tok.equals("\n")) {
                this._docLine.insertString(posLine, tok, this._docLine.getStyle(DEFAULT));
                ++cptLine;
            } else {
                Style style = this._docLine.getStyle(DEFAULT);
                if (cptLine == frg._begin) {
                    if (frg.isError()) {
                        style = this._docLine.getStyle(HERROR);
                    }
                } else if (!frg.isCollapse()) {
                    if (this._lstCurrError.contains(cptLine + 1)) {
                        style = this._docLine.getStyle(LCURRENT);
                    } else if (this._lstLineError.contains(cptLine + 1)) {
                        style = this._docLine.getStyle(LERROR);
                    }
                }
                this._docLine.insertString(posLine, tok, style);
            }
            posLine += tok.length();
        }
    }

    private int getNumLine(int offset) throws BadLocationException {
        Element eltR = this._docLine.getDefaultRootElement();
        int numLigne = eltR.getElementIndex(offset);
        Element elt = eltR.getElement(numLigne);
        String txt = this._docLine.getText(elt.getStartOffset(), elt.getEndOffset() - elt.getStartOffset());
        for (int i = txt.length() - 1; i >= 0; --i) {
            if (!Character.isDigit(txt.charAt(i))) continue;
            return Integer.parseInt(txt.substring(0, i + 1)) - 1;
        }
        return -1;
    }

    protected void transformFragments(File file) throws IOException {
        int curIdx = 0;
        ArrayList<Fragment> curDoc = this._lstFragment;
        this._lstFragment = new ArrayList();
        Fragment blank = null;
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            int cpt = 0;
            while ((line = reader.readLine()) != null) {
                if (curIdx >= curDoc.size()) {
                    if (blank == null) {
                        blank = new Fragment("", cpt);
                        this._lstFragment.add(blank);
                    }
                    blank.addLine(line);
                }
                int first = curIdx;
                for (int i = curIdx; i < curDoc.size(); ++i) {
                    Fragment cur = curDoc.get(i);
                    if (cur._begin > cpt) {
                        if (i != first) break;
                        if (blank == null) {
                            blank = new Fragment("", cpt);
                            this._lstFragment.add(blank);
                        }
                        blank.addLine(line);
                        continue;
                    }
                    if (blank != null) {
                        blank._end = cpt - 1;
                        blank = null;
                    }
                    cur.addLine(line);
                    if (cur._end != cpt) continue;
                    this._lstFragment.add(cur);
                    ++curIdx;
                }
                ++cpt;
            }
            if (curIdx != curDoc.size()) {
                throw new IOException("Internal error parse fragment Altarica file");
            }
        }
    }

    protected void createFragments(File file) throws IOException {
        try (FileReader reader = new FileReader(file);){
            OcasLexer lex = new OcasLexer((Reader)reader);
            int state = 0;
            Fragment current = null;
            int tok = lex.yylex();
            while (tok > 0) {
                switch (state) {
                    case 0: {
                        switch (tok) {
                            case 1005: {
                                current = new Fragment(lex.yytext(), lex.nbline());
                                this._lstFragment.add(current);
                                state = 10;
                                break;
                            }
                            case 1040: {
                                current = new Fragment(lex.yytext(), lex.nbline());
                                this._lstFragment.add(current);
                                state = 20;
                                break;
                            }
                            case 1001: {
                                current = new Fragment(lex.yytext(), lex.nbline());
                                this._lstFragment.add(current);
                                state = 30;
                            }
                        }
                        break;
                    }
                    case 10: {
                        current._name = lex.yytext();
                        state = 11;
                        break;
                    }
                    case 11: {
                        if (tok != 1006) break;
                        current._end = lex.nbline();
                        state = 0;
                        break;
                    }
                    case 20: {
                        current._name = lex.yytext();
                        state = 21;
                        break;
                    }
                    case 21: {
                        if (tok != 1041) break;
                        current._end = lex.nbline();
                        state = 0;
                        break;
                    }
                    case 30: {
                        current._name = lex.yytext();
                        state = 31;
                        break;
                    }
                    case 31: {
                        if (tok == 1042) {
                            state = 39;
                            break;
                        }
                        if (tok == 61) break;
                        state = 32;
                        break;
                    }
                    case 32: {
                        if (tok != 59) break;
                        current._end = lex.nbline();
                        state = 0;
                        break;
                    }
                    case 39: {
                        if (tok != 1043) break;
                        current._end = lex.nbline();
                        state = 0;
                    }
                }
                tok = lex.yylex();
            }
            if (state != 0) {
                current._end = lex.nbline();
                state = 0;
            }
            this._docNbrLine = lex.nbline();
            int cpt = 0;
            int tmp = this._docNbrLine;
            while (tmp > 0) {
                tmp /= 10;
                ++cpt;
            }
            this._nbrFrm.setMinimumIntegerDigits(cpt);
        }
    }

    public Component getPanel() {
        return this;
    }

    public String getInfo(String key) {
        if (key.equals("ppanel.title")) {
            return ResTrans.getString("DLG_ERROR_TITLE");
        }
        if (key.equals("ppanel.default.width")) {
            return "600";
        }
        if (key.equals("ppanel.default.height")) {
            return "480";
        }
        return null;
    }

    public Icon getIcon(String key) {
        if (key.equals("ppanel.icon")) {
            return ResIcoCore.getImageIcon((String)"MSG_ERROR");
        }
        return null;
    }

    public void trash() {
        if (this._docFile == null) {
            return;
        }
        this._lstFragment.clear();
        this._lstCurrError.clear();
        this._lstLineError.clear();
        this._docError.clear();
        this._txtFile.setText("");
        this._txtLine.setText("");
        this._docFile = null;
        this._docLine = null;
        this._docError = null;
        this._txtFile = null;
        this._txtLine = null;
    }

    class JTextPaneNoWrap
    extends JTextPane {
        public JTextPaneNoWrap() {
        }

        public JTextPaneNoWrap(StyledDocument doc) {
            super(doc);
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            Container parent = this.getParent();
            TextUI lui = this.getUI();
            boolean bool = parent != null ? lui.getPreferredSize((JComponent)this).width < parent.getSize().width : true;
            return bool;
        }
    }

    class Fragment {
        String _type;
        String _name;
        String _first;
        String _last;
        StringBuffer _content;
        int _len;
        boolean _collapse;
        boolean _error;
        int _begin;
        int _end;

        Fragment(String type, int begin) {
            this._type = type;
            this._begin = begin;
            this._name = "";
            this._len = 0;
            this._content = null;
            this._collapse = true;
        }

        void addLine(String line) {
            if (this._content == null) {
                this._content = new StringBuffer(256);
                this._first = line + " /*...*/\n";
            }
            this._content.append(line);
            this._content.append("\n");
            this._last = line;
            ++this._len;
        }

        void setCollapse(boolean val) {
            this._collapse = val;
        }

        boolean isCollapse() {
            return this._collapse;
        }

        void setError(boolean val) {
            this._error = val;
        }

        boolean isError() {
            return this._error;
        }

        String getTxtFile() {
            if (this._collapse && this._type.length() > 0) {
                if (this._len == 1) {
                    return this._first;
                }
                return this._first + this._last + "\n";
            }
            return this._content.toString();
        }

        int getTxtFileLength() {
            if (this._collapse && this._type.length() > 0) {
                if (this._len == 1) {
                    return this._first.length();
                }
                return this._first.length() + this._last.length() + 1;
            }
            return this._content.length();
        }

        String getTxtLine() {
            StringBuffer sb = new StringBuffer(this._len * 6);
            if (this._collapse && this._type.length() > 0) {
                if (this._len == 1) {
                    sb.append(PanelDisplayMessage.this._nbrFrm.format(this._begin + 1));
                    sb.append("\n");
                } else {
                    sb.append(PanelDisplayMessage.this._nbrFrm.format(this._begin + 1));
                    sb.append("[+]\n");
                    sb.append(PanelDisplayMessage.this._nbrFrm.format(this._begin + this._len));
                    sb.append("\n");
                }
            } else {
                for (int i = 0; i < this._len; ++i) {
                    sb.append(PanelDisplayMessage.this._nbrFrm.format(this._begin + i + 1));
                    if (i == 0 && this._type.length() > 0) {
                        sb.append("[-]");
                    }
                    sb.append("\n");
                }
            }
            return sb.toString();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(this._content.length() + 128);
            sb.append("Fragment(\"");
            sb.append(this._type);
            sb.append("\", \"");
            sb.append(this._name);
            sb.append("\", ");
            sb.append(this._begin);
            sb.append(", ");
            sb.append(this._end);
            sb.append(") {\n");
            sb.append(this._content);
            sb.append("}\n");
            return sb.toString();
        }
    }

    static enum ChgLine {
        DEF,
        INIT,
        SET,
        UNSET;

    }
}

