/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.translator;

import com.dassault.cecilia.core.plugin.IOParameters;
import com.dassault.cecilia.core.plugin.PluginMTranslate;
import com.dassault.cecilia.core.plugin.PluginManager;
import com.dassault.cecilia.core.plugin.PluginModel;
import com.dassault.cecilia.lib.util.io.FileUtility;
import com.dassault.cecilia.plugin.mbsa.translator.ParametersShellExec;
import java.io.IOException;
import java.io.Writer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ParametersIOShellExec
implements IOParameters {
    protected static final String KEY_SHELL_EXECUTE = "shell-execute";
    protected static final String KEY_JNI = "shell";
    protected static final String KEY_EXEC = "binary";
    protected static final String KEY_ARGS = "arguments";
    protected static final String KEY_DIR = "working-directory";
    protected static final String KEY_TRANS = "plugin-translate";

    ParametersIOShellExec() {
    }

    public void writeXML(Writer out, Object parameters, PluginManager launcher) throws IOException {
        if (parameters instanceof ParametersShellExec) {
            ParametersShellExec shell = (ParametersShellExec)parameters;
            out.write("<");
            out.write(KEY_SHELL_EXECUTE);
            out.write(" ");
            out.write(KEY_JNI);
            out.write("=\"");
            out.write(shell.isShellExec() ? "true" : "false");
            out.write("\"");
            out.write(" ");
            out.write(KEY_EXEC);
            out.write("='");
            String exec = shell.getExec();
            if (exec == null) {
                exec = "";
            }
            out.write(FileUtility.convertXML((String)exec));
            out.write("'");
            out.write(" ");
            out.write(KEY_ARGS);
            out.write("=\"");
            out.write(FileUtility.convertXML((String)shell.getArgs()));
            out.write("\"");
            out.write(" ");
            out.write(KEY_DIR);
            out.write("='");
            out.write(FileUtility.convertXML((String)shell.getDir()));
            out.write("'");
            out.write(" ");
            out.write(KEY_TRANS);
            out.write("='");
            String trKey = shell.getTrKey();
            if (trKey == null) {
                trKey = "";
            }
            out.write(FileUtility.convertXML((String)trKey));
            out.write("'");
            Object params = shell.getTrParams();
            if (params != null && launcher != null) {
                out.write(">\n");
                PluginModel plug = launcher.getPlugin(shell.getTrKey());
                if (plug != null && plug.withParameters()) {
                    plug.getIOParameters().writeXML(out, params, launcher);
                }
                out.write("</");
                out.write(KEY_SHELL_EXECUTE);
                out.write(">\n");
            } else {
                out.write("/>\n");
            }
        } else {
            throw new IOException("Unsupported object for TranslateIOShellExec");
        }
    }

    public Object readXML(Node node, PluginManager launcher) {
        if (node.getNodeType() != 1) {
            return null;
        }
        Element root = (Element)node;
        if (!root.getNodeName().equals(KEY_SHELL_EXECUTE)) {
            return null;
        }
        ParametersShellExec res = new ParametersShellExec();
        Node attr = root.getAttributes().getNamedItem(KEY_EXEC);
        if (attr != null) {
            res._exec = attr.getNodeValue();
        }
        if ((attr = root.getAttributes().getNamedItem(KEY_ARGS)) != null) {
            res._args = attr.getNodeValue();
        }
        if ((attr = root.getAttributes().getNamedItem(KEY_DIR)) != null) {
            res._dir = attr.getNodeValue();
        }
        if ((attr = root.getAttributes().getNamedItem(KEY_JNI)) != null) {
            res._shellExec = attr.getNodeValue().equalsIgnoreCase("true");
        }
        attr = root.getAttributes().getNamedItem(KEY_TRANS);
        while (attr != null) {
            NodeList params;
            PluginModel plugin;
            res._trKey = attr.getNodeValue();
            if (launcher == null || (plugin = launcher.getPlugin(res._trKey)) == null || !(plugin instanceof PluginMTranslate)) break;
            if (plugin.withParameters() && (params = root.getElementsByTagName(plugin.getInfo("plugin.parameterTag"))).getLength() == 1) {
                res._trPars = plugin.getIOParameters().readXML(params.item(0), launcher);
            }
            attr = null;
        }
        return res;
    }
}

