/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.translator;

import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.core.plugin.PluginModel;
import com.dassault.cecilia.core.swing.other.JCRLabel;
import com.dassault.cecilia.plugin.mbsa.translator.ResTrans;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class TranslateOptions
extends JPanel
implements PlugPanel {
    public static final String OPT_CCF = TranslateOptions.class.getName() + "#TranslateWithCCF";
    public static final String OPT_VERIFY = TranslateOptions.class.getName() + "#DataFlowWithSimul";
    public static final String OPT_LOCAL_SIMUL = TranslateOptions.class.getName() + "#LocalSimul";
    public static final String OPT_EXTERN = TranslateOptions.class.getName() + "#Extern";
    public static final String OPT_EXTERN_REMARK = TranslateOptions.class.getName() + "#ExternRemark";
    public static final String OPT_EXTERN_LAW = TranslateOptions.class.getName() + "#ExternLaw";
    public static final String OPT_EXTERN_LAW_ARL = TranslateOptions.class.getName() + "#ExternLawAralia";
    public static final String OPT_EXTERN_LAW_MOK = TranslateOptions.class.getName() + "#ExternLawMoca";
    public static final String OPT_EXTERN_PARAM = TranslateOptions.class.getName() + "#ExternParameter";
    public static final String OPT_EXTERN_ATTRIB = TranslateOptions.class.getName() + "#ExternAttribute";
    public static final String OPT_EXTERN_NODEPROPERTY = TranslateOptions.class.getName() + "#ExternNodeProperty";
    public static final String OPT_EXTERN_PRIO = TranslateOptions.class.getName() + "#ExternPriority";
    public static final String OPT_EXTERN_PRIO_DIRAC = TranslateOptions.class.getName() + "#ExternPriorityDirac";
    public static final String OPT_EXTERN_BUCKET = TranslateOptions.class.getName() + "#ExternBucket";
    public static final String OPT_EXTERN_PREEMPTIBLE = TranslateOptions.class.getName() + "#ExternPreemptible";
    public static final String OPT_EXTERN_PROPERTY = TranslateOptions.class.getName() + "#ExternProperty";
    public static final String OPT_EXTERN_PREDICATE = TranslateOptions.class.getName() + "#ExternPredicate";
    public static final String OPT_EXTERN_OBSERVER = TranslateOptions.class.getName() + "#ExternObserver";
    public static final String OPT_EVENT = TranslateOptions.class.getName() + "#Event";
    public static final String OPT_EVENT_LAW = TranslateOptions.class.getName() + "#EventLaw";
    public static final String OPT_EVENT_TEMPORISED = TranslateOptions.class.getName() + "#EventTemporised";
    public static final String OPT_EVENT_INSTANTANEOUS = TranslateOptions.class.getName() + "#EventInstantaneous";
    public static final String OPT_LOOP = TranslateOptions.class.getName() + "#Loop";
    public static final String OPT_TRANS_CONFLICT = TranslateOptions.class.getName() + "#TransConflict";
    public static final String OPT_GUARD = TranslateOptions.class.getName() + "#Guard";
    public static final String OPT_GUARD_TRUE = TranslateOptions.class.getName() + "#GuardTrue";
    public static final String OPT_GUARD_WITHFLOW = TranslateOptions.class.getName() + "#GuardWithFlow";
    public static final String OPT_GUARD_FALSE = TranslateOptions.class.getName() + "#GuardFalse";
    public static final String OPT_LOCALSIMUL = TranslateOptions.class.getName() + "#LocalSimul";
    public static final String OPT_LOCALSIMUL_STATIC = TranslateOptions.class.getName() + "#LocalSimulStatic";
    public static final String OPT_SYNC = TranslateOptions.class.getName() + "#Sync";
    public static final String OPT_SYNC_SYNC = TranslateOptions.class.getName() + "#SyncSync";
    public static final String OPT_SYNC_DIFF = TranslateOptions.class.getName() + "#SyncDiff";
    public static final String OPT_SYNC_CCF = TranslateOptions.class.getName() + "#SyncCCF";
    public static final String OPT_SYNC_SOME_SUB = TranslateOptions.class.getName() + "#SyncSomeSub";
    public static final String OPT_EXPR = TranslateOptions.class.getName() + "#Expr";
    public static final String OPT_EXPR_INT = TranslateOptions.class.getName() + "#ExprInt";
    public static final String OPT_EXPR_FLOAT = TranslateOptions.class.getName() + "#ExprFloat";
    public static final String OPT_EXPR_ADDSOU = TranslateOptions.class.getName() + "#ExprAddSou";
    public static final String OPT_EXPR_MULDIV = TranslateOptions.class.getName() + "#ExprMulDiv";
    public static final String OPT_EXPR_MOD = TranslateOptions.class.getName() + "#ExprMod";
    public static final String OPT_EXPR_MINMAX = TranslateOptions.class.getName() + "#ExprMinMax";
    public static final String OPT_EXPR_CRD = TranslateOptions.class.getName() + "#ExprCrd";
    public static final String OPT_EXPR_STATE = TranslateOptions.class.getName() + "#ExprState";
    public static final String OPT_GENERATE_JAVA1 = TranslateOptions.class.getName() + "#GenerateJava1";
    public static final String OPT_FLATNESS_MEC5 = TranslateOptions.class.getName() + "#FlatnessMec5";
    private static int HEADER_SIZE = new String(TranslateOptions.class.getName() + "#").length();
    Plugable _launcher = null;
    PluginModel _owner = null;
    List<UOpt> _uOpts = new ArrayList<UOpt>();

    public static int getWarningOpt(Plugable launcher, String opt, int def) {
        if ((opt = launcher.getOption(opt)).length() == 0) {
            return def;
        }
        try {
            int val = Integer.parseInt(opt);
            if (val < 0 || val > 2) {
                return def;
            }
            return val;
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public static boolean getBoolOpt(Plugable launcher, String key, boolean def) {
        String value = launcher.getOption(key);
        if (value == null || value.length() == 0) {
            return def;
        }
        return value.equalsIgnoreCase("true");
    }

    public static boolean withTranslateCCF(Plugable launcher) {
        return TranslateOptions.getBoolOpt(launcher, OPT_CCF, true);
    }

    public static boolean withDataFlowVerify(Plugable launcher) {
        return TranslateOptions.getBoolOpt(launcher, OPT_VERIFY, true);
    }

    public static boolean withFlatnessMec5(Plugable launcher) {
        return TranslateOptions.getBoolOpt(launcher, OPT_FLATNESS_MEC5, true);
    }

    private static boolean testOpt(Plugable launcher, String opt, int level, StringBuffer sb) {
        if (TranslateOptions.getWarningOpt(launcher, opt, 0) >= level) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(opt.substring(HEADER_SIZE));
            return true;
        }
        return false;
    }

    public static String listVerifyBefore(Plugable launcher, int level) {
        boolean set;
        StringBuffer sb = new StringBuffer(64);
        if (TranslateOptions.getBoolOpt(launcher, OPT_GUARD, true)) {
            set = false;
            set |= TranslateOptions.testOpt(launcher, OPT_GUARD_TRUE, level, sb);
            set |= TranslateOptions.testOpt(launcher, OPT_GUARD_FALSE, level, sb);
            if (set |= TranslateOptions.testOpt(launcher, OPT_GUARD_WITHFLOW, level, sb)) {
                sb.append(",").append(OPT_GUARD.substring(HEADER_SIZE));
            }
        }
        TranslateOptions.testOpt(launcher, OPT_TRANS_CONFLICT, level, sb);
        if (TranslateOptions.getBoolOpt(launcher, OPT_SYNC, true)) {
            set = false;
            set |= TranslateOptions.testOpt(launcher, OPT_SYNC_SYNC, level, sb);
            set |= TranslateOptions.testOpt(launcher, OPT_SYNC_DIFF, level, sb);
            set |= TranslateOptions.testOpt(launcher, OPT_SYNC_CCF, level, sb);
            if (set |= TranslateOptions.testOpt(launcher, OPT_SYNC_SOME_SUB, level, sb)) {
                sb.append(",").append(OPT_SYNC.substring(HEADER_SIZE));
            }
        }
        if (TranslateOptions.getBoolOpt(launcher, OPT_EXPR, true)) {
            set = false;
            set |= TranslateOptions.testOpt(launcher, OPT_EXPR_INT, level, sb);
            set |= TranslateOptions.testOpt(launcher, OPT_EXPR_FLOAT, level, sb);
            set |= TranslateOptions.testOpt(launcher, OPT_EXPR_ADDSOU, level, sb);
            set |= TranslateOptions.testOpt(launcher, OPT_EXPR_MULDIV, level, sb);
            set |= TranslateOptions.testOpt(launcher, OPT_EXPR_MOD, level, sb);
            set |= TranslateOptions.testOpt(launcher, OPT_EXPR_MINMAX, level, sb);
            set |= TranslateOptions.testOpt(launcher, OPT_EXPR_CRD, level, sb);
            if (set |= TranslateOptions.testOpt(launcher, OPT_EXPR_STATE, level, sb)) {
                sb.append(",").append(OPT_EXPR.substring(HEADER_SIZE));
            }
        }
        if (TranslateOptions.testOpt(launcher, OPT_LOCALSIMUL, level, sb) && TranslateOptions.getBoolOpt(launcher, OPT_LOCALSIMUL_STATIC, true)) {
            sb.append(",").append(OPT_LOCALSIMUL_STATIC.substring(HEADER_SIZE));
        }
        if (TranslateOptions.testOpt(launcher, OPT_GENERATE_JAVA1, level, sb) && TranslateOptions.getBoolOpt(launcher, OPT_GENERATE_JAVA1, true)) {
            sb.append(",").append(OPT_GENERATE_JAVA1.substring(HEADER_SIZE));
        }
        return sb.toString();
    }

    public static String listVerifyAfter(Plugable launcher, int level) {
        boolean set;
        StringBuffer sb = new StringBuffer(64);
        if (TranslateOptions.getBoolOpt(launcher, OPT_EVENT, true)) {
            set = false;
            set |= TranslateOptions.testOpt(launcher, OPT_EVENT_LAW, level, sb);
            set |= TranslateOptions.testOpt(launcher, OPT_EVENT_INSTANTANEOUS, level, sb);
            if (set |= TranslateOptions.testOpt(launcher, OPT_EVENT_TEMPORISED, level, sb)) {
                sb.append(",").append(OPT_EVENT.substring(HEADER_SIZE));
            }
        }
        TranslateOptions.testOpt(launcher, OPT_LOOP, level, sb);
        if (TranslateOptions.getBoolOpt(launcher, OPT_EXTERN, true)) {
            set = false;
            set |= TranslateOptions.testOpt(launcher, OPT_EXTERN_REMARK, level, sb);
            if (TranslateOptions.testOpt(launcher, OPT_EXTERN_LAW, level, sb)) {
                set = true;
                if (TranslateOptions.getBoolOpt(launcher, OPT_EXTERN_LAW_ARL, true)) {
                    sb.append(",").append(OPT_EXTERN_LAW_ARL.substring(HEADER_SIZE));
                }
                if (TranslateOptions.getBoolOpt(launcher, OPT_EXTERN_LAW_MOK, true)) {
                    sb.append(",").append(OPT_EXTERN_LAW_MOK.substring(HEADER_SIZE));
                }
            }
            set |= TranslateOptions.testOpt(launcher, OPT_EXTERN_PARAM, level, sb);
            set |= TranslateOptions.testOpt(launcher, OPT_EXTERN_ATTRIB, level, sb);
            set |= TranslateOptions.testOpt(launcher, OPT_EXTERN_NODEPROPERTY, level, sb);
            if (TranslateOptions.testOpt(launcher, OPT_EXTERN_PRIO, level, sb)) {
                set = true;
                if (TranslateOptions.getBoolOpt(launcher, OPT_EXTERN_PRIO_DIRAC, true)) {
                    sb.append(",").append(OPT_EXTERN_PRIO_DIRAC.substring(HEADER_SIZE));
                }
            }
            set |= TranslateOptions.testOpt(launcher, OPT_EXTERN_BUCKET, level, sb);
            set |= TranslateOptions.testOpt(launcher, OPT_EXTERN_PREEMPTIBLE, level, sb);
            set |= TranslateOptions.testOpt(launcher, OPT_EXTERN_PROPERTY, level, sb);
            set |= TranslateOptions.testOpt(launcher, OPT_EXTERN_PREDICATE, level, sb);
            if (set |= TranslateOptions.testOpt(launcher, OPT_EXTERN_OBSERVER, level, sb)) {
                sb.append(",").append(OPT_EXTERN.substring(HEADER_SIZE));
            }
        }
        return sb.toString();
    }

    public TranslateOptions(PluginModel owner) {
        super(new GridBagLayout());
        this._owner = owner;
        JPanel root = new JPanel(new GridBagLayout());
        int line = 0;
        OptCheckBox check = new OptCheckBox("DLG_OPT_VERIF_CCF", OPT_CCF);
        root.add((Component)check, new GridBagConstraints(0, line, 2, 1, 100.0, 100.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this._uOpts.add(check);
        check = new OptCheckBox("DLG_OPT_VERIF_VERIF", OPT_VERIFY);
        root.add((Component)check, new GridBagConstraints(0, ++line, 2, 1, 100.0, 100.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this._uOpts.add(check);
        OptCheckBox pcheck = new OptCheckBox("DLG_OPT_VERIF_EXPR", OPT_EXPR);
        root.add((Component)pcheck, new GridBagConstraints(0, ++line, 2, 1, 100.0, 100.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this._uOpts.add(pcheck);
        OptLabel lbl = new OptLabel("DLG_OPT_VERIF_EXPR_INT").setParent(pcheck);
        root.add((Component)((Object)lbl), new GridBagConstraints(0, ++line, 1, 1, 100.0, 100.0, 17, 0, new Insets(2, 22, 2, 0), 0, 0));
        OptComboBox cbb = new OptComboBox(OPT_EXPR_INT).setParent(pcheck);
        root.add((Component)cbb, new GridBagConstraints(1, line, 1, 1, 100.0, 100.0, 13, 0, new Insets(2, 0, 2, 2), 0, 0));
        this._uOpts.add(lbl);
        this._uOpts.add(cbb);
        lbl = new OptLabel("DLG_OPT_VERIF_EXPR_FLOAT").setParent(pcheck);
        root.add((Component)((Object)lbl), new GridBagConstraints(0, ++line, 1, 1, 100.0, 100.0, 17, 0, new Insets(2, 22, 2, 0), 0, 0));
        cbb = new OptComboBox(OPT_EXPR_FLOAT).setParent(pcheck);
        root.add((Component)cbb, new GridBagConstraints(1, line, 1, 1, 100.0, 100.0, 13, 0, new Insets(2, 0, 2, 2), 0, 0));
        this._uOpts.add(lbl);
        this._uOpts.add(cbb);
        lbl = new OptLabel("DLG_OPT_VERIF_EXPR_ADDSOU").setParent(pcheck);
        root.add((Component)((Object)lbl), new GridBagConstraints(0, ++line, 1, 1, 100.0, 100.0, 17, 0, new Insets(2, 22, 2, 0), 0, 0));
        cbb = new OptComboBox(OPT_EXPR_ADDSOU).setParent(pcheck);
        root.add((Component)cbb, new GridBagConstraints(1, line, 1, 1, 100.0, 100.0, 13, 0, new Insets(2, 0, 2, 2), 0, 0));
        this._uOpts.add(lbl);
        this._uOpts.add(cbb);
        lbl = new OptLabel("DLG_OPT_VERIF_EXPR_MULDIV").setParent(pcheck);
        root.add((Component)((Object)lbl), new GridBagConstraints(0, ++line, 1, 1, 100.0, 100.0, 17, 0, new Insets(2, 22, 2, 0), 0, 0));
        cbb = new OptComboBox(OPT_EXPR_MULDIV).setParent(pcheck);
        root.add((Component)cbb, new GridBagConstraints(1, line, 1, 1, 100.0, 100.0, 13, 0, new Insets(2, 0, 2, 2), 0, 0));
        this._uOpts.add(lbl);
        this._uOpts.add(cbb);
        lbl = new OptLabel("DLG_OPT_VERIF_EXPR_MOD").setParent(pcheck);
        root.add((Component)((Object)lbl), new GridBagConstraints(0, ++line, 1, 1, 100.0, 100.0, 17, 0, new Insets(2, 22, 2, 0), 0, 0));
        cbb = new OptComboBox(OPT_EXPR_MOD).setParent(pcheck);
        root.add((Component)cbb, new GridBagConstraints(1, line, 1, 1, 100.0, 100.0, 13, 0, new Insets(2, 0, 2, 2), 0, 0));
        this._uOpts.add(lbl);
        this._uOpts.add(cbb);
        lbl = new OptLabel("DLG_OPT_VERIF_EXPR_MINMAX").setParent(pcheck);
        root.add((Component)((Object)lbl), new GridBagConstraints(0, ++line, 1, 1, 100.0, 100.0, 17, 0, new Insets(2, 22, 2, 0), 0, 0));
        cbb = new OptComboBox(OPT_EXPR_MINMAX).setParent(pcheck);
        root.add((Component)cbb, new GridBagConstraints(1, line, 1, 1, 100.0, 100.0, 13, 0, new Insets(2, 0, 2, 2), 0, 0));
        this._uOpts.add(lbl);
        this._uOpts.add(cbb);
        lbl = new OptLabel("DLG_OPT_VERIF_EXPR_CRD").setParent(pcheck);
        root.add((Component)((Object)lbl), new GridBagConstraints(0, ++line, 1, 1, 100.0, 100.0, 17, 0, new Insets(2, 22, 2, 0), 0, 0));
        cbb = new OptComboBox(OPT_EXPR_CRD).setParent(pcheck);
        root.add((Component)cbb, new GridBagConstraints(1, line, 1, 1, 100.0, 100.0, 13, 0, new Insets(2, 0, 2, 2), 0, 0));
        this._uOpts.add(lbl);
        this._uOpts.add(cbb);
        lbl = new OptLabel("DLG_OPT_VERIF_EXPR_STATE").setParent(pcheck);
        root.add((Component)((Object)lbl), new GridBagConstraints(0, ++line, 1, 1, 100.0, 100.0, 17, 0, new Insets(2, 22, 2, 0), 0, 0));
        cbb = new OptComboBox(OPT_EXPR_STATE).setParent(pcheck);
        root.add((Component)cbb, new GridBagConstraints(1, line, 1, 1, 100.0, 100.0, 13, 0, new Insets(2, 0, 2, 2), 0, 0));
        this._uOpts.add(lbl);
        this._uOpts.add(cbb);
        lbl = new OptLabel("DLG_OPT_VERIF_TRANS_CONFLICT");
        root.add((Component)((Object)lbl), new GridBagConstraints(0, ++line, 1, 1, 100.0, 100.0, 17, 0, new Insets(2, 2, 2, 0), 0, 0));
        cbb = new OptComboBox(OPT_TRANS_CONFLICT);
        root.add((Component)cbb, new GridBagConstraints(1, line, 1, 1, 100.0, 100.0, 13, 0, new Insets(2, 0, 2, 2), 0, 0));
        this._uOpts.add(lbl);
        this._uOpts.add(cbb);
        pcheck = new OptCheckBox("DLG_OPT_VERIF_GUARD", OPT_GUARD);
        root.add((Component)pcheck, new GridBagConstraints(0, ++line, 2, 1, 100.0, 100.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this._uOpts.add(pcheck);
        lbl = new OptLabel("DLG_OPT_VERIF_GUARD_WITHFLOW").setParent(pcheck);
        root.add((Component)((Object)lbl), new GridBagConstraints(0, ++line, 1, 1, 100.0, 100.0, 17, 0, new Insets(2, 22, 2, 0), 0, 0));
        cbb = new OptComboBox(OPT_GUARD_WITHFLOW).setParent(pcheck);
        root.add((Component)cbb, new GridBagConstraints(1, line, 1, 1, 100.0, 100.0, 13, 0, new Insets(2, 0, 2, 2), 0, 0));
        this._uOpts.add(lbl);
        this._uOpts.add(cbb);
        lbl = new OptLabel("DLG_OPT_VERIF_GUARD_TRUE").setParent(pcheck);
        root.add((Component)((Object)lbl), new GridBagConstraints(0, ++line, 1, 1, 100.0, 100.0, 17, 0, new Insets(2, 22, 2, 0), 0, 0));
        cbb = new OptComboBox(OPT_GUARD_TRUE).setParent(pcheck);
        root.add((Component)cbb, new GridBagConstraints(1, line, 1, 1, 100.0, 100.0, 13, 0, new Insets(2, 0, 2, 2), 0, 0));
        this._uOpts.add(lbl);
        this._uOpts.add(cbb);
        pcheck = new OptCheckBox("DLG_OPT_VERIF_SYNC", OPT_SYNC);
        root.add((Component)pcheck, new GridBagConstraints(0, ++line, 2, 1, 100.0, 100.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this._uOpts.add(pcheck);
        lbl = new OptLabel("DLG_OPT_VERIF_SYNC_SYNC").setParent(pcheck);
        root.add((Component)((Object)lbl), new GridBagConstraints(0, ++line, 1, 1, 100.0, 100.0, 17, 0, new Insets(2, 22, 2, 0), 0, 0));
        cbb = new OptComboBox(OPT_SYNC_SYNC).setParent(pcheck);
        root.add((Component)cbb, new GridBagConstraints(1, line, 1, 1, 100.0, 100.0, 13, 0, new Insets(2, 0, 2, 2), 0, 0));
        this._uOpts.add(lbl);
        this._uOpts.add(cbb);
        lbl = new OptLabel("DLG_OPT_VERIF_SYNC_DIFF").setParent(pcheck);
        root.add((Component)((Object)lbl), new GridBagConstraints(0, ++line, 1, 1, 100.0, 100.0, 17, 0, new Insets(2, 22, 2, 0), 0, 0));
        cbb = new OptComboBox(OPT_SYNC_DIFF).setParent(pcheck);
        root.add((Component)cbb, new GridBagConstraints(1, line, 1, 1, 100.0, 100.0, 13, 0, new Insets(2, 0, 2, 2), 0, 0));
        this._uOpts.add(lbl);
        this._uOpts.add(cbb);
        lbl = new OptLabel("DLG_OPT_VERIF_SYNC_CCF").setParent(pcheck);
        root.add((Component)((Object)lbl), new GridBagConstraints(0, ++line, 1, 1, 100.0, 100.0, 17, 0, new Insets(2, 22, 2, 0), 0, 0));
        cbb = new OptComboBox(OPT_SYNC_CCF).setParent(pcheck);
        root.add((Component)cbb, new GridBagConstraints(1, line, 1, 1, 100.0, 100.0, 13, 0, new Insets(2, 0, 2, 2), 0, 0));
        this._uOpts.add(lbl);
        this._uOpts.add(cbb);
        lbl = new OptLabel("DLG_OPT_VERIF_SYNC_SOME_SUB").setParent(pcheck);
        root.add((Component)((Object)lbl), new GridBagConstraints(0, ++line, 1, 1, 100.0, 100.0, 17, 0, new Insets(2, 22, 2, 0), 0, 0));
        cbb = new OptComboBox(OPT_SYNC_SOME_SUB).setParent(pcheck);
        root.add((Component)cbb, new GridBagConstraints(1, line, 1, 1, 100.0, 100.0, 13, 0, new Insets(2, 0, 2, 2), 0, 0));
        this._uOpts.add(lbl);
        this._uOpts.add(cbb);
        lbl = new OptLabel("DLG_OPT_VERIF_LOCALSIMUL");
        root.add((Component)((Object)lbl), new GridBagConstraints(0, ++line, 1, 1, 100.0, 100.0, 17, 0, new Insets(2, 0, 2, 0), 0, 0));
        OptComboBox pcbb = new OptComboBox(OPT_LOCALSIMUL);
        root.add((Component)pcbb, new GridBagConstraints(1, line, 1, 1, 100.0, 100.0, 13, 0, new Insets(2, 0, 2, 2), 0, 0));
        this._uOpts.add(lbl);
        this._uOpts.add(pcbb);
        check = new OptCheckBox("DLG_OPT_VERIF_LOCALSIMUL_STATIC", OPT_LOCALSIMUL_STATIC).setParent(pcbb);
        root.add((Component)check, new GridBagConstraints(0, ++line, 2, 1, 100.0, 100.0, 17, 0, new Insets(2, 22, 2, 2), 0, 0));
        this._uOpts.add(check);
        lbl = new OptLabel("DLG_OPT_VERIF_GENERATE_JAVA1");
        root.add((Component)((Object)lbl), new GridBagConstraints(0, ++line, 1, 1, 100.0, 100.0, 17, 0, new Insets(2, 0, 2, 0), 0, 0));
        pcbb = new OptComboBox(OPT_GENERATE_JAVA1);
        root.add((Component)pcbb, new GridBagConstraints(1, line, 1, 1, 100.0, 100.0, 13, 0, new Insets(2, 0, 2, 2), 0, 0));
        this._uOpts.add(lbl);
        this._uOpts.add(pcbb);
        lbl = new OptLabel("DLG_OPT_VERIF_LOOP");
        root.add((Component)((Object)lbl), new GridBagConstraints(0, ++line, 1, 1, 100.0, 100.0, 17, 0, new Insets(2, 2, 2, 0), 0, 0));
        cbb = new OptComboBox(OPT_LOOP);
        root.add((Component)cbb, new GridBagConstraints(1, line, 1, 1, 100.0, 100.0, 13, 0, new Insets(2, 0, 2, 2), 0, 0));
        this._uOpts.add(lbl);
        this._uOpts.add(cbb);
        pcheck = new OptCheckBox("DLG_OPT_VERIF_EVENT", OPT_EVENT);
        root.add((Component)pcheck, new GridBagConstraints(0, ++line, 2, 1, 100.0, 100.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this._uOpts.add(pcheck);
        lbl = new OptLabel("DLG_OPT_VERIF_EVENT_INSTANTANEOUS").setParent(pcheck);
        root.add((Component)((Object)lbl), new GridBagConstraints(0, ++line, 1, 1, 100.0, 100.0, 17, 0, new Insets(2, 22, 2, 0), 0, 0));
        cbb = new OptComboBox(OPT_EVENT_INSTANTANEOUS).setParent(pcheck);
        root.add((Component)cbb, new GridBagConstraints(1, line, 1, 1, 100.0, 100.0, 13, 0, new Insets(2, 0, 2, 2), 0, 0));
        this._uOpts.add(lbl);
        this._uOpts.add(cbb);
        lbl = new OptLabel("DLG_OPT_VERIF_EVENT_TEMPORISED").setParent(pcheck);
        root.add((Component)((Object)lbl), new GridBagConstraints(0, ++line, 1, 1, 100.0, 100.0, 17, 0, new Insets(2, 22, 2, 0), 0, 0));
        cbb = new OptComboBox(OPT_EVENT_TEMPORISED).setParent(pcheck);
        root.add((Component)cbb, new GridBagConstraints(1, line, 1, 1, 100.0, 100.0, 13, 0, new Insets(2, 0, 2, 2), 0, 0));
        this._uOpts.add(lbl);
        this._uOpts.add(cbb);
        lbl = new OptLabel("DLG_OPT_VERIF_EVENT_LAW").setParent(pcheck);
        root.add((Component)((Object)lbl), new GridBagConstraints(0, ++line, 1, 1, 100.0, 100.0, 17, 0, new Insets(2, 22, 2, 0), 0, 0));
        cbb = new OptComboBox(OPT_EVENT_LAW).setParent(pcheck);
        root.add((Component)cbb, new GridBagConstraints(1, line, 1, 1, 100.0, 100.0, 13, 0, new Insets(2, 0, 2, 2), 0, 0));
        this._uOpts.add(lbl);
        this._uOpts.add(cbb);
        pcheck = new OptCheckBox("DLG_OPT_VERIF_EXTERN", OPT_EXTERN);
        root.add((Component)pcheck, new GridBagConstraints(0, ++line, 2, 1, 100.0, 100.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this._uOpts.add(pcheck);
        lbl = new OptLabel("DLG_OPT_VERIF_EXTERN_LAW").setParent(pcheck);
        root.add((Component)((Object)lbl), new GridBagConstraints(0, ++line, 1, 1, 100.0, 100.0, 17, 0, new Insets(2, 22, 2, 0), 0, 0));
        pcbb = new OptComboBox(OPT_EXTERN_LAW).setParent(pcheck);
        root.add((Component)pcbb, new GridBagConstraints(1, line, 1, 1, 100.0, 100.0, 13, 0, new Insets(2, 0, 2, 2), 0, 0));
        this._uOpts.add(lbl);
        this._uOpts.add(pcbb);
        check = new OptCheckBox("DLG_OPT_VERIF_EXTERN_LAW_ARL", OPT_EXTERN_LAW_ARL).setParent(pcbb);
        root.add((Component)check, new GridBagConstraints(0, ++line, 2, 1, 100.0, 100.0, 17, 0, new Insets(2, 42, 2, 2), 0, 0));
        this._uOpts.add(check);
        check = new OptCheckBox("DLG_OPT_VERIF_EXTERN_LAW_MOK", OPT_EXTERN_LAW_MOK).setParent(pcbb);
        root.add((Component)check, new GridBagConstraints(0, ++line, 2, 1, 100.0, 100.0, 17, 0, new Insets(2, 42, 2, 2), 0, 0));
        this._uOpts.add(check);
        lbl = new OptLabel("DLG_OPT_VERIF_EXTERN_PARAM").setParent(pcheck);
        root.add((Component)((Object)lbl), new GridBagConstraints(0, ++line, 1, 1, 100.0, 100.0, 17, 0, new Insets(2, 22, 2, 0), 0, 0));
        cbb = new OptComboBox(OPT_EXTERN_PARAM).setParent(pcheck);
        root.add((Component)cbb, new GridBagConstraints(1, line, 1, 1, 100.0, 100.0, 13, 0, new Insets(2, 0, 2, 2), 0, 0));
        this._uOpts.add(lbl);
        this._uOpts.add(cbb);
        lbl = new OptLabel("DLG_OPT_VERIF_EXTERN_ATTRIB").setParent(pcheck);
        root.add((Component)((Object)lbl), new GridBagConstraints(0, ++line, 1, 1, 100.0, 100.0, 17, 0, new Insets(2, 22, 2, 0), 0, 0));
        cbb = new OptComboBox(OPT_EXTERN_ATTRIB).setParent(pcheck);
        root.add((Component)cbb, new GridBagConstraints(1, line, 1, 1, 100.0, 100.0, 13, 0, new Insets(2, 0, 2, 2), 0, 0));
        this._uOpts.add(lbl);
        this._uOpts.add(cbb);
        lbl = new OptLabel("DLG_OPT_VERIF_EXTERN_NODEPROPERTY").setParent(pcheck);
        root.add((Component)((Object)lbl), new GridBagConstraints(0, ++line, 1, 1, 100.0, 100.0, 17, 0, new Insets(2, 22, 2, 0), 0, 0));
        cbb = new OptComboBox(OPT_EXTERN_NODEPROPERTY).setParent(pcheck);
        root.add((Component)cbb, new GridBagConstraints(1, line, 1, 1, 100.0, 100.0, 13, 0, new Insets(2, 0, 2, 2), 0, 0));
        this._uOpts.add(lbl);
        this._uOpts.add(cbb);
        lbl = new OptLabel("DLG_OPT_VERIF_EXTERN_PRIO").setParent(pcheck);
        root.add((Component)((Object)lbl), new GridBagConstraints(0, ++line, 1, 1, 100.0, 100.0, 17, 0, new Insets(2, 22, 2, 0), 0, 0));
        pcbb = new OptComboBox(OPT_EXTERN_PRIO).setParent(pcheck);
        root.add((Component)pcbb, new GridBagConstraints(1, line, 1, 1, 100.0, 100.0, 13, 0, new Insets(2, 0, 2, 2), 0, 0));
        this._uOpts.add(lbl);
        this._uOpts.add(pcbb);
        check = new OptCheckBox("DLG_OPT_VERIF_EXTERN_PRIO_DIRAC", OPT_EXTERN_PRIO_DIRAC).setParent(pcbb);
        root.add((Component)check, new GridBagConstraints(0, ++line, 2, 1, 100.0, 100.0, 17, 0, new Insets(2, 42, 2, 2), 0, 0));
        this._uOpts.add(check);
        lbl = new OptLabel("DLG_OPT_VERIF_EXTERN_REMARK").setParent(pcheck);
        root.add((Component)((Object)lbl), new GridBagConstraints(0, ++line, 1, 1, 100.0, 100.0, 17, 0, new Insets(2, 22, 2, 0), 0, 0));
        pcbb = new OptComboBox(OPT_EXTERN_REMARK).setParent(pcheck);
        root.add((Component)pcbb, new GridBagConstraints(1, line, 1, 1, 100.0, 100.0, 13, 0, new Insets(2, 0, 2, 2), 0, 0));
        this._uOpts.add(lbl);
        this._uOpts.add(pcbb);
        lbl = new OptLabel("DLG_OPT_VERIF_EXTERN_BUCKET").setParent(pcheck);
        root.add((Component)((Object)lbl), new GridBagConstraints(0, ++line, 1, 1, 100.0, 100.0, 17, 0, new Insets(2, 22, 2, 0), 0, 0));
        cbb = new OptComboBox(OPT_EXTERN_BUCKET).setParent(pcheck);
        root.add((Component)cbb, new GridBagConstraints(1, line, 1, 1, 100.0, 100.0, 13, 0, new Insets(2, 0, 2, 2), 0, 0));
        this._uOpts.add(lbl);
        this._uOpts.add(cbb);
        lbl = new OptLabel("DLG_OPT_VERIF_EXTERN_PREEMPTIBLE").setParent(pcheck);
        root.add((Component)((Object)lbl), new GridBagConstraints(0, ++line, 1, 1, 100.0, 100.0, 17, 0, new Insets(2, 22, 2, 0), 0, 0));
        cbb = new OptComboBox(OPT_EXTERN_PREEMPTIBLE).setParent(pcheck);
        root.add((Component)cbb, new GridBagConstraints(1, line, 1, 1, 100.0, 100.0, 13, 0, new Insets(2, 0, 2, 2), 0, 0));
        this._uOpts.add(lbl);
        this._uOpts.add(cbb);
        lbl = new OptLabel("DLG_OPT_VERIF_EXTERN_PROPERTY").setParent(pcheck);
        root.add((Component)((Object)lbl), new GridBagConstraints(0, ++line, 1, 1, 100.0, 100.0, 17, 0, new Insets(2, 22, 2, 0), 0, 0));
        cbb = new OptComboBox(OPT_EXTERN_PROPERTY).setParent(pcheck);
        root.add((Component)cbb, new GridBagConstraints(1, line, 1, 1, 100.0, 100.0, 13, 0, new Insets(2, 0, 2, 2), 0, 0));
        this._uOpts.add(lbl);
        this._uOpts.add(cbb);
        lbl = new OptLabel("DLG_OPT_VERIF_EXTERN_PREDICATE").setParent(pcheck);
        root.add((Component)((Object)lbl), new GridBagConstraints(0, ++line, 1, 1, 100.0, 100.0, 17, 0, new Insets(2, 22, 2, 0), 0, 0));
        cbb = new OptComboBox(OPT_EXTERN_PREDICATE).setParent(pcheck);
        root.add((Component)cbb, new GridBagConstraints(1, line, 1, 1, 100.0, 100.0, 13, 0, new Insets(2, 0, 2, 2), 0, 0));
        this._uOpts.add(lbl);
        this._uOpts.add(cbb);
        lbl = new OptLabel("DLG_OPT_VERIF_EXTERN_OBSERVER").setParent(pcheck);
        root.add((Component)((Object)lbl), new GridBagConstraints(0, ++line, 1, 1, 100.0, 100.0, 17, 0, new Insets(2, 22, 2, 0), 0, 0));
        cbb = new OptComboBox(OPT_EXTERN_OBSERVER).setParent(pcheck);
        root.add((Component)cbb, new GridBagConstraints(1, line, 1, 1, 100.0, 100.0, 13, 0, new Insets(2, 0, 2, 2), 0, 0));
        this._uOpts.add(lbl);
        this._uOpts.add(cbb);
        check = new OptCheckBox("DLG_OPT_MEC_FLATNESS", OPT_FLATNESS_MEC5);
        root.add((Component)check, new GridBagConstraints(0, ++line, 2, 1, 100.0, 100.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this._uOpts.add(check);
        ++line;
        this.add((Component)root, new GridBagConstraints(0, 0, 1, 1, 100.0, 100.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JButton defVal = new JButton(ResTrans.getString("DLG_DEFVALUE"));
        defVal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (UOpt uopt : TranslateOptions.this._uOpts) {
                    uopt.reset();
                }
            }
        });
        this.add((Component)defVal, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    public void prepareWith(Plugable launch) {
        this._launcher = launch;
        for (int i = 0; i < this._uOpts.size(); ++i) {
            this._uOpts.get(i).prepare();
        }
    }

    protected void refreshCtrl() {
        for (int i = 0; i < this._uOpts.size(); ++i) {
            this._uOpts.get(i).refresh();
        }
    }

    public Component getPanel() {
        return this;
    }

    public void trash() {
    }

    public String getInfo(String key) {
        return this._owner.getInfo(key);
    }

    public Icon getIcon(String key) {
        return this._owner.getIcon(key);
    }

    class OptCheckBox
    extends JCheckBox
    implements UOpt {
        String _opt;
        String _keyLbl;
        UOpt _parent;

        OptCheckBox(String keyLbl, String opt) {
            super(ResTrans.getString(keyLbl));
            this._opt = opt;
            this._keyLbl = keyLbl;
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TranslateOptions.this._launcher.setOption(OptCheckBox.this._opt, OptCheckBox.this.isSelected() ? "true" : "false");
                    TranslateOptions.this.refreshCtrl();
                }
            });
        }

        OptCheckBox setParent(UOpt parent) {
            this._parent = parent;
            return this;
        }

        @Override
        public void reset() {
            this.setSelected(true);
            TranslateOptions.this._launcher.setOption(this._opt, this.isSelected() ? "true" : "false");
            TranslateOptions.this.refreshCtrl();
        }

        @Override
        public void refresh() {
            if (this._parent != null) {
                this.setEnabled(this._parent.check());
            }
        }

        @Override
        public boolean check() {
            return this.isEnabled() && this.isSelected();
        }

        @Override
        public void prepare() {
            this.setSelected(PlugableUtility.getBoolOpt((Plugable)TranslateOptions.this._launcher, (String)this._opt, (boolean)true));
        }

        @Override
        public void updateLgg() {
            this.setText(ResTrans.getString(this._keyLbl));
        }
    }

    class OptLabel
    extends JCRLabel
    implements UOpt {
        String _keyLbl;
        UOpt _parent;

        OptLabel(String keyLbl) {
            super(ResTrans.getString(keyLbl));
            this._keyLbl = keyLbl;
        }

        OptLabel setParent(UOpt parent) {
            this._parent = parent;
            return this;
        }

        @Override
        public void reset() {
        }

        @Override
        public void refresh() {
            if (this._parent != null) {
                this.setEnabled(this._parent.check());
            }
        }

        @Override
        public boolean check() {
            return this.isEnabled();
        }

        @Override
        public void prepare() {
        }

        @Override
        public void updateLgg() {
            this.setText(ResTrans.getString(this._keyLbl));
        }
    }

    static interface UOpt {
        public void prepare();

        public void updateLgg();

        public void refresh();

        public boolean check();

        public void reset();
    }

    class OptComboBox
    extends JComboBox
    implements UOpt {
        String _opt;
        UOpt _parent;

        OptComboBox(String opt) {
            this._opt = opt;
            this.addItem(ResTrans.getString("DLG_OPT_VERIF_NONE"));
            this.addItem(ResTrans.getString("DLG_OPT_VERIF_WARNING"));
            this.addItem(ResTrans.getString("DLG_OPT_VERIF_ERROR"));
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int idx = OptComboBox.this.getSelectedIndex();
                    TranslateOptions.this._launcher.setOption(OptComboBox.this._opt, Integer.toString(idx));
                    TranslateOptions.this.refreshCtrl();
                }
            });
        }

        OptComboBox setParent(UOpt parent) {
            this._parent = parent;
            return this;
        }

        @Override
        public void reset() {
            this.setSelectedIndex(2);
            int idx = this.getSelectedIndex();
            TranslateOptions.this._launcher.setOption(this._opt, Integer.toString(idx));
            TranslateOptions.this.refreshCtrl();
        }

        @Override
        public void refresh() {
            if (this._parent != null) {
                this.setEnabled(this._parent.check());
            }
        }

        @Override
        public boolean check() {
            return this.isEnabled() && this.getSelectedIndex() > 0;
        }

        @Override
        public void prepare() {
            this.setSelectedIndex(TranslateOptions.getWarningOpt(TranslateOptions.this._launcher, this._opt, 2));
        }

        @Override
        public void updateLgg() {
        }
    }
}

