/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.translator;

import com.dassault.cecilia.core.plugin.DefaultIOParameters;
import com.dassault.cecilia.core.plugin.IOParameters;
import com.dassault.cecilia.core.plugin.PluginManager;
import com.dassault.cecilia.plugin.mbsa.translator.TranslateParameters;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class TranslateParametersIO
implements IOParameters {
    protected static final String KEY_TRANSLATOR = "translator";
    protected static final String KEY_FORMAT = "format";
    protected static final String KEY_PARAMS = "param";

    TranslateParametersIO() {
    }

    public void writeXML(Writer out, Object parameters, PluginManager launcher) throws IOException {
        if (parameters instanceof TranslateParameters) {
            TranslateParameters trans = (TranslateParameters)parameters;
            out.write("<");
            out.write(KEY_TRANSLATOR);
            out.write(" ");
            out.write(KEY_FORMAT);
            out.write("=\"");
            out.write(trans._format);
            if (trans._opts.size() == 0) {
                out.write("\"/>");
            } else {
                out.write("\">");
                Map<String, String> opts = trans.getOpts();
                for (Map.Entry<String, String> entry : opts.entrySet()) {
                    out.write("<");
                    out.write(KEY_PARAMS);
                    out.write(" key=\"");
                    out.write(DefaultIOParameters.toXML((String)entry.getKey()));
                    out.write("\" value=\"");
                    out.write(DefaultIOParameters.toXML((String)entry.getValue()));
                    out.write("\" />");
                }
                out.write("</");
                out.write(KEY_TRANSLATOR);
                out.write(">");
            }
        } else {
            throw new IOException("Unsupported object for " + this.getClass().getSimpleName());
        }
    }

    public Object readXML(Node node, PluginManager launcher) {
        if (node.getNodeType() != 1) {
            return null;
        }
        Element root = (Element)node;
        if (!root.getNodeName().equals(KEY_TRANSLATOR)) {
            return null;
        }
        Node frm = root.getAttributes().getNamedItem(KEY_FORMAT);
        if (frm == null) {
            return null;
        }
        NodeList list = root.getElementsByTagName(KEY_PARAMS);
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        for (int i = 0; i < list.getLength(); ++i) {
            Element param = (Element)list.item(i);
            Node key = param.getAttributes().getNamedItem("key");
            Node val = param.getAttributes().getNamedItem("value");
            params.put(DefaultIOParameters.fromXML((String)key.getNodeValue()), DefaultIOParameters.fromXML((String)val.getNodeValue()));
        }
        return new TranslateParameters(frm.getNodeValue(), params);
    }
}

