/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.lang.reflect.Executable;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionValueResolver;
import org.springframework.beans.factory.support.ConstructorResolver;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.ResolvableType;
import org.springframework.core.style.ToStringCreator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public final class RegisteredBean {
    private final ConfigurableListableBeanFactory beanFactory;
    private final Supplier<String> beanName;
    private final boolean generatedBeanName;
    private final Supplier<RootBeanDefinition> mergedBeanDefinition;
    @Nullable
    private final RegisteredBean parent;

    private RegisteredBean(ConfigurableListableBeanFactory beanFactory, Supplier<String> beanName, boolean generatedBeanName, Supplier<RootBeanDefinition> mergedBeanDefinition, @Nullable RegisteredBean parent) {
        this.beanFactory = beanFactory;
        this.beanName = beanName;
        this.generatedBeanName = generatedBeanName;
        this.mergedBeanDefinition = mergedBeanDefinition;
        this.parent = parent;
    }

    public static RegisteredBean of(ConfigurableListableBeanFactory beanFactory, String beanName) {
        Assert.notNull((Object)beanFactory, (String)"'beanFactory' must not be null");
        Assert.hasLength((String)beanName, (String)"'beanName' must not be empty");
        return new RegisteredBean(beanFactory, () -> beanName, false, () -> (RootBeanDefinition)beanFactory.getMergedBeanDefinition(beanName), null);
    }

    static RegisteredBean of(ConfigurableListableBeanFactory beanFactory, String beanName, RootBeanDefinition mbd) {
        return new RegisteredBean(beanFactory, () -> beanName, false, () -> mbd, null);
    }

    public static RegisteredBean ofInnerBean(RegisteredBean parent, BeanDefinitionHolder innerBean) {
        Assert.notNull((Object)innerBean, (String)"'innerBean' must not be null");
        return RegisteredBean.ofInnerBean(parent, innerBean.getBeanName(), innerBean.getBeanDefinition());
    }

    public static RegisteredBean ofInnerBean(RegisteredBean parent, BeanDefinition innerBeanDefinition) {
        return RegisteredBean.ofInnerBean(parent, null, innerBeanDefinition);
    }

    public static RegisteredBean ofInnerBean(RegisteredBean parent, @Nullable String innerBeanName, BeanDefinition innerBeanDefinition) {
        Assert.notNull((Object)parent, (String)"'parent' must not be null");
        Assert.notNull((Object)innerBeanDefinition, (String)"'innerBeanDefinition' must not be null");
        InnerBeanResolver resolver = new InnerBeanResolver(parent, innerBeanName, innerBeanDefinition);
        Supplier<String> beanName = StringUtils.hasLength((String)innerBeanName) ? () -> innerBeanName : resolver::resolveBeanName;
        return new RegisteredBean(parent.getBeanFactory(), beanName, innerBeanName == null, resolver::resolveMergedBeanDefinition, parent);
    }

    public String getBeanName() {
        return this.beanName.get();
    }

    public boolean isGeneratedBeanName() {
        return this.generatedBeanName;
    }

    public ConfigurableListableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public Class<?> getBeanClass() {
        return ClassUtils.getUserClass((Class)this.getBeanType().toClass());
    }

    public ResolvableType getBeanType() {
        return this.getMergedBeanDefinition().getResolvableType();
    }

    public RootBeanDefinition getMergedBeanDefinition() {
        return this.mergedBeanDefinition.get();
    }

    public boolean isInnerBean() {
        return this.parent != null;
    }

    @Nullable
    public RegisteredBean getParent() {
        return this.parent;
    }

    public Executable resolveConstructorOrFactoryMethod() {
        return new ConstructorResolver((AbstractAutowireCapableBeanFactory)((Object)this.getBeanFactory())).resolveConstructorOrFactoryMethod(this.getBeanName(), this.getMergedBeanDefinition());
    }

    @Nullable
    public Object resolveAutowiredArgument(DependencyDescriptor descriptor, TypeConverter typeConverter, Set<String> autowiredBeans) {
        return new ConstructorResolver((AbstractAutowireCapableBeanFactory)((Object)this.getBeanFactory())).resolveAutowiredArgument(descriptor, this.getBeanName(), autowiredBeans, typeConverter, true);
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("beanName", (Object)this.getBeanName()).append("mergedBeanDefinition", (Object)this.getMergedBeanDefinition()).toString();
    }

    private static class InnerBeanResolver {
        private final RegisteredBean parent;
        @Nullable
        private final String innerBeanName;
        private final BeanDefinition innerBeanDefinition;
        @Nullable
        private volatile String resolvedBeanName;

        InnerBeanResolver(RegisteredBean parent, @Nullable String innerBeanName, BeanDefinition innerBeanDefinition) {
            Assert.isInstanceOf(AbstractAutowireCapableBeanFactory.class, (Object)parent.getBeanFactory());
            this.parent = parent;
            this.innerBeanName = innerBeanName;
            this.innerBeanDefinition = innerBeanDefinition;
        }

        String resolveBeanName() {
            String resolvedBeanName = this.resolvedBeanName;
            if (resolvedBeanName != null) {
                return resolvedBeanName;
            }
            this.resolvedBeanName = resolvedBeanName = this.resolveInnerBean((beanName, mergedBeanDefinition) -> beanName);
            return resolvedBeanName;
        }

        RootBeanDefinition resolveMergedBeanDefinition() {
            return this.resolveInnerBean((beanName, mergedBeanDefinition) -> mergedBeanDefinition);
        }

        private <T> T resolveInnerBean(BiFunction<String, RootBeanDefinition, T> resolver) {
            BeanDefinitionValueResolver beanDefinitionValueResolver = new BeanDefinitionValueResolver((AbstractAutowireCapableBeanFactory)((Object)this.parent.getBeanFactory()), this.parent.getBeanName(), this.parent.getMergedBeanDefinition());
            return beanDefinitionValueResolver.resolveInnerBean(this.innerBeanName, this.innerBeanDefinition, resolver);
        }
    }
}

