/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.util;

import com.dassault.cecilia.lib.util.ControllableAction;

public class DefaultControllableProcess
implements ControllableAction {
    protected CtrlState _state;
    private Object _locker = new Object();
    private boolean _requestSuspend = false;
    private boolean _requestStop = false;

    public DefaultControllableProcess() {
        this._state = CtrlState.WAIT;
    }

    public void setState(CtrlState stt) {
        this._state = stt;
    }

    @Override
    public void requestSuspend() {
        this._requestSuspend = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSuspended() throws InterruptedException {
        Object object = this._locker;
        synchronized (object) {
            while (this._requestSuspend) {
                this._locker.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestResume() {
        this._requestSuspend = false;
        Object object = this._locker;
        synchronized (object) {
            this._locker.notifyAll();
        }
    }

    @Override
    public void requestStop() {
        this._requestStop = true;
        if (this._requestSuspend) {
            this.requestResume();
        }
    }

    public boolean checkStopped() {
        return this._requestStop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getInfo(String key) {
        if (key.equals("process.msg") || key.equals("process.msg.high")) {
            DefaultControllableProcess defaultControllableProcess = this;
            synchronized (defaultControllableProcess) {
                switch (this._state) {
                    case WAIT: {
                        return "Wait";
                    }
                    case INIT: {
                        return "Init";
                    }
                    case WORK: {
                        return "Work";
                    }
                    case FINISH: {
                        return "Finnish";
                    }
                    case MARK1: {
                        return "Mark1";
                    }
                    case MARK2: {
                        return "Mark2";
                    }
                }
            }
        }
        if (key.equals("process.p1000")) {
            return "-1";
        }
        return null;
    }

    public static enum CtrlState {
        WAIT,
        INIT,
        WORK,
        FINISH,
        MARK1,
        MARK2;

    }
}

