/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.util;

import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.lib.util.io.FileUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class ImageIconSVGRendererPanel
extends JPanel {
    public ImageIconSVGRendererPanel() {
        super(new GridBagLayout());
    }

    public int loadFiles(Collection<File> files) {
        this.removeAll();
        int y = 0;
        for (File child : files) {
            try {
                URL url = child.toURI().toURL();
                int posX = 0;
                for (int size : Arrays.asList(16, 20, 32)) {
                    Image img = ResIcoAbstract.getImageRes(url, size);
                    if (img == null) {
                        throw new Exception();
                    }
                    JButton butEnable = new JButton(new ImageIcon(img));
                    butEnable.setEnabled(true);
                    butEnable.setMargin(new Insets(0, 0, 0, 0));
                    this.add((Component)butEnable, new GridBagConstraints(posX++, y, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
                    JButton butDisable = new JButton(new ImageIcon(img));
                    butDisable.setEnabled(false);
                    butDisable.setMargin(new Insets(0, 0, 0, 0));
                    this.add((Component)butDisable, new GridBagConstraints(posX++, y, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
                }
                this.add((Component)new JLabel(child.getName()), new GridBagConstraints(posX++, y, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
                ++y;
            }
            catch (Exception e) {
                System.out.println("Exception durant la lecture de " + child);
            }
        }
        return y;
    }

    public JToolBar createToolBar(Collection<File> files) {
        JToolBar toolBar = new JToolBar(files.iterator().next().getParent());
        for (File child : files) {
            try {
                URL url = child.toURI().toURL();
                Image img = ResIcoAbstract.getImageRes(url, 20);
                if (img == null) {
                    throw new Exception();
                }
                JButton butEnable = new JButton(new ImageIcon(img));
                butEnable.setEnabled(true);
                butEnable.setMargin(new Insets(0, 0, 0, 0));
                toolBar.add(new JButton(new ImageIcon(img)));
            }
            catch (Exception e) {
                System.out.println("Exception durant la lecture de " + child);
            }
        }
        return toolBar;
    }

    public static void main(String[] args) {
        File dirFile;
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        JFileChooser dlgFile = new JFileChooser(".");
        dlgFile.setFileSelectionMode(1);
        if (dlgFile.showOpenDialog(null) == 0 && (dirFile = dlgFile.getSelectedFile()) != null && dirFile.isDirectory()) {
            File[] children = dirFile.listFiles();
            TreeMap<String, File> svgChildren = new TreeMap<String, File>();
            for (File child : children) {
                if (!FileUtility.getFileExt(child.getAbsolutePath()).toLowerCase().equals(".svg")) continue;
                svgChildren.put(child.getName(), child);
            }
            ImageIconSVGRendererPanel panel = new ImageIconSVGRendererPanel();
            if (panel.loadFiles(svgChildren.values()) != 0) {
                JFrame frame = new JFrame("SVGRenderer: " + dirFile.getName());
                frame.getContentPane().setLayout(new BorderLayout());
                frame.getContentPane().add((Component)panel.createToolBar(svgChildren.values()), "North");
                frame.getContentPane().add((Component)new JScrollPane(panel), "Center");
                frame.pack();
                frame.setDefaultCloseOperation(3);
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
                return;
            }
        }
        System.exit(-1);
    }
}

