/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.util;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ResMsgAbstract {
    public static final String PROP_TRACE_RES = "cecilia.dvpt.TraceResources";
    protected ResourceBundle _resBundle = null;
    protected Locale _lgg = null;
    private final Object _resMutex = new Object();

    protected ResMsgAbstract() {
    }

    protected abstract String getIDKey();

    protected abstract ResourceBundle createBundle(Locale var1);

    public String getResourceName() {
        return this.getClass().getPackage().getName() + ".Resources";
    }

    protected void update(Locale lgg) {
        if (lgg == null) {
            String sysLgg = System.getProperty("user.language");
            if (sysLgg != null) {
                lgg = new Locale(sysLgg);
            }
            if (lgg == null) {
                lgg = Locale.getDefault();
            }
        }
        if (this._lgg == null || !this._lgg.equals(lgg)) {
            this._lgg = lgg;
            this._resBundle = this.createBundle(this._lgg);
        }
        if (this._resBundle == null) {
            Logger.getLogger(this.getClass().getPackage().getName()).log(Level.WARNING, "Internal error during update ressource : " + this.getClass().getName());
            this._resBundle = ResourceBundle.getBundle(this.getResourceName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getPrivateString(String key) {
        if (this._resBundle == null) {
            Object object = this._resMutex;
            synchronized (object) {
                this.update(null);
            }
        }
        try {
            return this._resBundle.getString(key);
        }
        catch (MissingResourceException e) {
            Logger.getLogger(this.getClass().getPackage().getName()).severe(e.getMessage());
            return null;
        }
    }

    protected String getKeyString(String key) {
        if (Boolean.getBoolean(PROP_TRACE_RES)) {
            String res = this.getPrivateString(key);
            StringBuilder sb = new StringBuilder(res.length() + 5);
            if (res.length() > 6 && res.substring(0, 6).toLowerCase().equals("<html>")) {
                sb.append(res.substring(0, 6)).append(this.getIDKey()).append(":").append(res.substring(6));
            } else {
                sb.append(this.getIDKey()).append(":").append(res);
            }
            return sb.toString();
        }
        return this.getPrivateString(key);
    }

    public String getMsg(String key) {
        try {
            return this.getKeyString(key);
        }
        catch (MissingResourceException expt) {
            StringBuilder sb = new StringBuilder(key.length() + 5);
            if (Boolean.getBoolean(PROP_TRACE_RES)) {
                sb.append(this.getIDKey()).append(":");
            }
            sb.append("[").append(key).append("]");
            return sb.toString();
        }
    }

    public String formatMsg(String idPattern, Object ... arguments) {
        String msgPattern = this.getMsg(idPattern);
        try {
            return MessageFormat.format(msgPattern, arguments);
        }
        catch (Throwable thrown) {
            StringBuffer sb = new StringBuffer(256);
            sb.append("Error during MessageFormat.format(");
            sb.append("\"").append(msgPattern).append("\"");
            for (int i = 0; i < arguments.length; ++i) {
                sb.append(", ").append(arguments[i]);
            }
            sb.append(") <= ").append(idPattern);
            Logger.getLogger(this.getClass().getPackage().getName()).log(Level.WARNING, sb.toString(), thrown);
            return msgPattern;
        }
    }
}

