/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.util;

import com.dassault.cecilia.lib.util.xmlparser.SAXExtendedHandler;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.StringTokenizer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.xml.sax.Locator;
import org.xml.sax.helpers.DefaultHandler;

public class TestUtility {
    public static final String PROP_JUNIT_JENKINS = "cecilia.junit.jenkins";
    protected static final boolean _TRACE = false;
    protected static boolean __WIN = System.getProperty("os.name").contains("Win");
    protected static String XML_DEFINE = "<?xml version='1.0'?>\n";

    protected static void trace(String msg) {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    protected String getBasePath(Class<?> define) {
        String nameRes = define.getName().replace('.', '/') + ".class";
        URL url = define.getClassLoader().getResource(nameRes);
        if (url == null) {
            Assert.fail((String)("Don't find url of class : " + define.getName()));
        }
        try {
            int pos;
            String urlStr = URLDecoder.decode(url.toString(), "UTF-8");
            if (urlStr.startsWith("file:/") && (pos = urlStr.lastIndexOf(define.getSimpleName() + ".class")) != -1) {
                return urlStr.substring(__WIN ? 6 : 5, pos);
            }
            Assert.fail((String)("Don't support url : " + urlStr));
        }
        catch (UnsupportedEncodingException e) {
            Assert.fail((String)("UnsupportedEncodingException " + e.getMessage()));
        }
        return null;
    }

    protected String constructBasePath(String pathName, String fileName) {
        StringBuffer sb = new StringBuffer(256);
        sb.append(this.getBasePath(this.getClass()));
        if (pathName != null && pathName.length() > 0) {
            sb.append(pathName).append("/");
        }
        sb.append(fileName);
        return sb.toString();
    }

    protected void printResult(String out) {
        StringTokenizer st = new StringTokenizer(out, "\n");
        while (st.hasMoreTokens()) {
            System.out.print("\"");
            System.out.print(st.nextToken());
            if (st.hasMoreTokens()) {
                System.out.println("\\n\" +");
                continue;
            }
            System.out.println("\\n\"");
        }
    }

    protected void traceOutput(String out, File ref) throws Throwable {
        if (out.length() < 10000) {
            System.out.println(out);
        } else {
            FileWriter writer = new FileWriter(ref);
            writer.write(out);
            writer.close();
        }
    }

    protected void readXml(InputStream input, SAXExtendedHandler handler) throws IOException {
        try {
            SAXParserFactory fabrique = SAXParserFactory.newInstance();
            SAXParser parseur = fabrique.newSAXParser();
            parseur.parse(input, (DefaultHandler)handler);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            StringBuffer sb = new StringBuffer();
            sb.append("Error during XML flow reading\n");
            Locator loc = handler.getLocator();
            if (loc != null) {
                sb.append("in [line = ");
                sb.append(loc.getLineNumber());
                sb.append("] [col = ");
                sb.append(loc.getColumnNumber());
                sb.append("]\n");
            }
            sb.append(e.getMessage());
            throw new IOException(sb.toString(), e);
        }
    }

    protected String readResourceStream(InputStream resourceAsStream) throws IOException {
        return this.readResourceStream(resourceAsStream, StandardCharsets.ISO_8859_1);
    }

    protected String readResourceStream(InputStream resourceAsStream, Charset cs) throws IOException {
        int len;
        StringBuilder writeBuffer = new StringBuilder(2048);
        InputStreamReader reader = new InputStreamReader(resourceAsStream, cs);
        char[] readBuffer = new char[1024];
        while ((len = reader.read(readBuffer)) != -1) {
            writeBuffer.append(readBuffer, 0, len);
        }
        return writeBuffer.toString();
    }
}

