/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.util.destination;

import com.dassault.cecilia.lib.util.destination.Destination;
import com.dassault.cecilia.lib.util.destination.Failure;
import com.dassault.cecilia.lib.util.destination.Layout;
import com.dassault.cecilia.lib.util.destination.Record;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DestinationRecord
extends Destination {
    private List<String> _records;
    private int _limit;

    public DestinationRecord() {
        this(-1, null);
    }

    public DestinationRecord(int limit) {
        this(limit, null);
    }

    public DestinationRecord(int limit, Layout layout) {
        this._limit = limit;
        this._records = new ArrayList<String>();
        if (layout != null) {
            this.setLayout(layout);
        }
    }

    @Override
    public void configure(Map<String, Object> params, Layout layout) {
        String param = (String)params.get("Limit");
        if (param != null) {
            try {
                this._limit = Integer.parseInt(param);
            }
            catch (NumberFormatException e) {
                Failure.OPEN.report(e);
            }
        } else {
            this._limit = -1;
        }
        super.configure(params, layout);
    }

    @Override
    public void publish(Record record) {
        String msg;
        if (!this.isAcceptable(record)) {
            return;
        }
        try {
            msg = this.getLayout().format(record);
        }
        catch (Exception ex) {
            Logger.getLogger(DestinationRecord.class.getPackage().getName()).log(Level.SEVERE, "Internal error during format", ex);
            ex.printStackTrace();
            Failure.FORMAT.report(ex);
            return;
        }
        if (msg == null || msg.length() == 0) {
            return;
        }
        try {
            this._records.add(msg);
        }
        catch (Exception ex) {
            Failure.WRITE.report(ex);
        }
    }

    @Override
    public boolean isAcceptable(Record record) {
        if (record == null) {
            return false;
        }
        if (this._limit >= 0 && this._records.size() >= this._limit) {
            return false;
        }
        return super.isAcceptable(record);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    public List<String> getRecords() {
        return this._records;
    }

    public int getNbrRecord() {
        return this._records.size();
    }
}

