/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.util.destination;

import com.dassault.cecilia.lib.util.destination.Destination;
import com.dassault.cecilia.lib.util.destination.Failure;
import com.dassault.cecilia.lib.util.destination.Layout;
import com.dassault.cecilia.lib.util.destination.Record;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class DestinationStream
extends Destination {
    private OutputStream _output;
    private boolean _doneHeader;
    protected Writer _writer;

    protected DestinationStream() {
    }

    public DestinationStream(OutputStream out, Layout layout) {
        this.setLayout(layout);
        this.setOutputStream(out);
    }

    protected void setOutputStream(OutputStream out) {
        if (out == null) {
            throw new NullPointerException();
        }
        this.flushAndClose();
        this._output = out;
        this._doneHeader = false;
        String encoding = this.getEncoding();
        if (encoding == null) {
            this._writer = new OutputStreamWriter(this._output);
        } else {
            try {
                this._writer = new OutputStreamWriter(this._output, encoding);
            }
            catch (UnsupportedEncodingException ex) {
                throw new Error("Unexpected exception " + ex);
            }
        }
    }

    @Override
    public void publish(Record record) {
        String msg;
        if (!this.isAcceptable(record)) {
            return;
        }
        try {
            msg = this.getLayout().format(record);
        }
        catch (Exception ex) {
            Failure.FORMAT.report(ex);
            return;
        }
        if (msg == null || msg.length() == 0) {
            return;
        }
        try {
            if (!this._doneHeader) {
                this._writer.write(this.getLayout().getHead(this));
                this._doneHeader = true;
            }
            this._writer.write(msg);
        }
        catch (Exception ex) {
            Failure.WRITE.report(ex);
        }
    }

    @Override
    public boolean isAcceptable(Record record) {
        if (this._writer == null || record == null) {
            return false;
        }
        return super.isAcceptable(record);
    }

    @Override
    public void flush() {
        if (this._writer != null) {
            try {
                this._writer.flush();
            }
            catch (Exception ex) {
                Failure.FLUSH.report(ex);
            }
        }
    }

    @Override
    public void close() {
        this.flushAndClose();
    }

    protected void finnishStream() {
        if (this._doneHeader && this._writer != null) {
            try {
                this._writer.write(this.getLayout().getTail(this));
                this._writer.flush();
            }
            catch (Exception ex) {
                Failure.CLOSE.report(ex);
            }
        }
    }

    private void flushAndClose() {
        if (this._writer != null) {
            this.finnishStream();
            try {
                this._writer.close();
            }
            catch (Exception ex) {
                Failure.CLOSE.report(ex);
            }
            this._writer = null;
            this._output = null;
        }
    }
}

