/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.util.diff;

import com.dassault.cecilia.lib.util.diff.DiffFile;
import com.dassault.cecilia.lib.util.diff.DiffRecord;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;

public class DiffFileToken
extends DiffFile {
    RedirectReader _redirectIn = new RedirectReader();
    RedirectReader _redirectOut = new RedirectReader();
    StreamTokenizer _tokIn = new StreamTokenizer(this._redirectIn);
    StreamTokenizer _tokOut = new StreamTokenizer(this._redirectOut);

    public DiffFileToken(File input, File output) {
        super(input, output);
    }

    public StreamTokenizer getInTokenizer() {
        return this._tokIn;
    }

    public StreamTokenizer getOutTokenizer() {
        return this._tokOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean compare() throws IOException {
        BufferedReader in = null;
        BufferedReader out = null;
        IOException exc = null;
        try {
            int tIn;
            in = new BufferedReader(new FileReader(this._input1));
            out = new BufferedReader(new FileReader(this._input2));
            this._redirectIn.setReader(in);
            this._redirectOut.setReader(out);
            while (!this.withDiff()) {
                DiffRecord rec;
                int tOut;
                tIn = this._tokIn.nextToken();
                if (tIn == (tOut = this._tokOut.nextToken())) {
                    if (tIn == -1) break;
                    if (tIn == -3) {
                        if (this._tokIn.sval.equals(this._tokOut.sval)) continue;
                        rec = new DiffRecord(this._tokIn.lineno(), "Token Diff [Word] : ");
                        rec.setMsg1(this._tokIn.sval);
                        rec.setMsg2(this._tokOut.sval);
                        this.addRecord(rec);
                        continue;
                    }
                    if (tIn != -2 || this._tokIn.nval == this._tokOut.nval) continue;
                    rec = new DiffRecord(this._tokIn.lineno(), "Token Diff [Number] : ");
                    rec.setMsg1("n=" + this._tokIn.nval);
                    rec.setMsg2("n=" + this._tokOut.nval);
                    this.addRecord(rec);
                    continue;
                }
                rec = new DiffRecord(this._tokIn.lineno(), "Token Diff [Token] : ");
                switch (tIn) {
                    case -1: {
                        rec.setMsg1("EOF");
                        break;
                    }
                    case 10: {
                        rec.setMsg1("EOL");
                        break;
                    }
                    case -3: {
                        rec.setMsg1(this._tokIn.sval);
                        break;
                    }
                    case -2: {
                        rec.setMsg1("n=" + this._tokIn.nval);
                        break;
                    }
                    default: {
                        rec.setMsg1("'" + (char)tIn + "'");
                    }
                }
                switch (tOut) {
                    case -1: {
                        rec.setMsg2("EOF");
                        break;
                    }
                    case 10: {
                        rec.setMsg2("EOL");
                        break;
                    }
                    case -3: {
                        rec.setMsg2(this._tokOut.sval);
                        break;
                    }
                    case -2: {
                        rec.setMsg2("n=" + this._tokOut.nval);
                        break;
                    }
                    default: {
                        rec.setMsg2("'" + (char)tOut + "'");
                    }
                }
                this.addRecord(rec);
            }
            tIn = !this.withDiff() ? 1 : 0;
            return tIn != 0;
        }
        catch (IOException e) {
            if (exc == null) {
                exc = e;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            block37: {
                block36: {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            if (exc != null) break block36;
                            exc = e;
                        }
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        if (exc != null) break block37;
                        exc = e;
                    }
                }
            }
            this.close();
            if (exc != null) {
                throw exc;
            }
        }
    }

    class RedirectReader
    extends Reader {
        Reader _redirect = null;

        public void setReader(Reader read) {
            this._redirect = read;
        }

        @Override
        public void close() throws IOException {
            if (this._redirect == null) {
                throw new IOException("Redirect file null");
            }
            this._redirect.close();
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            if (this._redirect == null) {
                throw new IOException("Redirect file null");
            }
            return this._redirect.read(cbuf, off, len);
        }
    }
}

