/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.util.diff;

import com.dassault.cecilia.lib.util.destination.Destination;
import com.dassault.cecilia.lib.util.destination.Layout;
import com.dassault.cecilia.lib.util.destination.Record;
import com.dassault.cecilia.lib.util.diff.DiffRecDefine;
import com.dassault.cecilia.lib.util.diff.DiffRecord;
import java.util.Map;

public class DiffLayoutXML
extends Layout {
    boolean _displayHeader = true;

    @Override
    public String format(Record rec) {
        if (rec instanceof DiffRecord) {
            DiffRecord record = (DiffRecord)rec;
            StringBuffer sb = new StringBuffer(128);
            sb.append("<record>\n");
            int line = record.getLine();
            if (line >= 0) {
                sb.append("  <line>");
                sb.append(line);
                sb.append("</line>\n");
            }
            sb.append("  <header>");
            this.escapeXML(sb, record.getHeader());
            sb.append("</header>\n");
            sb.append("  <compare>");
            sb.append(record.getCompare());
            sb.append("</compare>\n");
            String msg = record.getMsg1();
            if (msg != null) {
                sb.append("  <msg1>");
                this.escapeXML(sb, msg);
                sb.append("</msg1>\n");
            }
            if ((msg = record.getMsg2()) != null) {
                sb.append("  <msg2>");
                this.escapeXML(sb, msg);
                sb.append("</msg2>\n");
            }
            sb.append("</record>\n");
            return sb.toString();
        }
        if (rec instanceof DiffRecDefine) {
            if (this._displayHeader) {
                String stream;
                DiffRecDefine define = (DiffRecDefine)rec;
                StringBuffer sb = new StringBuffer(128);
                sb.append("<define>\n");
                String msg = define.getHeader();
                if (msg != null) {
                    sb.append("  <header>");
                    this.escapeXML(sb, msg);
                    sb.append("</header>\n");
                }
                if ((stream = define.getDesc1()) != null) {
                    sb.append("  <stream1>");
                    this.escapeXML(sb, stream);
                    sb.append("</stream1>\n");
                }
                if ((stream = define.getDesc2()) != null) {
                    sb.append("  <stream2>");
                    this.escapeXML(sb, stream);
                    sb.append("</stream2>\n");
                }
                sb.append("</define>\n");
                return sb.toString();
            }
            return "";
        }
        throw new RuntimeException("Record unknow");
    }

    @Override
    public String getHead(Destination destination) {
        StringBuffer sb = new StringBuffer(128);
        this.prepareHeadXML(sb, destination);
        sb.append("<diff>\n");
        return sb.toString();
    }

    @Override
    public String getTail(Destination destination) {
        return "</diff>\n";
    }

    @Override
    public void configure(Map<String, String> params) {
        String header = params.get("Header");
        if (header != null) {
            this._displayHeader = Boolean.parseBoolean(header);
        }
    }
}

