/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.util.io;

import com.dassault.cecilia.lib.util.TestUtility;
import com.dassault.cecilia.lib.util.io.CRCWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Writer;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import org.junit.Assert;
import org.junit.Test;

public class CRCWriterTest
extends TestUtility {
    private static String getCRCFile(File input) throws NoSuchAlgorithmException, IOException {
        CRCWriter writer = new CRCWriter(new NullWriter());
        BufferedReader reader = new BufferedReader(new FileReader(input));
        char[] read = new char[128];
        int len = 128;
        while ((len = reader.read(read)) > 0) {
            writer.write(read, 0, len);
        }
        writer.flush();
        writer.close();
        reader.close();
        return writer.getCRC();
    }

    @Test
    public void testWriterEmpty() throws NoSuchAlgorithmException, IOException {
        CRCWriter writer = new CRCWriter(new NullWriter());
        writer.flush();
        writer.close();
        Assert.assertEquals((Object)"D41D8CD98F00B204E9800998ECF8427E", (Object)writer.getCRC());
    }

    @Test
    public void testWriterTomtom() throws NoSuchAlgorithmException, IOException {
        CRCWriter writer = new CRCWriter(new NullWriter());
        writer.write("tomtom");
        writer.flush();
        writer.close();
        Assert.assertEquals((Object)"DBF2641B360D20ED942A79B59D0CD5BD", (Object)writer.getCRC());
    }

    @Test
    public void testWriterFFT1439File1() throws NoSuchAlgorithmException, IOException, URISyntaxException {
        File input = new File(this.getClass().getResource("CRCWriterFile1.ara").toURI());
        Assert.assertEquals((Object)"2BAB91FCA15EBA5B6078B21930A40B14", (Object)CRCWriterTest.getCRCFile(input));
    }

    @Test
    public void testWriterFFT1439File2() throws NoSuchAlgorithmException, IOException, URISyntaxException {
        File input = new File(this.getClass().getResource("CRCWriterFile2.ara").toURI());
        Assert.assertEquals((Object)"27B9B84417FBF7D2119B927E94E25F1F", (Object)CRCWriterTest.getCRCFile(input));
    }

    static class NullWriter
    extends Writer {
        NullWriter() {
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

