/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.util.io;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.CharBuffer;

public class ConsumerReader
extends Reader {
    Writer _writer;
    Reader _delegate;

    public ConsumerReader(Reader reader, Writer writer) {
        this._delegate = reader;
        this._writer = writer;
    }

    @Override
    public void close() throws IOException {
        this._delegate.close();
        this._writer.flush();
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this._delegate.mark(readAheadLimit);
    }

    @Override
    public boolean markSupported() {
        return this._delegate.markSupported();
    }

    @Override
    public int read() throws IOException {
        int result = this._delegate.read();
        this._writer.write(result);
        return result;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int result = this._delegate.read(cbuf, off, len);
        if (result > 0) {
            this._writer.write(cbuf, off, result);
        }
        return result;
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        int result = this._delegate.read(cbuf);
        this._writer.write(cbuf, 0, result);
        return result;
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        int len = target.remaining();
        char[] cbuf = new char[len];
        int result = this.read(cbuf, 0, len);
        if (result > 0) {
            target.put(cbuf, 0, result);
            this._writer.write(cbuf, 0, result);
        }
        return result;
    }

    @Override
    public boolean ready() throws IOException {
        return this._delegate.ready();
    }

    @Override
    public void reset() throws IOException {
        this._delegate.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this._delegate.skip(n);
    }

    public String toString() {
        return this._delegate.toString();
    }
}

