/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.util.io;

import java.io.IOException;
import java.io.Writer;

public class LimitedWriter
extends Writer {
    Writer _delegate;
    int _size;
    int _limit;
    boolean _throwException;

    public LimitedWriter(Writer delegate, int limit) {
        this(delegate, limit, false);
    }

    public LimitedWriter(Writer delegate, int limit, boolean throwException) {
        this._delegate = delegate;
        this._size = 0;
        this._limit = limit;
        this._throwException = throwException;
    }

    public boolean isFull() {
        return this._size >= this._limit;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this._size > this._limit) {
            if (this._throwException) {
                throw new IOException("Limit size exceed");
            }
            return;
        }
        int nlen = Math.min(len, this._limit - this._size);
        this._delegate.write(cbuf, off, nlen);
        this._size += nlen;
        if (nlen != len && this._throwException) {
            throw new IOException("Limit size exceed");
        }
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        if (this._size > this._limit) {
            if (this._throwException) {
                throw new IOException("Limit size exceed");
            }
            return;
        }
        int nlen = Math.min(len, this._limit - this._size);
        this._delegate.write(str, off, nlen);
        this._size += nlen;
        if (nlen != len && this._throwException) {
            throw new IOException("Limit size exceed");
        }
    }

    @Override
    public void write(String str) throws IOException {
        int len = str.length();
        int nlen = Math.min(len, this._limit - this._size);
        this.write(str, 0, nlen);
        if (nlen != len && this._throwException) {
            throw new IOException("Limit size exceed");
        }
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        int len = cbuf.length;
        int nlen = Math.min(len, this._limit - this._size);
        this.write(cbuf, 0, nlen);
        if (nlen != len && this._throwException) {
            throw new IOException("Limit size exceed");
        }
    }

    @Override
    public void write(int c) throws IOException {
        if (this._size > this._limit) {
            if (this._throwException) {
                throw new IOException("Limit size exceed");
            }
            return;
        }
        super.write(c);
        ++this._size;
        if (this._size > this._limit) {
            if (this._throwException) {
                throw new IOException("Limit size exceed");
            }
            return;
        }
    }

    @Override
    public void flush() throws IOException {
        this._delegate.flush();
    }

    @Override
    public void close() throws IOException {
        this._delegate.close();
    }
}

