/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.util.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogOutputStream
extends ByteArrayOutputStream {
    Logger _log;
    Level _level;
    String _header;

    public LogOutputStream(Logger log, Level level, String header) {
        this._log = log;
        this._level = level;
        this._header = header;
    }

    @Override
    public synchronized void write(int b) {
        super.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        super.write(b);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) {
        super.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        super.flush();
        String msg = super.toString();
        if (msg.trim().isEmpty()) {
            this._log.log(this._level, this._header + ": empty stream (no msg)");
        } else {
            StringBuilder buffer = new StringBuilder(msg.length() + 100);
            buffer.append(this._header).append("\n**************************************************\n");
            buffer.append(msg).append("\n**************************************************");
            this._log.log(this._level, buffer.toString());
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
    }
}

