/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.util.logging;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.swing.JFileChooser;

public class FilterResultLog {
    private static String SYNTAX = "Syntax : java -classpath ... " + FilterResultLog.class.getName() + " \n   [--input <input>]    \n   [-i <input>]         // input file\n   [--output <output>]  \n   [-o <output>]        // output file\n   [--stdout]           // console output\n   [--level <level>]    // \n   [--class <class>]    // \n   [--thread <thread>]  // \n   [--msg <msg>]    // \nIf input ou output not define, launch a system FileChooser.";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void filter(File[] inputFiles, Writer writer, Level level, String thread, String classPath, String msg) throws IOException {
        for (File inputFile : inputFiles) {
            if (inputFile.isDirectory()) {
                File[] childrenFiles = inputFile.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        if (file.isDirectory()) {
                            return true;
                        }
                        return file.getName().toUpperCase().endsWith(".LOG");
                    }
                });
                if (childrenFiles.length <= 0) continue;
                FilterResultLog.filter(childrenFiles, writer, level, thread, classPath, msg);
                continue;
            }
            writer.write("\n\n--- " + inputFile + "\n");
            try (BufferedReader input = null;){
                input = new BufferedReader(new FileReader(inputFile));
                FilterResultLog.filter(input, writer, level, thread, classPath, msg);
            }
        }
    }

    static void filter(BufferedReader input, Writer writer, Level level, String thread, String classPath, String msg) throws IOException {
        String line = null;
        while ((line = input.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(line + "#", " ");
            try {
                st.nextToken().trim();
                st.nextToken().trim();
                String line_level = st.nextToken().trim();
                String line_thread = st.nextToken("]").trim().substring(1);
                String line_class = st.nextToken(":").substring(1).trim();
                String line_msg = st.nextToken("#").substring(1).trim();
                if (level != null) {
                    try {
                        Level curLevel = Level.parse(line_level.toUpperCase());
                        if (curLevel.intValue() <= level.intValue()) {
                            continue;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (thread != null && line_thread.contains(thread) || classPath != null && line_class.contains(classPath) || msg != null && line_msg.contains(msg)) continue;
                writer.append(line).append("\n");
            }
            catch (Exception exception) {}
        }
    }

    public static void main(String[] args) {
        Writer writer = null;
        Level level = null;
        String thread = null;
        String classPath = null;
        String msg = null;
        File[] inputFiles = null;
        Object errorMsg = null;
        if (errorMsg == null) {
            for (int idx = 0; idx < args.length && errorMsg == null; ++idx) {
                if (args[idx].equals("--input") || args[idx].equals("-i")) {
                    if (++idx == args.length) {
                        errorMsg = "Number argument of '--input'";
                        continue;
                    }
                    inputFiles = new File[]{new File(args[idx])};
                    continue;
                }
                if (args[idx].equals("--output") || args[idx].equals("-o")) {
                    if (++idx == args.length) {
                        errorMsg = "Number argument of '--output'";
                        continue;
                    }
                    try {
                        writer = new FileWriter(args[idx]);
                    }
                    catch (IOException e) {
                        System.err.println(e.getMessage());
                        errorMsg = "Output exception";
                    }
                    continue;
                }
                if (args[idx].equals("--stdout")) {
                    writer = new OutputStreamWriter(System.out);
                    continue;
                }
                if (args[idx].equals("--level") || args[idx].equals("-l")) {
                    if (++idx == args.length) {
                        errorMsg = "Number argument of '--level'";
                        continue;
                    }
                    try {
                        Level read = Level.parse(args[idx].toUpperCase());
                        if (read != null) {
                            level = read;
                            continue;
                        }
                        errorMsg = "'level' format (must Log.Level values)";
                    }
                    catch (Exception e) {
                        errorMsg = "'level' format (must Log.Level values)";
                    }
                    continue;
                }
                if (args[idx].equals("--class") || args[idx].equals("-c")) {
                    if (++idx == args.length) {
                        errorMsg = "Number argument of '--class'";
                        continue;
                    }
                    classPath = args[idx];
                    continue;
                }
                if (args[idx].equals("--thread") || args[idx].equals("-t")) {
                    if (++idx == args.length) {
                        errorMsg = "Number argument of '--thread'";
                        continue;
                    }
                    thread = args[idx];
                    continue;
                }
                if (args[idx].equals("--msg") || args[idx].equals("-m")) {
                    if (++idx == args.length) {
                        errorMsg = "Number argument of '--msg'";
                        continue;
                    }
                    msg = args[idx];
                    continue;
                }
                if (args[idx].equals("--help")) {
                    System.out.println(SYNTAX);
                    System.exit(0);
                    continue;
                }
                errorMsg = "Unkown argument: " + args[idx];
            }
        }
        if (errorMsg == null) {
            JFileChooser dlg = null;
            if (inputFiles == null) {
                if (dlg == null) {
                    dlg = new JFileChooser();
                    dlg.setCurrentDirectory(new File("."));
                    dlg.setFileSelectionMode(2);
                }
                if (dlg.showOpenDialog(null) == 1) {
                    errorMsg = "Cancel input";
                } else {
                    inputFiles = dlg.getSelectedFiles();
                }
            }
            if (errorMsg == null && inputFiles == null) {
                errorMsg = "No input";
            }
            if (writer == null) {
                if (dlg == null) {
                    dlg = new JFileChooser();
                    dlg.setCurrentDirectory(new File("."));
                }
                if (dlg.showSaveDialog(null) == 1) {
                    errorMsg = "Cancel output";
                } else if (dlg.getSelectedFile() == null) {
                    errorMsg = "No select output";
                } else {
                    try {
                        writer = new FileWriter(dlg.getSelectedFile());
                    }
                    catch (IOException e) {
                        System.err.println(e.getMessage());
                        errorMsg = "Output exception";
                    }
                }
            }
            if (errorMsg == null && writer == null) {
                errorMsg = "No output";
            }
        }
        if (errorMsg == null) {
            try {
                FilterResultLog.filter(inputFiles, writer, level, thread, classPath, msg);
                writer.close();
                System.exit(0);
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
                System.exit(1);
            }
        } else {
            System.err.println((String)errorMsg);
            System.err.println();
            System.err.println(SYNTAX);
            System.exit(3);
        }
    }
}

