/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.util.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogUtility {
    public static Logger getLog(Class<?> cl) {
        return Logger.getLogger(cl.getPackage().getName());
    }

    public static void logStackTrace(Logger log, Level lvl, String mess) {
        LogUtility.logStackTrace(log, lvl, mess, 1, 5);
    }

    public static void logStackTrace(Logger log, Level lvl, String mess, int max) {
        LogUtility.logStackTrace(log, lvl, mess, 1, max + 1);
    }

    public static void logStackTrace(Logger log, Level lvl, String mess, int min, int max) {
        if (!log.isLoggable(lvl)) {
            return;
        }
        StringBuilder buf = new StringBuilder(mess.length() + (max - min + 1) * 80);
        buf.append(mess);
        LogUtility.bufStackTrace(null, buf, min + 2, max + 2);
        log.log(lvl, buf.toString());
    }

    public static void logException(Logger log, Level lvl, Throwable throwable, String mess, int min, int max) {
        if (!log.isLoggable(lvl)) {
            return;
        }
        StringBuilder buf = new StringBuilder(mess.length() + (max - min + 1) * 80);
        buf.append(mess);
        LogUtility.bufStackTrace(throwable, buf, min + 2, max + 2);
        log.log(lvl, buf.toString());
    }

    static void bufStackTrace(Throwable throwable, StringBuilder buf, int min, int max) {
        StringWriter out = new StringWriter();
        if (throwable == null) {
            throwable = new Throwable();
        }
        throwable.printStackTrace(new PrintWriter(out));
        StringTokenizer st = new StringTokenizer(out.toString(), "\n");
        for (int i = 0; i <= max && st.hasMoreTokens(); ++i) {
            String tok = st.nextToken();
            if (i < min) continue;
            if (i > max) break;
            buf.append(tok).append("\n");
        }
    }
}

