/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.util.xmlparser;

import com.dassault.cecilia.lib.util.xmlparser.SAXActionHandler;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class SAXExtendedHandler
extends DefaultHandler
implements SAXActionHandler {
    LinkedList<XElement> _lifo = new LinkedList();
    Locator _locator;
    boolean _firstElement = true;

    public SAXExtendedHandler() {
    }

    public SAXExtendedHandler(Locator locator) {
        this._locator = locator;
    }

    protected void setLocator(Locator locator) {
        this._locator = locator;
    }

    public Locator getLocator() {
        return this._locator;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.setLocator(locator);
        super.setDocumentLocator(locator);
    }

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        XElement elem = new XElement(sName, qName, attrs);
        this._lifo.addLast(elem);
        this.startAction(elem._name, elem._attrs, this._firstElement);
        this._firstElement = false;
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        XElement elem = this._lifo.removeLast();
        this.endAction(elem._name, elem._attrs, elem._text == null ? "" : elem._text.toString());
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        String s = new String(buf, offset, len);
        XElement elem = this._lifo.getLast();
        if (elem._text == null) {
            elem._text = new StringBuilder(s);
        } else {
            elem._text.append(s);
        }
    }

    @Override
    public void ignorableWhitespace(char[] buf, int offset, int len) throws SAXException {
        String s = new String(buf, offset, len);
        XElement elem = this._lifo.getLast();
        if (elem._text == null) {
            elem._text = new StringBuilder(s);
        } else {
            elem._text.append(s);
        }
    }

    protected boolean findParent(String name) {
        ListIterator<XElement> iElem = this._lifo.listIterator(this._lifo.size() - 1);
        while (iElem.hasPrevious()) {
            if (!iElem.previous()._name.equals(name)) continue;
            return true;
        }
        return false;
    }

    public static <T extends Enum<T>> T valueOfEnum(Class<T> enumType, String name) {
        if (name == null) {
            return null;
        }
        try {
            return Enum.valueOf(enumType, name);
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    static class XElement {
        String _name;
        Map<String, String> _attrs = new LinkedHashMap<String, String>();
        StringBuilder _text;

        XElement(String sName, String qName, Attributes attrs) {
            this._name = sName;
            if (this._name == null || this._name.isEmpty()) {
                this._name = qName;
            }
            if (attrs != null) {
                for (int i = 0; i < attrs.getLength(); ++i) {
                    String aName = attrs.getLocalName(i);
                    if (aName == null || aName.isEmpty()) {
                        aName = attrs.getQName(i);
                    }
                    this._attrs.put(aName, attrs.getValue(i));
                }
            }
        }
    }
}

