/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.util.xmlparser;

import com.dassault.cecilia.lib.util.xmlparser.SAXExtendedHandler;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class SAXProcessParser {
    private Writer _MsgWriter;
    private File _XMLFile;
    private File _traceFile;
    private SAXExtendedHandler _handler;

    public SAXProcessParser(File XMLFile, File traceFile) {
        this._XMLFile = XMLFile;
        this._traceFile = traceFile;
        this._MsgWriter = null;
        this._handler = null;
    }

    public boolean action() throws SAXParseException {
        return this._DoAction();
    }

    protected abstract SAXExtendedHandler createSAXHandler();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _DoAction() throws SAXParseException {
        boolean result = false;
        try {
            SAXParserFactory fabrique = SAXParserFactory.newInstance();
            fabrique.setNamespaceAware(true);
            this._handler = this.createSAXHandler();
            SAXParser parseur = fabrique.newSAXParser();
            parseur.parse(this._XMLFile, (DefaultHandler)this._handler);
            result = true;
        }
        catch (IOException e) {
            this.trace(e);
        }
        catch (ParserConfigurationException e) {
            this.trace(e);
        }
        catch (SAXParseException e) {
            this.trace(e);
            throw e;
        }
        catch (SAXException e) {
            this.trace(e);
        }
        finally {
            if (this._MsgWriter != null) {
                try {
                    this._MsgWriter.flush();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
        return result;
    }

    protected void trace(Exception e) throws SAXParseException {
        StringBuffer sb = new StringBuffer(128);
        sb.append(e.getClass().getSimpleName());
        sb.append(" : ");
        sb.append(e.getMessage());
        sb.append("\n");
        Locator locator = this.getLocator();
        if (locator != null) {
            sb.append("\t");
            sb.append(this._XMLFile.getAbsolutePath());
            sb.append(":");
            sb.append(Integer.toString(locator.getLineNumber()));
            sb.append(":");
            sb.append(Integer.toString(locator.getColumnNumber()));
            sb.append("\n");
        }
        this.trace(sb.toString());
    }

    protected void trace(String msg) throws SAXParseException {
        try {
            if (this._MsgWriter == null) {
                if (this._traceFile == null) {
                    this._MsgWriter = new Writer(){

                        @Override
                        public void write(char[] cbuf, int off, int len) throws IOException {
                            System.err.append(new String(cbuf, off, len));
                        }

                        @Override
                        public void flush() throws IOException {
                            System.err.flush();
                        }

                        @Override
                        public void close() throws IOException {
                            System.err.flush();
                        }
                    };
                } else {
                    if (!this._traceFile.canWrite()) {
                        throw new SAXParseException("File trace can not write", null);
                    }
                    this._MsgWriter = new BufferedWriter(new FileWriter(this._traceFile));
                }
            }
            this._MsgWriter.write(msg);
        }
        catch (IOException ioe) {
            throw new SAXParseException("...", this.getLocator(), ioe);
        }
    }

    protected Locator getLocator() {
        Locator locator = null;
        if (this._handler != null) {
            locator = this._handler._locator;
        }
        return locator;
    }
}

