/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.abc;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.plugin.PlugableAppl;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.dbobj.CeciliaFactory;
import com.dassault.cecilia.dbobj.project.CriticityCriterion;
import com.dassault.cecilia.dbobj.project.DBProject;
import com.dassault.cecilia.lib.util.io.IndentWriter;
import com.dassault.cecilia.plugin.mbsa.viewer.TargetModel;
import com.dassault.cecilia.plugin.mbsa.viewer.TargetsTableModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.w3c.dom.Element;

public class ABCTargetModel
extends TargetModel {
    public static final int CRITICITY = 2;
    protected CriticityCriterion _criticity;
    private static final String CRITICITY_XML = "criticity";

    public CriticityCriterion getCriticity() {
        return this._criticity;
    }

    @Override
    public int getColumnCount() {
        return super.getColumnCount() + 1;
    }

    @Override
    public String getColumnName(int c) {
        if (c == 2) {
            return ResMsgVoc.getString((String)"VOC_CRITICITY");
        }
        return super.getColumnName(c);
    }

    @Override
    public Object clone() {
        ABCTargetModel clone = new ABCTargetModel();
        clone.copy(this);
        return clone;
    }

    protected void copy(ABCTargetModel model) {
        super.copy(model);
        this._criticity = model._criticity;
    }

    @Override
    public Class<?> getColumnClass(int c) {
        if (c == 2) {
            return CriticityCriterion.class;
        }
        return super.getColumnClass(c);
    }

    @Override
    public TableCellEditor getEditor(int c) {
        if (c == 2) {
            return new CriticityCellEditor();
        }
        return super.getEditor(c);
    }

    @Override
    public boolean setValueAt(Object item, int c) {
        if (c == 2) {
            this._criticity = (CriticityCriterion)item;
        } else {
            boolean pathDBChanged;
            boolean bl = pathDBChanged = c == 1 && this._outputType == 1 && item != null && !item.toString().equals(this._pathTreeName);
            if (pathDBChanged) {
                this._criticity = null;
            }
        }
        return super.setValueAt(item, c);
    }

    @Override
    public Object getValueAt(int c) {
        if (c == 2) {
            return this._criticity;
        }
        return super.getValueAt(c);
    }

    @Override
    public boolean isCellEditable(int c) {
        if (c == 2) {
            return this.getValueAt(1) != null && this.isDBPath(this.getValueAt(1).toString()) && this.getPlugable() != null;
        }
        return super.isCellEditable(c);
    }

    @Override
    public void saveProperties(IndentWriter out) throws IOException {
        super.saveProperties(out);
        if (this._outputType == 1 && this._criticity != null) {
            out.write(" ");
            out.write(CRITICITY_XML);
            out.write("=\"");
            out.write(this._criticity.getName());
            out.write("\"");
        }
    }

    @Override
    public void load(Element xmlTgt, TargetModel defTgt, int outputType) {
        super.load(xmlTgt, defTgt, outputType);
        if (this._outputType == 1) {
            String criticityStr = xmlTgt.getAttribute(CRITICITY_XML);
            if (criticityStr == null || criticityStr.isEmpty()) {
                return;
            }
            List<CriticityCriterion> criticities = this.getListCriticityFromPath(this._pathTreeName);
            if (criticities == null) {
                return;
            }
            for (CriticityCriterion criticity : criticities) {
                if (!criticity.getName().equals(criticityStr)) continue;
                this._criticity = criticity;
                break;
            }
        }
    }

    public final List<CriticityCriterion> getListCriticityFromPath(String pathTree) {
        if (pathTree == null) {
            return null;
        }
        StringTokenizer tokens = new StringTokenizer(pathTree, "/");
        if (!tokens.hasMoreTokens()) {
            return null;
        }
        String projectName = tokens.nextToken();
        PlugableAppl appl = this.getPlugable().getAppl();
        if (appl == null) {
            return null;
        }
        DAOFactory daoFactory = appl.getDAOFactory();
        if (!(daoFactory instanceof CeciliaFactory)) {
            return null;
        }
        DAOFolder daoFolder = daoFactory.createFolderDAO();
        DBFolder dbFolder = daoFolder.getRootID("PROJECTS");
        DBFolder dBFolder = dbFolder = dbFolder != null ? dbFolder.findChild(projectName) : null;
        if (dbFolder == null) {
            return null;
        }
        DBProject project = (DBProject)((CeciliaFactory)daoFactory).findOrCreateWrap(dbFolder);
        return project.getCriticityCriterium();
    }

    public class CriticityCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private CriticityCriterion _crit;

        @Override
        public Object getCellEditorValue() {
            return this._crit;
        }

        public void resetCriticity() {
            this._crit = null;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value instanceof CriticityCriterion) {
                this._crit = (CriticityCriterion)value;
            }
            JComboBox<Object> comboCriticity = new JComboBox<Object>();
            TargetsTableModel model = (TargetsTableModel)((Object)table.getModel());
            String pathTree = model.getItemAt(row) != null && ((TargetModel)model.getItemAt(row)).getValueAt(1) != null ? ((TargetModel)model.getItemAt(row)).getValueAt(1).toString() : null;
            List<CriticityCriterion> listCrits = ABCTargetModel.this.getListCriticityFromPath(pathTree);
            if (listCrits == null) {
                return null;
            }
            comboCriticity.addItem(null);
            if (listCrits != null) {
                for (CriticityCriterion criticity : listCrits) {
                    comboCriticity.addItem(criticity);
                }
                comboCriticity.setSelectedItem(this._crit);
            }
            comboCriticity.addActionListener(this);
            if (isSelected) {
                comboCriticity.setBackground(table.getSelectionBackground());
            } else {
                comboCriticity.setBackground(table.getSelectionForeground());
            }
            comboCriticity.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<? extends Object> list, Object objValue, int index, boolean selected, boolean cellHasFocus) {
                    super.getListCellRendererComponent(list, objValue, index, selected, cellHasFocus);
                    if (objValue == null) {
                        this.setText(" ");
                    } else {
                        CriticityCriterion crit = (CriticityCriterion)objValue;
                        this.setText(crit == null ? "" : crit.getName());
                    }
                    return this;
                }
            });
            return comboCriticity;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JComboBox comboCriticity = (JComboBox)event.getSource();
            this._crit = (CriticityCriterion)comboCriticity.getSelectedItem();
            this.stopCellEditing();
        }
    }
}

