/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.abc;

import com.dassault.cecilia.core.cecilia.stepper.ViewStepper;
import com.dassault.cecilia.core.plugin.AbstractPlugTaskBanWithLog;
import com.dassault.cecilia.core.plugin.AbstractPluginWithStepper;
import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.PlugTask;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableProxyModel;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.core.plugin.PluginMAction;
import com.dassault.cecilia.core.plugin.PluginMTranslate;
import com.dassault.cecilia.core.plugin.PluginModel;
import com.dassault.cecilia.core.plugin.Translator;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.lib.ban.BanEntry;
import com.dassault.cecilia.lib.ban.BanInputStream;
import com.dassault.cecilia.lib.mbsa.Stepper;
import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.lib.util.io.FileUtility;
import com.dassault.cecilia.plugin.mbsa.abc.ABCTargetModel;
import com.dassault.cecilia.plugin.mbsa.abc.DlgTargetsABCTree;
import com.dassault.cecilia.plugin.mbsa.abc.ResABC;
import com.dassault.cecilia.plugin.mbsa.abc.UtilityPluginTargetsABC;
import com.dassault.cecilia.plugin.mbsa.viewer.DefaultFileFilter;
import com.dassault.cecilia.plugin.mbsa.viewer.DlgTargetsSelection;
import com.dassault.cecilia.plugin.mbsa.viewer.TargetModel;
import com.dassault.cecilia.plugin.mbsa.viewer.UtilityPluginTargetsDB;
import com.dassault.cecilia.plugin.mbsa.viewer.ban.BatchTreeImport;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PluginCmdABCTree
extends AbstractPluginWithStepper
implements PluginMAction {
    private static Logger _LOG = Logger.getLogger(PluginCmdABCTree.class.getPackage().getName());
    static final String OPT_ALGO = PluginCmdABCTree.class.getName() + "#Algo";
    static final String OPT_SIMPLIFY = PluginCmdABCTree.class.getName() + "#Simplify";
    static final String OPT_EXEC = PluginCmdABCTree.class.getName() + "#Execute";
    static final String OPT_FORMAT = PluginCmdABCTree.class.getName() + "#Format";
    static final String OPT_LOG_FORMAT = PluginCmdABCTree.class.getName() + "#LogFormat";
    static final String OPT_POST_PROCESS = PluginCmdABCTree.class.getName() + "#PostProcess";
    ABCTreeOptsPanel _opts = null;
    private static final String DEPEND_TRANSLATOR = "com.dassault.cecilia.plugin.mbsa.translator.TranslatePluginDataFlow";
    private static final String DEPEND_CMD = "com.dassault.cecilia.plugin.mbsa.viewer.PluginCmdViewStepper";
    private static File __executable;

    public String getInfo(String key) {
        if (key.equals("plugin.name")) {
            return ResABC.getString("PLUG_CMD_ABCTREE_NAME");
        }
        if (key.equals("plugin.description") || key.equals("plugin.tooltip")) {
            return ResABC.getString("PLUG_CMD_ABCTREE_DESC");
        }
        if (key.equals("type")) {
            return "PluginAction";
        }
        if (key.equals("plugin.shortcut")) {
            return "alt T";
        }
        return super.getInfo(key);
    }

    public Icon getIcon(String key) {
        if (key.equals("plugin.default")) {
            return ResIcoAbstract.getIconRes((URL)((Object)((Object)this)).getClass().getResource("B-01.svg"));
        }
        return super.getIcon(key);
    }

    public boolean withOption(Plugable plugable) {
        return true;
    }

    public PlugPanel displayOption(Plugable launcher) {
        if (this._opts == null) {
            this._opts = new ABCTreeOptsPanel();
        }
        this._opts.prepareWith(launcher);
        return this._opts;
    }

    public void refreshOptions(Plugable launcher) {
        if (this._opts != null) {
            this._opts.prepareWith(launcher);
        }
    }

    protected boolean verifyConfigPlugin(Plugable launcher) {
        File file = this.getFileExecutable(launcher);
        if (file == null) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launcher.getWindow()), ResABC.getString("ERR_ABC_LAUNCH"), ResABC.getString("DEF_TITLE"), 0);
            return false;
        }
        return true;
    }

    protected boolean isStepperOptional() {
        return true;
    }

    public void createSession(Plugable launch, Object parameters) {
        DlgTargetsSelection dlg;
        PlugableProxyModel launcher = new PlugableProxyModel(launch);
        if (!this.verifyConfigPlugin((Plugable)launcher)) {
            return;
        }
        PluginModel pluginCmd = launcher.getPlugin(DEPEND_CMD);
        if (pluginCmd == null) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launcher.getWindow()), ResABC.getString("ERR_DEPEND_PLUGIN") + "\n   [com.dassault.cecilia.plugin.mbsa.viewer.PluginCmdViewStepper]", ResABC.getString("DEF_TITLE"), 0);
            return;
        }
        File fileDFlow = this.createFile((Plugable)launcher, this.getID(), ".alt");
        if (fileDFlow == null) {
            return;
        }
        fileDFlow.deleteOnExit();
        File logFile = this.createFile((Plugable)launcher, this.getID(), ".log");
        if (logFile == null) {
            return;
        }
        logFile.deleteOnExit();
        IModel model = launcher.getModel("altarica.file");
        if (model == null) {
            return;
        }
        Stepper stepper = null;
        if (parameters instanceof String && ((String)parameters).length() > 0) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("altr.altax.enable", "true");
            params.put("altr.altax.output", fileDFlow.getAbsolutePath());
            params.put("altr.verify.before.add", "Expr,ExprInt,ExprFloat");
            stepper = this.createStepper((Plugable)launcher, new AbstractPluginWithStepper.InfoStepper((String)parameters, model, params));
            if (stepper == null) {
                return;
            }
            if (!fileDFlow.isFile() || fileDFlow.length() == 0L) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launcher.getWindow()), ResABC.getString("ERR_DEPEND_STEPPER") + "\n   [" + parameters + "]", ResABC.getString("DEF_TITLE"), 0);
                return;
            }
        } else {
            PluginModel plugTrans = launcher.getPlugin(DEPEND_TRANSLATOR);
            if (plugTrans == null || !(plugTrans instanceof PluginMTranslate)) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launcher.getWindow()), ResABC.getString("ERR_DEPEND_TRANSLATE") + "\n   [com.dassault.cecilia.plugin.mbsa.translator.TranslatePluginDataFlow]", ResABC.getString("DEF_TITLE"), 0);
                return;
            }
            HashMap<String, String> paramsAdd = new HashMap<String, String>();
            paramsAdd.put("altr.verify.before.add", "Expr,ExprInt,ExprFloat");
            Translator trans = ((PluginMTranslate)plugTrans).createTranslator((Plugable)launcher, paramsAdd);
            if (trans == null) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launcher.getWindow()), ResABC.getString("ERR_TRANSLATOR"), ResABC.getString("DEF_TITLE"), 0);
                return;
            }
            if (!trans.translate(fileDFlow, true)) {
                return;
            }
        }
        if ((dlg = this.createComputeOpts((Plugable)launcher, stepper)) == null) {
            return;
        }
        InputStream baseScript = this.getBaseScript();
        if (baseScript == null) {
            return;
        }
        UtilityPluginTargetsDB util = this.createUtilityPluginTargets(dlg.getTargets(), dlg.getDbOutputSelection());
        BanInputStream script = util.createBanScript((Plugable)launcher, this.getID(), baseScript, logFile);
        if (script == null) {
            return;
        }
        BanEntry entry = util.createBanEntry((Plugable)launcher, null);
        if (entry == null) {
            return;
        }
        entry.addUnit(BatchTreeImport.class);
        entry.setUserProperty("ban.log.path", logFile.getAbsolutePath());
        entry.setUserProperty("a2b.input", fileDFlow.getAbsolutePath());
        AbstractPlugTaskBanWithLog task = this.createPlugTask((Plugable)launcher, model, entry, script, logFile);
        launcher.addTask((PlugTask)task, model.getUID());
    }

    protected DlgTargetsSelection createComputeOpts(Plugable launcher, Stepper stepper) {
        ViewStepper viewStepper = null;
        if (stepper != null) {
            viewStepper = new ViewStepper();
            try {
                viewStepper.open(stepper);
            }
            catch (StepperException e) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launcher.getWindow()), ResABC.getString("ERR_STEPPER_EXC") + "\n" + e.getMessage(), this.getInfo("plugin.name"), 0);
                return null;
            }
            viewStepper.getRoot().setWithDomain(true);
        }
        ABCTargetModel defTgt = new ABCTargetModel();
        defTgt.defineDefault(launcher, viewStepper, new DefaultFileFilter(){

            @Override
            public boolean accept(File f) {
                String fname = f.getName().toLowerCase();
                return fname.endsWith(".ara") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Aralia File(*.ara)";
            }

            @Override
            public String getDefaultExtension() {
                return ".ara";
            }
        });
        StringBuilder sb = new StringBuilder(128);
        sb.append(ResABC.getString("PRV_CMD_ABCTREE_TITLE"));
        sb.append(" (").append(this.getID()).append(")");
        DlgTargetsABCTree dlg = new DlgTargetsABCTree(launcher.getWindow(), sb.toString());
        dlg.create(defTgt);
        dlg.enableDbOutput(launcher.getAppl() != null && !launcher.getAppl().isReader());
        if (!dlg.doModal(launcher)) {
            dlg = null;
        }
        if (stepper != null) {
            viewStepper.close();
        }
        return dlg;
    }

    protected UtilityPluginTargetsDB createUtilityPluginTargets(List<TargetModel> targets, String dbConflictOption) {
        return new UtilityPluginTargetsABC(this, targets, dbConflictOption);
    }

    protected String getID() {
        return "ABC";
    }

    private static File getPrivateFileExecutable() {
        block5: {
            if (__executable == null) {
                Object name = "abc.";
                String os = System.getProperty("os.name");
                name = os.contains("Win") ? (String)name + "win" : (String)name + os;
                InputStream input = PluginCmdABCTree.class.getResourceAsStream((String)name);
                if (input == null) {
                    return null;
                }
                File tmpFile = null;
                try {
                    tmpFile = File.createTempFile("AltaExt", ".dfw");
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tmpFile));
                    BufferedInputStream in = new BufferedInputStream(input);
                    int len = 4096;
                    byte[] read = new byte[len];
                    while ((len = in.read(read)) > 0) {
                        out.write(read, 0, len);
                    }
                    out.flush();
                    out.close();
                    in.close();
                    __executable = tmpFile;
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        @Override
                        public void run() {
                            if (__executable == null) {
                                return;
                            }
                            if (!__executable.delete()) {
                                _LOG.fine("Resource not delete");
                                __executable.deleteOnExit();
                            }
                            __executable = null;
                        }
                    });
                }
                catch (IOException e) {
                    _LOG.log(Level.FINE, "Error during copy resource", e);
                    if (tmpFile == null || !tmpFile.exists() || tmpFile.delete()) break block5;
                    tmpFile.deleteOnExit();
                }
            }
        }
        return __executable;
    }

    protected File getFileExecutable(Plugable launch) {
        File result = FileUtility.findExecute((String)PlugableUtility.getStrOpt((Plugable)launch, (String)OPT_EXEC, null), (boolean)true, (String)"abc", PluginCmdABCTree.class);
        if (result == null && ((Object)((Object)this)).getClass() == PluginCmdABCTree.class) {
            return PluginCmdABCTree.getPrivateFileExecutable();
        }
        return result;
    }

    protected InputStream getBaseScript() {
        InputStream baseScript = ((Object)((Object)this)).getClass().getResourceAsStream("BanScriptABC.xml");
        if (baseScript == null) {
            _LOG.log(Level.SEVERE, "Resource script not found : BanScriptABC.xml");
            return null;
        }
        return baseScript;
    }

    protected AbstractPlugTaskBanWithLog createPlugTask(final Plugable launcher, IModel model, BanEntry entry, BanInputStream script, File logFile) {
        return new AbstractPlugTaskBanWithLog(model.getUID(), launcher, entry, script, logFile){

            protected String getDesc() {
                return ResABC.getString("PLUG_CMD_ABCTREE_NAME");
            }

            protected String getName() {
                return "ABCTree";
            }

            public Icon getIcon(String key) {
                if (key.equals("ptask.icon")) {
                    return ResIcoAbstract.getIconRes((URL)((Object)((Object)this)).getClass().getResource("B-01.svg"));
                }
                return super.getIcon(key);
            }

            protected void displayResult(File pathInfo, boolean endTrace) {
                super.displayResult(pathInfo, endTrace);
                launcher.getAppl().refreshDAOFolder();
                launcher.getAppl().refreshFolders(true);
            }
        };
    }

    class ABCTreeOptsPanel
    extends JPanel
    implements PlugPanel {
        Plugable _launcher;
        JLabel _lblExec;
        JTextField _ctrlExec;

        public void prepareWith(Plugable launcher) {
            this._launcher = launcher;
            this._ctrlExec.setText(PlugableUtility.getStrOpt((Plugable)this._launcher, (String)OPT_EXEC, (String)""));
        }

        public ABCTreeOptsPanel() {
            super(new GridBagLayout());
            this._launcher = null;
            this._lblExec = new JLabel(ResABC.getString("DLG_CMD_ABCTREE_EXEC"));
            this._ctrlExec = new JTextField(40);
            this._ctrlExec.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    ABCTreeOptsPanel.this._launcher.setOption(OPT_EXEC, ABCTreeOptsPanel.this._ctrlExec.getText());
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
            this.add((Component)this._lblExec, new GridBagConstraints(0, 0, 1, 1, 100.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this._ctrlExec, new GridBagConstraints(0, 1, 1, 1, 100.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        }

        public Component getPanel() {
            return this;
        }

        public void trash() {
        }

        public String getInfo(String key) {
            return PluginCmdABCTree.this.getInfo(key);
        }

        public Icon getIcon(String key) {
            return null;
        }
    }
}

