/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.abc;

import com.dassault.cecilia.core.plugin.PanelSelectProcess;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.core.plugin.PluginMProcess;
import com.dassault.cecilia.core.plugin.PluginManager;
import com.dassault.cecilia.lib.util.io.IndentWriter;
import com.dassault.cecilia.plugin.mbsa.abc.PluginCmdABCTree;
import com.dassault.cecilia.plugin.mbsa.abc.ResABC;
import com.dassault.cecilia.plugin.mbsa.viewer.TargetModel;
import com.dassault.cecilia.plugin.mbsa.viewer.TargetsPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Element;

public class TargetsABCTreePanel
extends TargetsPanel {
    private JComboBox<Algo> _ctrlAlgorithm;
    private JComboBox<Simplify> _ctrlSimplify;
    protected PanelSelectProcess _ctrlPostProcess;
    private static final String XML_ELEM_ABC = "abc";
    private static final String XML_ATTR_ALGO = "algorithm";
    private static final String XML_ATTR_REWRITE = "rewrite";

    public TargetsABCTreePanel(String title, TargetModel def) {
        super(def, title);
    }

    @Override
    protected JPanel createOtherInfoPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        result.add((Component)this.createOptionsGenerate(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        result.add((Component)this.createPostProcess(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 15, 2, new Insets(5, 5, 5, 5), 0, 0));
        return result;
    }

    @Override
    public void copyToCtrl(Plugable launcher) {
        super.copyToCtrl(launcher);
        String algo = launcher.getOption(PluginCmdABCTree.OPT_ALGO);
        if (algo != null) {
            for (int i = this._ctrlAlgorithm.getItemCount() - 1; i >= 0; --i) {
                if (!algo.equals(this._ctrlAlgorithm.getItemAt(i).getCode())) continue;
                this._ctrlAlgorithm.setSelectedIndex(i);
                break;
            }
        }
        int lvl = PlugableUtility.getIntOpt((Plugable)launcher, (String)PluginCmdABCTree.OPT_SIMPLIFY, (int)0);
        this._ctrlSimplify.setSelectedIndex(0);
        for (int i = this._ctrlSimplify.getItemCount() - 1; i >= 0; --i) {
            if (lvl != this._ctrlSimplify.getItemAt(i).getLvl()) continue;
            this._ctrlSimplify.setSelectedIndex(i);
            break;
        }
        this._ctrlPostProcess.setPlugable((PluginManager)launcher);
        this._ctrlPostProcess.setFilter("TreeGen");
        String set = launcher.getOption(PluginCmdABCTree.OPT_POST_PROCESS);
        if (set != null && set.length() > 0) {
            this._ctrlPostProcess.setSelectProcessFromKey(set);
        }
    }

    @Override
    public void copyFromCtrl(Plugable launcher) {
        super.copyFromCtrl(launcher);
        launcher.setOption(PluginCmdABCTree.OPT_ALGO, ((Algo)((Object)this._ctrlAlgorithm.getSelectedItem())).getCode());
        launcher.setOption(PluginCmdABCTree.OPT_SIMPLIFY, Integer.toString(((Simplify)((Object)this._ctrlSimplify.getSelectedItem())).getLvl()));
        PluginMProcess plugin = this._ctrlPostProcess.getSelectProcess();
        launcher.setOption(PluginCmdABCTree.OPT_POST_PROCESS, plugin == null ? "" : plugin.getInfo("plugin.key"));
    }

    @Override
    public void processEraseFile(List<File> eraseFile, File file) {
        if (!this.overwriteFile()) {
            eraseFile.add(file);
        }
    }

    protected JPanel createOptionsGenerate() {
        JPanel result = new JPanel(new GridBagLayout());
        result.setBorder(BorderFactory.createTitledBorder(ResABC.getString("PRV_CMD_ABCTREE_OPTIONS")));
        result.add((Component)new JLabel(ResABC.getString("PRV_CMD_ABCTREE_ALGO")), new GridBagConstraints(0, 0, 1, 1, 100.0, 100.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._ctrlAlgorithm = new JComboBox();
        if (Boolean.getBoolean("cecilia.core.debug")) {
            this._ctrlAlgorithm.addItem(Algo.GROUP);
            this._ctrlAlgorithm.addItem(Algo.REACH);
        }
        this._ctrlAlgorithm.addItem(Algo.SOP);
        this._ctrlAlgorithm.addItem(Algo.ITE);
        this._ctrlAlgorithm.setEditable(false);
        result.add(this._ctrlAlgorithm, new GridBagConstraints(1, 0, 1, 1, 100.0, 100.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this._ctrlAlgorithm.setSelectedIndex(this._ctrlAlgorithm.getItemCount() - 1);
        result.add((Component)new JLabel(ResABC.getString("PRV_CMD_ABCTREE_SIMPLIFY")), new GridBagConstraints(0, 1, 1, 1, 100.0, 100.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._ctrlSimplify = new JComboBox();
        this._ctrlSimplify.addItem(Simplify.LVL0);
        this._ctrlSimplify.addItem(Simplify.LVL1);
        this._ctrlSimplify.addItem(Simplify.LVL2);
        this._ctrlSimplify.setEditable(false);
        result.add(this._ctrlSimplify, new GridBagConstraints(1, 1, 1, 1, 100.0, 100.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        return result;
    }

    protected JComponent createPostProcess() {
        this._ctrlPostProcess = new PanelSelectProcess(true);
        return this._ctrlPostProcess;
    }

    @Override
    protected void doLoad(Element root) throws IOException {
        Enum opt;
        super.doLoad(root);
        Element abcNode = this.getElement(root, XML_ELEM_ABC);
        if (abcNode == null) {
            return;
        }
        String value = this.getAttrValue(abcNode, XML_ATTR_ALGO);
        if (value != null && !value.isEmpty()) {
            opt = null;
            try {
                opt = Algo.valueOf(value.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new IOException("Bad value attribute abc@algorithm: " + value);
            }
            this._ctrlAlgorithm.setSelectedItem(opt);
        }
        if ((value = this.getAttrValue(abcNode, XML_ATTR_REWRITE)) != null && !value.isEmpty()) {
            opt = null;
            try {
                opt = Simplify.valueOf(value.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new IOException("Bad value attribute abc@rewrite: " + value);
            }
            this._ctrlSimplify.setSelectedItem(opt);
        }
        this._ctrlPostProcess.doLoad(root);
    }

    @Override
    protected void doSave(IndentWriter writer) throws IOException {
        super.doSave(writer);
        writer.write("<");
        writer.write(XML_ELEM_ABC);
        writer.write(" ");
        writer.writeAttrWithValue(XML_ATTR_ALGO, ((Algo)((Object)this._ctrlAlgorithm.getSelectedItem())).name().toLowerCase());
        writer.writeAttrWithValue(XML_ATTR_REWRITE, ((Simplify)((Object)this._ctrlSimplify.getSelectedItem())).name().toLowerCase());
        writer.write("/>\n");
        this._ctrlPostProcess.doSave(writer);
    }

    static enum Algo {
        GROUP("PRV_CMD_ABCTREE_ALGO_GROUP"),
        REACH("PRV_CMD_ABCTREE_ALGO_REACH"),
        SOP("PRV_CMD_ABCTREE_ALGO_SOP"),
        ITE("PRV_CMD_ABCTREE_ALGO_ITE");

        String _key;

        private Algo(String key) {
            this._key = key;
        }

        public String toString() {
            return ResABC.getString(this._key);
        }

        public String getCode() {
            return super.toString();
        }
    }

    static enum Simplify {
        LVL0("PRV_CMD_ABCTREE_SIMPLIFY_LVL0", 0),
        LVL1("PRV_CMD_ABCTREE_SIMPLIFY_LVL1", 1),
        LVL2("PRV_CMD_ABCTREE_SIMPLIFY_LVL2", 2);

        String _key;
        int _lvl;

        private Simplify(String key, int lvl) {
            this._key = key;
            this._lvl = lvl;
        }

        public String toString() {
            return ResABC.getString(this._key);
        }

        public String getCode() {
            return super.toString();
        }

        public int getLvl() {
            return this._lvl;
        }
    }
}

